/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyReferenceReadHandler;
import org.pentaho.reporting.engine.classic.core.parameters.ModifiableReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.PlainParameter;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class FunctionsReadHandler
extends AbstractPropertyXmlReadHandler {
    private static Log logger = LogFactory.getLog(FunctionsReadHandler.class);
    private AbstractReportDefinition report;
    private ArrayList<ExpressionReadHandler> expressionHandlers;
    private ArrayList<PropertyReferenceReadHandler> propertyRefs;

    public FunctionsReadHandler(AbstractReportDefinition report) {
        this.report = report;
        this.expressionHandlers = new ArrayList();
        this.propertyRefs = new ArrayList();
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes attrs) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("expression".equals(tagName) || "function".equals(tagName)) {
            ExpressionReadHandler readHandler = new ExpressionReadHandler();
            this.expressionHandlers.add(readHandler);
            return readHandler;
        }
        if ("property-ref".equals(tagName)) {
            PropertyReferenceReadHandler readHandler = new PropertyReferenceReadHandler();
            this.propertyRefs.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.expressionHandlers.size(); ++i) {
            ExpressionReadHandler readHandler = this.expressionHandlers.get(i);
            if (readHandler.getObject() == null) continue;
            this.report.addExpression((Expression)readHandler.getObject());
        }
        MasterReport master = this.report instanceof MasterReport ? (MasterReport)this.report : null;
        for (int i = 0; i < this.propertyRefs.size(); ++i) {
            String text;
            PropertyReferenceReadHandler readHandler = this.propertyRefs.get(i);
            Object object = readHandler.getObject();
            if (object == null || object instanceof String && (text = (String)object).length() == 0) continue;
            if (master != null) {
                ParameterDefinitionEntry[] parameterDefinitions = master.getParameterDefinition().getParameterDefinitions();
                boolean foundParameter = false;
                for (int j = 0; j < parameterDefinitions.length; ++j) {
                    ParameterDefinitionEntry definition = parameterDefinitions[j];
                    if (!readHandler.getPropertyName().equals(definition.getName())) continue;
                    foundParameter = true;
                    break;
                }
                if (!foundParameter && master.getParameterDefinition() instanceof ModifiableReportParameterDefinition) {
                    ModifiableReportParameterDefinition parameterDefinition = (ModifiableReportParameterDefinition)master.getParameterDefinition();
                    parameterDefinition.addParameterDefinition(new PlainParameter(readHandler.getPropertyName()));
                }
                master.getParameterValues().put(readHandler.getPropertyName(), object);
                continue;
            }
            logger.warn((Object)("Subreports are not supposed to have parameter nor report properties. Ignoring definition for '" + readHandler.getPropertyName() + "."));
        }
    }

    public Object getObject() {
        return null;
    }
}

