/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.survey;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class SurveyScaleLegendItem {
    private Shape shape;
    private String label;
    private boolean draw;
    private boolean fill;
    private Font font;

    public SurveyScaleLegendItem() {
        this.font = new Font("Serif", 2, 10);
    }

    public SurveyScaleLegendItem(Shape shape, String label, boolean draw, boolean fill) {
        this.shape = shape;
        this.label = label;
        this.draw = draw;
        this.fill = fill;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        if (this.shape == null || this.font == null || this.label == null) {
            return;
        }
        if (!this.draw && !this.fill) {
            return;
        }
        Rectangle2D b = this.shape.getBounds2D();
        double x = area.getMinX() + b.getWidth() / 2.0 + 1.0;
        double y = area.getCenterY();
        Shape s = this.getShape();
        g2.translate(x, y);
        g2.setPaint(Color.black);
        if (this.draw) {
            g2.setStroke(new BasicStroke(0.5f));
            g2.draw(s);
        }
        if (this.fill) {
            g2.fill(s);
        }
        g2.translate(-x, -y);
        x += b.getWidth() / 2.0 + 3.0;
        g2.setFont(this.font);
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = g2.getFont();
        LineMetrics metrics = f.getLineMetrics(this.label, frc);
        float ascent = metrics.getAscent();
        float halfAscent = ascent / 2.0f;
        g2.drawString(this.label, (float)x, (float)(y + (double)halfAscent));
    }

    public boolean isDraw() {
        return this.draw;
    }

    public void setDraw(boolean draw) {
        this.draw = draw;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }
}

