/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class RenderLength {
    public static final RenderLength AUTO = new RenderLength(Long.MIN_VALUE, false);
    public static final RenderLength EMPTY = new RenderLength(0L, false);
    private long value;
    private boolean percentage;

    public RenderLength(long value, boolean percentage) {
        this.value = value;
        this.percentage = percentage;
    }

    public long getValue() {
        return this.value;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderLength that = (RenderLength)o;
        if (this.percentage != that.percentage) {
            return false;
        }
        return this.value == that.value;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 29 * result + (this.percentage ? 1 : 0);
        return result;
    }

    public strictfp long resolve(long parent) {
        if (this.isPercentage()) {
            return StrictMath.round((double)StrictGeomUtility.multiply(this.value, parent) / 100.0);
        }
        if (this.value == Long.MIN_VALUE) {
            return 0L;
        }
        return this.value;
    }

    public strictfp long resolve(long parent, long auto) {
        if (this.isPercentage()) {
            return StrictMath.round((double)StrictGeomUtility.multiply(this.value, parent) / 100.0);
        }
        if (this.value == Long.MIN_VALUE) {
            return auto;
        }
        return this.value;
    }

    public static strictfp long resolveLength(long parent, double rawvalue) {
        long value = StrictGeomUtility.toInternalValue(rawvalue);
        if (value == Long.MIN_VALUE) {
            return 0L;
        }
        if (value < 0L) {
            return -StrictMath.round((double)StrictGeomUtility.multiply(value, parent) / 100.0);
        }
        return value;
    }

    public static RenderLength createFromRaw(double rawValue) {
        if (rawValue <= -9.223372036854776E18) {
            return AUTO;
        }
        if (rawValue < 0.0) {
            return new RenderLength(StrictGeomUtility.toInternalValue(-rawValue), true);
        }
        if (rawValue == 0.0) {
            return EMPTY;
        }
        return new RenderLength(StrictGeomUtility.toInternalValue(rawValue), false);
    }

    public static RenderLength createPercentage(double rawValue) {
        if (rawValue <= -9.223372036854776E18 || rawValue >= 9.223372036854776E18) {
            throw new IllegalArgumentException();
        }
        if (rawValue < 0.0) {
            throw new IllegalArgumentException();
        }
        if (rawValue == 0.0) {
            return EMPTY;
        }
        return new RenderLength(StrictGeomUtility.toInternalValue(rawValue), true);
    }

    public strictfp RenderLength resolveToRenderLength(long parent) {
        if (this.isPercentage()) {
            if (parent <= 0L) {
                return AUTO;
            }
            long value = (int)StrictMath.round((double)StrictGeomUtility.multiply(this.value, parent) / 100.0);
            return new RenderLength(value, false);
        }
        if (this.value <= 0L) {
            return AUTO;
        }
        return new RenderLength(this.value, false);
    }

    public String toString() {
        if (this.value == Long.MIN_VALUE) {
            return "RenderLength{value=AUTO}";
        }
        if (this.isPercentage()) {
            return "RenderLength{value=" + StrictGeomUtility.toExternalValue(this.value) + "% }";
        }
        return "RenderLength{value=" + this.value + "micro-pt }";
    }
}

