/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.builders;

import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.encryption.Encryption;
import com.googlecode.jsendnsca.encryption.Encryptor;

public class NagiosSettingsBuilder {
    private final NagiosSettings nagiosSettings = new NagiosSettings();

    public NagiosSettings createDefault() {
        return new NagiosSettings();
    }

    public NagiosSettings create() {
        return this.nagiosSettings;
    }

    public NagiosSettingsBuilder withNagiosHost(String nagiosHost) {
        this.nagiosSettings.setNagiosHost(nagiosHost);
        return this;
    }

    public NagiosSettingsBuilder withPort(int port) {
        this.nagiosSettings.setPort(port);
        return this;
    }

    public NagiosSettingsBuilder withNoPassword() {
        this.nagiosSettings.setPassword("");
        return this;
    }

    public NagiosSettingsBuilder withPassword(String password) {
        this.nagiosSettings.setPassword(password);
        return this;
    }

    public NagiosSettingsBuilder withConnectionTimeout(int connectionTimeout) {
        this.nagiosSettings.setConnectTimeout(connectionTimeout);
        return this;
    }

    public NagiosSettingsBuilder withResponseTimeout(int responseTimeout) {
        this.nagiosSettings.setTimeout(responseTimeout);
        return this;
    }

    public NagiosSettingsBuilder withEncryptor(Encryptor encryptor) {
        this.nagiosSettings.setEncryptor(encryptor);
        return this;
    }

    public NagiosSettingsBuilder withEncryption(Encryption encryption) {
        this.nagiosSettings.setEncryption(encryption);
        return this;
    }
}

