/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.util.DeepCopy;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;

public class Varies
implements Type {
    public static final String DEFAULT_OBX2_TYPE_PROP = "ca.uhn.hl7v2.model.varies.default_obx2_type";
    public static final String INVALID_OBX2_TYPE_PROP = "ca.uhn.hl7v2.model.varies.invalid_obx2_type";
    private static final HapiLog log = HapiLogFactory.getHapiLog(Varies.class);
    private Type data;
    private Message message;

    public Varies(Message message) {
        this.data = new GenericPrimitive(message);
        this.message = message;
    }

    public Type getData() {
        return this.data;
    }

    public String getName() {
        String name = "*";
        if (this.data != null) {
            name = this.data.getName();
        }
        return name;
    }

    public void setData(Type data) throws DataTypeException {
        if (!(this.data == null || this.data instanceof Primitive && ((Primitive)this.data).getValue() == null)) {
            DeepCopy.copy(this.data, data);
        }
        this.data = data;
    }

    public ExtraComponents getExtraComponents() {
        return this.data.getExtraComponents();
    }

    public Message getMessage() {
        return this.message;
    }

    public static void fixOBX5(Segment segment, ModelClassFactory factory) throws HL7Exception {
        try {
            Primitive obx2 = (Primitive)segment.getField(2, 0);
            Type[] reps = segment.getField(5);
            int i = 0;
            while (i < reps.length) {
                String defaultOBX2Type;
                Varies v = (Varies)reps[i];
                if (obx2.getValue() == null && (defaultOBX2Type = System.getProperty(DEFAULT_OBX2_TYPE_PROP)) != null) {
                    log.debug("setting default obx2 type to " + defaultOBX2Type);
                    obx2.setValue(defaultOBX2Type);
                }
                if (obx2.getValue() == null) {
                    if (!(v.getData() == null || v.getData() instanceof Primitive && ((Primitive)v.getData()).getValue() == null)) {
                        throw new HL7Exception("OBX-5 is valued, but OBX-2 is not.  A datatype for OBX-5 must be specified using OBX-2. See JavaDoc for Varies#fixOBX5(Segment, ModelClassFactory)", 101);
                    }
                } else {
                    Type newTypeInstance;
                    String version = segment.getMessage().getVersion();
                    String obx2Value = obx2.getValue();
                    Class<? extends Type> c = factory.getTypeClass(obx2Value, version);
                    if (c == null) {
                        String defaultOBX2Type2 = System.getProperty(INVALID_OBX2_TYPE_PROP);
                        if (defaultOBX2Type2 != null) {
                            c = factory.getTypeClass(defaultOBX2Type2, version);
                        }
                        if (c == null) {
                            Primitive obx1 = (Primitive)segment.getField(1, 0);
                            HL7Exception h = new HL7Exception("'" + obx2.getValue() + "' in record " + obx1.getValue() + " is invalid for version " + version + ". See JavaDoc for Varies#fixOBX5(Segment, ModelClassFactory)", 102);
                            h.setSegmentName("OBX");
                            h.setFieldPosition(2);
                            throw h;
                        }
                    }
                    try {
                        newTypeInstance = c.getConstructor(Message.class).newInstance(v.getMessage());
                    }
                    catch (NoSuchMethodException e) {
                        newTypeInstance = c.getConstructor(Message.class, Integer.class).newInstance(v.getMessage(), 0);
                    }
                    v.setData(newTypeInstance);
                }
                ++i;
            }
        }
        catch (HL7Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new HL7Exception(String.valueOf(e.getClass().getName()) + " trying to set data type of OBX-5", 207, e);
        }
    }

    public void parse(String string) throws HL7Exception {
        this.getMessage().getParser().parse(this, string, EncodingCharacters.getInstance(this.getMessage()));
    }

    public String encode() throws HL7Exception {
        return this.getMessage().getParser().doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    public void clear() {
        this.data.clear();
    }
}

