/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.operation.SQLOperation;

public class SQLOperationDisplay {
    public final String userName;
    public final String executionEngine;
    public final long beginTime;
    public final String operationId;
    public Long endTime;
    public OperationState state;
    public QueryDisplay queryDisplay;

    public SQLOperationDisplay(SQLOperation sqlOperation) throws HiveSQLException {
        this.state = sqlOperation.getState();
        this.userName = sqlOperation.getParentSession().getUserName();
        this.executionEngine = sqlOperation.getConfigForOperation().getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        this.beginTime = System.currentTimeMillis();
        this.operationId = sqlOperation.getHandle().getHandleIdentifier().toString();
    }

    public synchronized long getElapsedTime() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.beginTime;
        }
        return this.endTime - this.beginTime;
    }

    public synchronized boolean isRunning() {
        return this.endTime == null;
    }

    public synchronized QueryDisplay getQueryDisplay() {
        return this.queryDisplay;
    }

    public synchronized void setQueryDisplay(QueryDisplay queryDisplay) {
        this.queryDisplay = queryDisplay;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getExecutionEngine() {
        return this.executionEngine;
    }

    public synchronized OperationState getState() {
        return this.state;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public synchronized Long getEndTime() {
        return this.endTime;
    }

    public synchronized void updateState(OperationState state) {
        this.state = state;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public synchronized void closed() {
        this.endTime = System.currentTimeMillis();
    }
}

