/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BundleActionsGetJPAExecutor
implements JPAExecutor<List<BundleActionBean>> {
    private String bundleId = null;

    public BundleActionsGetJPAExecutor(String bundleId) {
        ParamChecker.notNull(bundleId, "bundleId");
        this.bundleId = bundleId;
    }

    @Override
    public String getName() {
        return "BundleActionsGetJPAExecutor";
    }

    @Override
    public List<BundleActionBean> execute(EntityManager em) throws JPAExecutorException {
        List baBeans;
        try {
            Query q = em.createNamedQuery("GET_BUNDLE_ACTIONS_FOR_BUNDLE");
            q.setParameter("bundleId", (Object)this.bundleId);
            baBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
        return baBeans;
    }
}

