/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class PluginMessageLogger {
    private static ThreadLocal<List<String>> messages = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    public static void clear() {
        messages.get().clear();
    }

    public static void add(String message) {
        messages.get().add(message);
    }

    public static List<String> getAll() {
        return messages.get();
    }

    public static int count(final String messagePrefix) {
        return CollectionUtils.countMatches((Collection)messages.get(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((String)object).startsWith(messagePrefix);
            }
        });
    }

    public static String prettyPrint() {
        StringBuilder builder = new StringBuilder();
        for (String msg : messages.get()) {
            builder.append(msg);
            builder.append('\n');
        }
        return builder.toString();
    }
}

