/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.email;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.pentaho.platform.api.email.IEmailConfiguration;
import org.pentaho.platform.api.email.IEmailService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.email.EmailConfiguration;
import org.pentaho.platform.plugin.services.email.EmailConfigurationXml;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class EmailService
implements IEmailService {
    private static final Messages messages = Messages.getInstance();
    private static final String DEFAULT_EMAIL_CONFIG_PATH = "system" + File.separator + "smtp-email" + File.separator + "email_config.xml";
    private static final Log logger = LogFactory.getLog(EmailService.class);
    private File emailConfigFile;

    public EmailService() throws IllegalArgumentException {
        logger.debug((Object)("Using the default email configuration filename [" + DEFAULT_EMAIL_CONFIG_PATH + "]"));
        String emailConfigFilePath = PentahoSystem.getApplicationContext().getSolutionPath(DEFAULT_EMAIL_CONFIG_PATH);
        logger.debug((Object)("System converted default email configuration filename to [" + emailConfigFilePath + "]"));
        this.setEmailConfigFile(new File(emailConfigFilePath));
    }

    public EmailService(File emailConfigFile) throws IllegalArgumentException {
        this.setEmailConfigFile(emailConfigFile);
    }

    public void setEmailConfig(IEmailConfiguration emailConfiguration) {
        if (emailConfiguration == null) {
            throw new IllegalArgumentException(messages.getErrorString("EmailService.ERROR_0002_NULL_CONFIGURATION"));
        }
        Document document = EmailConfigurationXml.getDocument(emailConfiguration);
        try {
            this.emailConfigFile.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.emailConfigFile);
            XmlDom4JHelper.saveDom((Document)document, (OutputStream)fileOutputStream, (String)"UTF-8");
            fileOutputStream.close();
        }
        catch (IOException e) {
            logger.error((Object)messages.getErrorString("EmailService.ERROR_0003_ERROR_CREATING_EMAIL_CONFIG_FILE", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public EmailConfiguration getEmailConfig() {
        try {
            return new EmailConfigurationXml(this.emailConfigFile);
        }
        catch (Exception e) {
            logger.error((Object)messages.getErrorString("EmailService.ERROR_0004_LOADING_EMAIL_CONFIG_FILE", new Object[]{e.getLocalizedMessage()}));
            return new EmailConfiguration();
        }
    }

    public String sendEmailTest(final IEmailConfiguration emailConfig) {
        Properties emailProperties = new Properties();
        emailProperties.setProperty("mail.smtp.host", emailConfig.getSmtpHost());
        emailProperties.setProperty("mail.smtp.port", ObjectUtils.toString((Object)emailConfig.getSmtpPort()));
        emailProperties.setProperty("mail.transport.protocol", emailConfig.getSmtpProtocol());
        emailProperties.setProperty("mail.smtp.starttls.enable", ObjectUtils.toString((Object)emailConfig.isUseStartTls()));
        emailProperties.setProperty("mail.smtp.auth", ObjectUtils.toString((Object)emailConfig.isAuthenticate()));
        emailProperties.setProperty("mail.smtp.ssl", ObjectUtils.toString((Object)emailConfig.isUseSsl()));
        emailProperties.setProperty("mail.debug", ObjectUtils.toString((Object)emailConfig.isDebug()));
        Session session = null;
        if (emailConfig.isAuthenticate()) {
            Authenticator authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(emailConfig.getUserId(), emailConfig.getPassword());
                }
            };
            session = Session.getInstance((Properties)emailProperties, (Authenticator)authenticator);
        } else {
            session = Session.getInstance((Properties)emailProperties);
        }
        String sendEmailMessage = "";
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(emailConfig.getDefaultFrom(), emailConfig.getFromName()));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)emailConfig.getDefaultFrom()));
            msg.setSubject(messages.getString("EmailService.SUBJECT"));
            msg.setText(messages.getString("EmailService.MESSAGE"));
            msg.setHeader("X-Mailer", "smtpsend");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            sendEmailMessage = "EmailTester.SUCESS";
        }
        catch (Exception e) {
            logger.error((Object)messages.getString("EmailService.NOT_CONFIGURED"), (Throwable)e);
            sendEmailMessage = "EmailTester.FAIL";
        }
        return sendEmailMessage;
    }

    protected void setEmailConfigFile(File emailConfigFile) throws IllegalArgumentException {
        File parentFolder;
        if (emailConfigFile == null) {
            throw new IllegalArgumentException(messages.getErrorString("EmailService.ERROR_0001_INVALID_CONFIG_FILE_LOCATION", new Object[]{null}));
        }
        if (emailConfigFile.exists() ? emailConfigFile.isDirectory() : !(parentFolder = emailConfigFile.getAbsoluteFile().getParentFile()).exists() || !parentFolder.isDirectory()) {
            throw new IllegalArgumentException(messages.getErrorString("EmailService.ERROR_0001_INVALID_CONFIG_FILE_LOCATION", new Object[]{emailConfigFile.getAbsolutePath()}));
        }
        logger.debug((Object)("Setting the email configuration file to [" + emailConfigFile.getAbsolutePath() + "]"));
        logger.debug((Object)("\temail config file exists = " + emailConfigFile.exists()));
        this.emailConfigFile = emailConfigFile;
    }

    public boolean isValid() {
        try {
            EmailConfigurationXml c = new EmailConfigurationXml(this.emailConfigFile);
            if (!(StringUtils.isEmpty((String)c.getSmtpHost()) || StringUtils.isEmpty((String)c.getSmtpProtocol()) || StringUtils.isEmpty((String)c.getDefaultFrom()))) {
                if (c.isAuthenticate()) {
                    return !StringUtils.isEmpty((String)c.getUserId()) && !StringUtils.isEmpty((String)c.getPassword());
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

