/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityLoginModule
extends AbstractKarafLoginModule {
    public static final String KARAF_ADMIN = "karaf_admin";
    private AuthenticationManager authenticationManager = null;
    private IAuthorizationPolicy authorizationPolicy = null;

    public AuthenticationManager getAuthenticationManager() {
        if (this.authenticationManager == null) {
            this.authenticationManager = (AuthenticationManager)PentahoSystem.get(AuthenticationManager.class);
        }
        return this.authenticationManager;
    }

    public IAuthorizationPolicy getAuthorizationPolicy() {
        if (this.authorizationPolicy == null) {
            this.authorizationPolicy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        }
        return this.authorizationPolicy;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthorizationPolicy(IAuthorizationPolicy authorizationPolicy) {
        this.authorizationPolicy = authorizationPolicy;
    }

    public void initialize(Subject sub, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(sub, handler, options);
    }

    public boolean login() throws LoginException {
        String name;
        Callback[] callbacks;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            callbacks = new Callback[]{new NameCallback("User: ")};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                throw new LoginException(e.getMessage());
            }
            catch (UnsupportedCallbackException e) {
                throw new LoginException("Unable to interactively Authenticate with user: " + e.getMessage());
            }
            name = ((NameCallback)callbacks[0]).getName();
            if (name == null) {
                throw new LoginException("User name is null");
            }
            if (!name.equals(authentication.getName())) {
                authentication = null;
            }
        }
        if (authentication == null) {
            callbacks = new Callback[]{new NameCallback("User: "), new PasswordCallback("Password: ", false)};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                throw new LoginException(e.getMessage());
            }
            catch (UnsupportedCallbackException e) {
                throw new LoginException("Unable to interactively Authenticate with user: " + e.getMessage());
            }
            name = ((NameCallback)callbacks[0]).getName();
            char[] password1 = ((PasswordCallback)callbacks[1]).getPassword();
            if (password1 == null || name == null) {
                throw new LoginException("User Name and Password cannot be null");
            }
            String password = new String(password1);
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)name, (Object)String.valueOf(password));
            StandaloneSession session = new StandaloneSession(name);
            PentahoSessionHolder.setSession((IPentahoSession)session);
            try {
                authentication = this.getAuthenticationManager().authenticate((Authentication)token);
                if (authentication != null && !authentication.isAuthenticated()) {
                    throw new IllegalStateException("Got a bad authentication");
                }
                if (authentication == null) {
                    throw new IllegalStateException("Not Authenticated");
                }
            }
            catch (Exception e) {
                session.destroy();
                PentahoSessionHolder.removeSession();
                throw new LoginException(e.getMessage());
            }
        }
        this.principals = new HashSet();
        this.principals.add(new UserPrincipal(authentication.getName()));
        Collection authorities = authentication.getAuthorities();
        if (authorities != null) {
            for (GrantedAuthority authority : authorities) {
                this.principals.add(new RolePrincipal(authority.getAuthority()));
            }
        }
        SecurityHelper.getInstance().becomeUser(authentication.getName());
        if (this.getAuthorizationPolicy().isAllowed("org.pentaho.security.administerSecurity")) {
            this.principals.add(new RolePrincipal(KARAF_ADMIN));
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.clear();
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }
}

