/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;

class ASTBuilder {
    ASTNode curr;

    ASTBuilder() {
    }

    static ASTBuilder construct(int tokenType, String text) {
        ASTBuilder b = new ASTBuilder();
        b.curr = ASTBuilder.createAST(tokenType, text);
        return b;
    }

    static ASTNode createAST(int tokenType, String text) {
        return (ASTNode)ParseDriver.adaptor.create(tokenType, text);
    }

    static ASTNode destNode() {
        return ASTBuilder.construct(670, "TOK_DESTINATION").add(ASTBuilder.construct(671, "TOK_DIR").add(885, "TOK_TMP_FILE")).node();
    }

    static ASTNode table(TableScan scan) {
        RelOptHiveTable hTbl = (RelOptHiveTable)scan.getTable();
        ASTBuilder b = ASTBuilder.construct(876, "TOK_TABREF").add(ASTBuilder.construct(875, "TOK_TABNAME").add(26, hTbl.getHiveTableMD().getDbName()).add(26, hTbl.getHiveTableMD().getTableName()));
        b.add(26, hTbl.getTableAlias());
        return b.node();
    }

    static ASTNode join(ASTNode left, ASTNode right, JoinRelType joinType, ASTNode cond, boolean semiJoin) {
        ASTBuilder b = null;
        switch (joinType) {
            case INNER: {
                if (semiJoin) {
                    b = ASTBuilder.construct(727, "TOK_LEFTSEMIJOIN");
                    break;
                }
                b = ASTBuilder.construct(723, "TOK_JOIN");
                break;
            }
            case LEFT: {
                b = ASTBuilder.construct(726, "TOK_LEFTOUTERJOIN");
                break;
            }
            case RIGHT: {
                b = ASTBuilder.construct(799, "TOK_RIGHTOUTERJOIN");
                break;
            }
            case FULL: {
                b = ASTBuilder.construct(692, "TOK_FULLOUTERJOIN");
            }
        }
        b.add(left).add(right).add(cond);
        return b.node();
    }

    static ASTNode subQuery(ASTNode qry, String alias) {
        return ASTBuilder.construct(841, "TOK_SUBQUERY").add(qry).add(26, alias).node();
    }

    static ASTNode qualifiedName(String tableName, String colName) {
        ASTBuilder b = ASTBuilder.construct(17, ".").add(ASTBuilder.construct(872, "TOK_TABLE_OR_COL").add(26, tableName)).add(26, colName);
        return b.node();
    }

    static ASTNode unqualifiedName(String colName) {
        ASTBuilder b = ASTBuilder.construct(872, "TOK_TABLE_OR_COL").add(26, colName);
        return b.node();
    }

    static ASTNode where(ASTNode cond) {
        return ASTBuilder.construct(905, "TOK_WHERE").add(cond).node();
    }

    static ASTNode having(ASTNode cond) {
        return ASTBuilder.construct(705, "TOK_HAVING").add(cond).node();
    }

    static ASTNode limit(Object value) {
        return ASTBuilder.construct(730, "TOK_LIMIT").add(296, value.toString()).node();
    }

    static ASTNode selectExpr(ASTNode expr, String alias) {
        return ASTBuilder.construct(805, "TOK_SELEXPR").add(expr).add(26, alias).node();
    }

    static ASTNode literal(RexLiteral literal) {
        return ASTBuilder.literal(literal, false);
    }

    static ASTNode literal(RexLiteral literal, boolean useTypeQualInLiteral) {
        Object val = null;
        int type = 0;
        SqlTypeName sqlType = literal.getType().getSqlTypeName();
        switch (sqlType) {
            case BINARY: {
                ByteString bs = (ByteString)literal.getValue();
                val = bs.byteAt(0);
                type = 7;
                break;
            }
            case TINYINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "Y" : literal.getValue3();
                type = 309;
                break;
            }
            case SMALLINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "S" : literal.getValue3();
                type = 306;
                break;
            }
            case INTEGER: {
                val = literal.getValue3();
                type = 7;
                break;
            }
            case BIGINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "L" : literal.getValue3();
                type = 7;
                break;
            }
            case DOUBLE: {
                val = literal.getValue3() + "D";
                type = 296;
                break;
            }
            case DECIMAL: {
                val = literal.getValue3() + "BD";
                type = 18;
                break;
            }
            case FLOAT: 
            case REAL: {
                val = literal.getValue3();
                type = 296;
                break;
            }
            case VARCHAR: 
            case CHAR: {
                val = literal.getValue3();
                String escapedVal = BaseSemanticAnalyzer.escapeSQLString(String.valueOf(val));
                type = 307;
                val = "'" + escapedVal + "'";
                break;
            }
            case BOOLEAN: {
                val = literal.getValue3();
                type = (Boolean)val != false ? 260 : 107;
                break;
            }
            case DATE: {
                val = literal.getValue();
                type = 660;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                val = df.format(((Calendar)val).getTime());
                val = "'" + val + "'";
                break;
            }
            case TIME: 
            case TIMESTAMP: {
                val = literal.getValue();
                type = 883;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                val = df.format(((Calendar)val).getTime());
                val = "'" + val + "'";
                break;
            }
            case NULL: {
                type = 742;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Type: " + sqlType);
            }
        }
        return (ASTNode)ParseDriver.adaptor.create(type, String.valueOf(val));
    }

    ASTNode node() {
        return this.curr;
    }

    ASTBuilder add(int tokenType, String text) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)ASTBuilder.createAST(tokenType, text));
        return this;
    }

    ASTBuilder add(ASTBuilder b) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)b.curr);
        return this;
    }

    ASTBuilder add(ASTNode n) {
        if (n != null) {
            ParseDriver.adaptor.addChild((Object)this.curr, (Object)n);
        }
        return this;
    }
}

