/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorFileSinkOperator
extends FileSinkOperator {
    private static final long serialVersionUID = 1L;
    protected transient Object[] singleRow;
    protected transient VectorExpressionWriter[] valueWriters;

    public VectorFileSinkOperator(VectorizationContext context, OperatorDesc conf) {
        this.conf = (FileSinkDesc)conf;
    }

    public VectorFileSinkOperator() {
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        VectorExpressionWriterFactory.processVectorInspector((StructObjectInspector)this.inputObjInspectors[0], new VectorExpressionWriterFactory.SingleOIDClosure(){

            @Override
            public void assign(VectorExpressionWriter[] writers, ObjectInspector objectInspector) {
                VectorFileSinkOperator.this.valueWriters = writers;
                ((VectorFileSinkOperator)VectorFileSinkOperator.this).inputObjInspectors[0] = objectInspector;
            }
        });
        this.singleRow = new Object[this.valueWriters.length];
        super.initializeOp(hconf);
    }

    @Override
    public void processOp(Object data, int tag) throws HiveException {
        VectorizedRowBatch vrg = (VectorizedRowBatch)data;
        for (int i = 0; i < vrg.size; ++i) {
            Object[] row = this.getRowObject(vrg, i);
            super.processOp(row, tag);
        }
    }

    private Object[] getRowObject(VectorizedRowBatch vrg, int rowIndex) throws HiveException {
        int batchIndex = rowIndex;
        if (vrg.selectedInUse) {
            batchIndex = vrg.selected[rowIndex];
        }
        for (int i = 0; i < vrg.projectionSize; ++i) {
            ColumnVector vectorColumn = vrg.cols[vrg.projectedColumns[i]];
            this.singleRow[i] = this.valueWriters[i].writeValue(vectorColumn, batchIndex);
        }
        return this.singleRow;
    }
}

