/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.pig;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.impl.shim.pig.WriterAppenderManager;
import org.pentaho.bigdata.api.pig.PigResult;
import org.pentaho.bigdata.api.pig.PigService;
import org.pentaho.bigdata.api.pig.impl.PigResultImpl;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.PigShim;

public class PigServiceImpl
implements PigService {
    private static final Class<?> PKG = PigServiceImpl.class;
    private final NamedCluster namedCluster;
    private final PigShim pigShim;
    private final HadoopShim hadoopShim;
    private final WriterAppenderManager.Factory writerAppenderManagerFactory;

    public PigServiceImpl(NamedCluster namedCluster, PigShim pigShim, HadoopShim hadoopShim) {
        this(namedCluster, pigShim, hadoopShim, new WriterAppenderManager.Factory());
    }

    public PigServiceImpl(NamedCluster namedCluster, PigShim pigShim, HadoopShim hadoopShim, WriterAppenderManager.Factory writerAppenderManagerFactory) {
        this.namedCluster = namedCluster;
        this.pigShim = pigShim;
        this.hadoopShim = hadoopShim;
        this.writerAppenderManagerFactory = writerAppenderManagerFactory;
    }

    public boolean isLocalExecutionSupported() {
        return this.pigShim.isLocalExecutionSupported();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PigResult executeScript(String scriptPath, PigService.ExecutionMode executionMode, List<String> parameters, String name, LogChannelInterface logChannelInterface, VariableSpace variableSpace, LogLevel logLevel) {
        FileObject appenderFile = null;
        try (WriterAppenderManager appenderManager = this.writerAppenderManagerFactory.create(logChannelInterface, logLevel, name);){
            URL scriptU;
            appenderFile = appenderManager.getFile();
            Configuration configuration = this.hadoopShim.createConfiguration();
            if (executionMode != PigService.ExecutionMode.LOCAL) {
                ArrayList configMessages = new ArrayList();
                this.hadoopShim.configureConnectionInformation(variableSpace.environmentSubstitute(this.namedCluster.getHdfsHost()), variableSpace.environmentSubstitute(this.namedCluster.getHdfsPort()), variableSpace.environmentSubstitute(this.namedCluster.getJobTrackerHost()), variableSpace.environmentSubstitute(this.namedCluster.getJobTrackerPort()), configuration, configMessages);
                if (logChannelInterface != null) {
                    for (String configMessage : configMessages) {
                        logChannelInterface.logBasic(configMessage);
                    }
                }
            }
            String scriptFileS = scriptPath;
            if ((scriptFileS = variableSpace.environmentSubstitute(scriptFileS)).indexOf("://") == -1) {
                File scriptFile = new File(scriptFileS);
                scriptU = scriptFile.toURI().toURL();
            } else {
                scriptU = new URL(scriptFileS);
            }
            String pigScript = this.pigShim.substituteParameters(scriptU, parameters);
            Properties properties = new Properties();
            this.pigShim.configure(properties, executionMode == PigService.ExecutionMode.LOCAL ? null : configuration);
            PigResultImpl pigResultImpl = new PigResultImpl(appenderFile, this.pigShim.executeScript(pigScript, executionMode == PigService.ExecutionMode.LOCAL ? PigShim.ExecutionMode.LOCAL : PigShim.ExecutionMode.MAPREDUCE, properties), null);
            return pigResultImpl;
        }
        catch (Exception e) {
            return new PigResultImpl(appenderFile, null, e);
        }
    }
}

