/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.Tool;

@InterfaceStability.Evolving
public class LogLevel {
    public static final String USAGES = "\nUsage: General options are:\n\t[-getlevel <host:port> <classname> [-protocol (http|https)]\n\t[-setlevel <host:port> <classname> <level> [-protocol (http|https)]\n";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    static final String MARKER = "<!-- OUTPUT -->";
    static final Pattern TAG = Pattern.compile("<[^>]*>");

    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new Configuration());
        System.exit(cli.run(args));
    }

    private static void printUsage() {
        System.err.println(USAGES);
    }

    public static boolean isValidProtocol(String protocol) {
        return protocol.equals(PROTOCOL_HTTP) || protocol.equals(PROTOCOL_HTTPS);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    @InterfaceStability.Unstable
    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        static final String FORMS = "\n<br /><hr /><h3>Get / Set</h3>\n<form>Log: <input type='text' size='50' name='log' /> <input type='submit' value='Get Log Level' /></form>\n<form>Log: <input type='text' size='50' name='log' /> Level: <input type='text' name='level' /> <input type='submit' value='Set Log Level' /></form>";

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (!HttpServer2.hasAdministratorAccess(this.getServletContext(), request, response)) {
                return;
            }
            PrintWriter out = ServletUtil.initHTML((ServletResponse)response, "Log Level");
            String logName = ServletUtil.getParameter((ServletRequest)request, "log");
            String level = ServletUtil.getParameter((ServletRequest)request, "level");
            if (logName != null) {
                out.println("<br /><hr /><h3>Results</h3>");
                out.println("<!-- OUTPUT -->Submitted Log Name: <b>" + logName + "</b><br />");
                Log log = LogFactory.getLog((String)logName);
                out.println("<!-- OUTPUT -->Log Class: <b>" + log.getClass().getName() + "</b><br />");
                if (level != null) {
                    out.println("<!-- OUTPUT -->Submitted Level: <b>" + level + "</b><br />");
                }
                if (log instanceof Log4JLogger) {
                    Servlet.process(((Log4JLogger)log).getLogger(), level, out);
                } else if (log instanceof Jdk14Logger) {
                    Servlet.process(((Jdk14Logger)log).getLogger(), level, out);
                } else {
                    out.println("Sorry, " + log.getClass() + " not supported.<br />");
                }
            }
            out.println(FORMS);
            out.println(ServletUtil.HTML_TAIL);
        }

        private static void process(org.apache.log4j.Logger log, String level, PrintWriter out) throws IOException {
            if (level != null) {
                if (!level.equals(org.apache.log4j.Level.toLevel((String)level).toString())) {
                    out.println("<!-- OUTPUT -->Bad level : <b>" + level + "</b><br />");
                } else {
                    log.setLevel(org.apache.log4j.Level.toLevel((String)level));
                    out.println("<!-- OUTPUT -->Setting Level to " + level + " ...<br />");
                }
            }
            out.println("<!-- OUTPUT -->Effective level: <b>" + log.getEffectiveLevel() + "</b><br />");
        }

        private static void process(Logger log, String level, PrintWriter out) throws IOException {
            Level lev;
            if (level != null) {
                log.setLevel(Level.parse(level));
                out.println("<!-- OUTPUT -->Setting Level to " + level + " ...<br />");
            }
            while ((lev = log.getLevel()) == null) {
                log = log.getParent();
            }
            out.println("<!-- OUTPUT -->Effective level: <b>" + lev + "</b><br />");
        }
    }

    @VisibleForTesting
    static class CLI
    extends Configured
    implements Tool {
        private Operations operation = Operations.UNKNOWN;
        private String protocol;
        private String hostName;
        private String className;
        private String level;

        CLI(Configuration conf) {
            this.setConf(conf);
        }

        @Override
        public int run(String[] args) throws Exception {
            try {
                this.parseArguments(args);
                this.sendLogLevelRequest();
            }
            catch (HadoopIllegalArgumentException e) {
                LogLevel.printUsage();
                throw e;
            }
            return 0;
        }

        private void sendLogLevelRequest() throws HadoopIllegalArgumentException, Exception {
            switch (this.operation) {
                case GETLEVEL: {
                    this.doGetLevel();
                    break;
                }
                case SETLEVEL: {
                    this.doSetLevel();
                    break;
                }
                default: {
                    throw new HadoopIllegalArgumentException("Expect either -getlevel or -setlevel");
                }
            }
        }

        public void parseArguments(String[] args) throws HadoopIllegalArgumentException {
            if (args.length == 0) {
                throw new HadoopIllegalArgumentException("No arguments specified");
            }
            int nextArgIndex = 0;
            while (nextArgIndex < args.length) {
                if (args[nextArgIndex].equals("-getlevel")) {
                    nextArgIndex = this.parseGetLevelArgs(args, nextArgIndex);
                    continue;
                }
                if (args[nextArgIndex].equals("-setlevel")) {
                    nextArgIndex = this.parseSetLevelArgs(args, nextArgIndex);
                    continue;
                }
                if (args[nextArgIndex].equals("-protocol")) {
                    nextArgIndex = this.parseProtocolArgs(args, nextArgIndex);
                    continue;
                }
                throw new HadoopIllegalArgumentException("Unexpected argument " + args[nextArgIndex]);
            }
            if (this.operation == Operations.UNKNOWN) {
                throw new HadoopIllegalArgumentException("Must specify either -getlevel or -setlevel");
            }
            if (this.protocol == null) {
                this.protocol = LogLevel.PROTOCOL_HTTP;
            }
        }

        private int parseGetLevelArgs(String[] args, int index) throws HadoopIllegalArgumentException {
            if (this.operation != Operations.UNKNOWN) {
                throw new HadoopIllegalArgumentException("Redundant -getlevel command");
            }
            if (index + 2 >= args.length) {
                throw new HadoopIllegalArgumentException("-getlevel needs two parameters");
            }
            this.operation = Operations.GETLEVEL;
            this.hostName = args[index + 1];
            this.className = args[index + 2];
            return index + 3;
        }

        private int parseSetLevelArgs(String[] args, int index) throws HadoopIllegalArgumentException {
            if (this.operation != Operations.UNKNOWN) {
                throw new HadoopIllegalArgumentException("Redundant -setlevel command");
            }
            if (index + 3 >= args.length) {
                throw new HadoopIllegalArgumentException("-setlevel needs three parameters");
            }
            this.operation = Operations.SETLEVEL;
            this.hostName = args[index + 1];
            this.className = args[index + 2];
            this.level = args[index + 3];
            return index + 4;
        }

        private int parseProtocolArgs(String[] args, int index) throws HadoopIllegalArgumentException {
            if (this.protocol != null) {
                throw new HadoopIllegalArgumentException("Redundant -protocol command");
            }
            if (index + 1 >= args.length) {
                throw new HadoopIllegalArgumentException("-protocol needs one parameter");
            }
            this.protocol = args[index + 1];
            if (!LogLevel.isValidProtocol(this.protocol)) {
                throw new HadoopIllegalArgumentException("Invalid protocol: " + this.protocol);
            }
            return index + 2;
        }

        private void doGetLevel() throws Exception {
            this.process(this.protocol + "://" + this.hostName + "/logLevel?log=" + this.className);
        }

        private void doSetLevel() throws Exception {
            this.process(this.protocol + "://" + this.hostName + "/logLevel?log=" + this.className + "&level=" + this.level);
        }

        private URLConnection connect(URL url) throws Exception {
            HttpURLConnection connection;
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            if (LogLevel.PROTOCOL_HTTPS.equals(url.getProtocol())) {
                SSLFactory clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, this.getConf());
                clientSslFactory.init();
                SSLSocketFactory sslSocketF = clientSslFactory.createSSLSocketFactory();
                AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new KerberosAuthenticator(), (ConnectionConfigurator)clientSslFactory);
                connection = aUrl.openConnection(url, token);
                HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
                httpsConn.setSSLSocketFactory(sslSocketF);
            } else {
                AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new KerberosAuthenticator());
                connection = aUrl.openConnection(url, token);
            }
            connection.connect();
            return connection;
        }

        private void process(String urlString) throws Exception {
            String line;
            URL url = new URL(urlString);
            System.out.println("Connecting to " + url);
            URLConnection connection = this.connect(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
            while ((line = in.readLine()) != null) {
                if (!line.startsWith(LogLevel.MARKER)) continue;
                System.out.println(TAG.matcher(line).replaceAll(""));
            }
            in.close();
        }
    }

    private static enum Operations {
        GETLEVEL,
        SETLEVEL,
        UNKNOWN;

    }
}

