/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.runtime;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

public class PartitionerDefinedVertexManager
extends VertexManagerPlugin {
    private static final Log LOG = LogFactory.getLog(PartitionerDefinedVertexManager.class);
    private boolean isParallelismSet = false;
    private int dynamicParallelism = -1;

    public PartitionerDefinedVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
    }

    public void onSourceTaskCompleted(String srcVertexName, Integer srcTaskId) {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) throws Exception {
        if (this.isParallelismSet) {
            return;
        }
        this.isParallelismSet = true;
        if (vmEvent.getUserPayload().limit() != 4) {
            return;
        }
        this.dynamicParallelism = vmEvent.getUserPayload().getInt();
        int currentParallelism = this.getContext().getVertexNumTasks(this.getContext().getVertexName());
        if (this.dynamicParallelism != -1 && this.dynamicParallelism != currentParallelism) {
            LOG.info((Object)("Pig Partitioner Defined Vertex Manager: reset parallelism to " + this.dynamicParallelism + " from " + currentParallelism));
            HashMap edgeManagers = new HashMap();
            for (Map.Entry entry : this.getContext().getInputVertexEdgeProperties().entrySet()) {
                EdgeProperty edge = (EdgeProperty)entry.getValue();
                edge = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)edge.getDataSourceType(), (EdgeProperty.SchedulingType)edge.getSchedulingType(), (OutputDescriptor)edge.getEdgeSource(), (InputDescriptor)edge.getEdgeDestination());
                edgeManagers.put(entry.getKey(), edge);
            }
            this.getContext().reconfigureVertex(this.dynamicParallelism, null, edgeManagers);
        }
    }

    public void onVertexStarted(Map<String, List<Integer>> completions) {
        if (this.dynamicParallelism != -1) {
            ArrayList tasksToStart = Lists.newArrayListWithCapacity((int)this.dynamicParallelism);
            for (int i = 0; i < this.dynamicParallelism; ++i) {
                tasksToStart.add(new VertexManagerPluginContext.TaskWithLocationHint(new Integer(i), null));
            }
            this.getContext().scheduleVertexTasks((List)tasksToStart);
        }
    }
}

