/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.table;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.table.EdmType;
import com.microsoft.windowsazure.storage.table.EntityProperty;
import com.microsoft.windowsazure.storage.table.EntityResolver;
import com.microsoft.windowsazure.storage.table.ODataPayload;
import com.microsoft.windowsazure.storage.table.ODataUtilities;
import com.microsoft.windowsazure.storage.table.PropertyPair;
import com.microsoft.windowsazure.storage.table.TableEntity;
import com.microsoft.windowsazure.storage.table.TablePayloadFormat;
import com.microsoft.windowsazure.storage.table.TableRequestOptions;
import com.microsoft.windowsazure.storage.table.TableResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringEscapeUtils;

class TableParser {
    private static JsonFactory jsonFactory = new JsonFactory();

    TableParser() {
    }

    protected static <T extends TableEntity, R> ODataPayload<?> parseQueryResponse(InputStream inStream, TableRequestOptions options, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws InstantiationException, IllegalAccessException, XMLStreamException, ParseException, StorageException, JsonParseException, IOException {
        ODataPayload<?> payload = options.getTablePayloadFormat() == TablePayloadFormat.AtomPub ? TableParser.parseAtomQueryResponse(inStream, clazzType, resolver, opContext) : TableParser.parseJsonQueryResponse(inStream, clazzType, resolver, options, opContext);
        return payload;
    }

    protected static <T extends TableEntity, R> TableResult parseSingleOpResponse(InputStream inStream, TableRequestOptions options, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws InstantiationException, IllegalAccessException, XMLStreamException, ParseException, StorageException, IOException, JsonParseException {
        TableResult res = options.getTablePayloadFormat() == TablePayloadFormat.AtomPub ? TableParser.parseSingleOpAtomResponse(inStream, httpStatusCode, clazzType, resolver, opContext) : TableParser.parseSingleOpJsonResponse(inStream, httpStatusCode, clazzType, resolver, options, opContext);
        return res;
    }

    protected static void writeSingleEntityToStream(OutputStream outStream, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws XMLStreamException, StorageException, IOException {
        if (format == TablePayloadFormat.AtomPub) {
            TableParser.writeSingleAtomEntity(outStream, entity, isTableEntry, opContext);
        } else {
            TableParser.writeSingleJsonEntity(outStream, format, entity, isTableEntry, opContext);
        }
    }

    protected static void writeSingleEntityToString(StringWriter strWriter, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws XMLStreamException, StorageException, IOException {
        if (format == TablePayloadFormat.AtomPub) {
            TableParser.writeSingleAtomEntity(strWriter, entity, isTableEntry, opContext);
        } else {
            TableParser.writeSingleJsonEntity(strWriter, format, entity, isTableEntry, opContext);
        }
    }

    private static <T extends TableEntity, R> TableResult parseJsonEntity(JsonParser parser, Class<T> clazzType, HashMap<String, PropertyPair> classProperties, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws JsonParseException, IOException, ParseException, StorageException, InstantiationException, IllegalAccessException {
        TableResult res = new TableResult();
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        if (!parser.hasCurrentToken()) {
            parser.nextToken();
        }
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        while (parser.getCurrentName().startsWith("odata.")) {
            String name = parser.getCurrentName().substring("odata.".length());
            parser.nextToken();
            if (name.equals("etag")) {
                String etag = parser.getValueAsString();
                res.setEtag(etag);
            }
            parser.nextToken();
        }
        if (resolver == null && clazzType == null) {
            return res;
        }
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String key = "";
            String val = "";
            EdmType edmType = null;
            if (options.getTablePayloadFormat() != TablePayloadFormat.JsonNoMetadata && parser.getCurrentName().endsWith("@odata.type")) {
                parser.nextToken();
                edmType = EdmType.parse(parser.getValueAsString());
                parser.nextValue();
                key = parser.getCurrentName();
                val = parser.getValueAsString();
            } else {
                key = parser.getCurrentName();
                parser.nextToken();
                val = parser.getValueAsString();
                edmType = TableParser.evaluateEdmType(parser.getCurrentToken(), parser.getValueAsString());
            }
            EntityProperty newProp = new EntityProperty(val, edmType);
            properties.put(key, newProp);
            parser.nextToken();
        }
        String partitionKey = null;
        String rowKey = null;
        Date timestamp = null;
        String etag = null;
        EntityProperty tempProp = (EntityProperty)properties.remove("PartitionKey");
        if (tempProp != null) {
            partitionKey = tempProp.getValueAsString();
        }
        if ((tempProp = (EntityProperty)properties.remove("RowKey")) != null) {
            rowKey = tempProp.getValueAsString();
        }
        if ((tempProp = (EntityProperty)properties.remove("Timestamp")) != null) {
            timestamp = tempProp.getValueAsDate();
            if (res.getEtag() == null) {
                etag = TableParser.getETagFromTimestamp(tempProp.getValueAsString());
                res.setEtag(etag);
            }
        }
        if (options.getTablePayloadFormat() == TablePayloadFormat.JsonNoMetadata && (options.getPropertyResolver() != null || clazzType != null)) {
            if (options.getPropertyResolver() != null) {
                for (Map.Entry<String, EntityProperty> p : properties.entrySet()) {
                    EdmType edmType;
                    String key = p.getKey();
                    String value = p.getValue().getValueAsString();
                    try {
                        edmType = options.getPropertyResolver().propertyResolver(partitionKey, rowKey, key, value);
                    }
                    catch (Exception e) {
                        throw new StorageException("InternalError", "The custom property resolver delegate threw an exception. Check the inner exception for more details.", 306, null, e);
                    }
                    try {
                        EntityProperty newProp = new EntityProperty(value, edmType);
                        properties.put(p.getKey(), newProp);
                    }
                    catch (IllegalArgumentException e) {
                        throw new StorageException("InvalidType", String.format("Failed to parse property '%s' with value '%s' as type '%s'", new Object[]{key, value, edmType}), 306, null, e);
                    }
                }
            } else if (clazzType != null) {
                if (classProperties == null) {
                    classProperties = PropertyPair.generatePropertyPairs(clazzType);
                }
                for (Map.Entry<String, EntityProperty> p : properties.entrySet()) {
                    PropertyPair propPair = classProperties.get(p.getKey());
                    if (propPair == null) continue;
                    EntityProperty newProp = new EntityProperty(p.getValue().getValueAsString(), propPair.type);
                    properties.put(p.getKey(), newProp);
                }
            }
        }
        res.setProperties(properties);
        if (resolver != null) {
            res.setResult(resolver.resolve(partitionKey, rowKey, timestamp, res.getProperties(), res.getEtag()));
        } else if (clazzType != null) {
            TableEntity entity = (TableEntity)clazzType.newInstance();
            entity.setEtag(res.getEtag());
            entity.setPartitionKey(partitionKey);
            entity.setRowKey(rowKey);
            entity.setTimestamp(timestamp);
            entity.readEntity(res.getProperties(), opContext);
            res.setResult(entity);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends TableEntity, R> ODataPayload<?> parseJsonQueryResponse(InputStream inStream, Class<T> clazzType, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws ParseException, InstantiationException, IllegalAccessException, StorageException, JsonParseException, IOException {
        ODataPayload corePayload = null;
        ODataPayload resolvedPayload = null;
        ODataPayload commonPayload = null;
        JsonParser parser = TableParser.createJsonParserFromStream(inStream);
        try {
            if (resolver != null) {
                commonPayload = resolvedPayload = new ODataPayload();
            } else {
                corePayload = new ODataPayload();
                commonPayload = corePayload;
            }
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            ODataUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            HashMap<String, PropertyPair> classProperties = null;
            if (options.getTablePayloadFormat() == TablePayloadFormat.JsonNoMetadata && clazzType != null) {
                classProperties = PropertyPair.generatePropertyPairs(clazzType);
            }
            while (parser.getCurrentToken() != null) {
                if (parser.getCurrentToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("value")) {
                    parser.nextToken();
                    ODataUtilities.assertIsStartArrayJsonToken(parser);
                    parser.nextToken();
                    while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                        TableResult res = TableParser.parseJsonEntity(parser, clazzType, classProperties, resolver, options, opContext);
                        if (corePayload != null) {
                            corePayload.tableResults.add(res);
                        }
                        if (resolver != null) {
                            resolvedPayload.results.add(res.getResult());
                        } else {
                            corePayload.results.add((TableEntity)res.getResult());
                        }
                        parser.nextToken();
                    }
                    ODataUtilities.assertIsEndArrayJsonToken(parser);
                }
                parser.nextToken();
            }
        }
        finally {
            parser.close();
        }
        return commonPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends TableEntity, R> TableResult parseSingleOpJsonResponse(InputStream inStream, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws ParseException, InstantiationException, IllegalAccessException, StorageException, JsonParseException, IOException {
        JsonParser parser = TableParser.createJsonParserFromStream(inStream);
        try {
            TableResult res = TableParser.parseJsonEntity(parser, clazzType, null, resolver, options, opContext);
            res.setHttpStatusCode(httpStatusCode);
            TableResult tableResult = res;
            return tableResult;
        }
        finally {
            parser.close();
        }
    }

    private static void writeJsonEntity(JsonGenerator generator, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        HashMap<String, EntityProperty> properties = entity.writeEntity(opContext);
        if (properties == null) {
            properties = new HashMap();
        }
        generator.writeStartObject();
        if (!isTableEntry) {
            Utility.assertNotNull("PartitionKey", entity.getPartitionKey());
            Utility.assertNotNull("RowKey", entity.getRowKey());
            Utility.assertNotNull("Timestamp", entity.getTimestamp());
            generator.writeStringField("PartitionKey", entity.getPartitionKey());
            generator.writeStringField("RowKey", entity.getRowKey());
            generator.writeStringField("Timestamp", Utility.getTimeByZoneAndFormat(entity.getTimestamp(), Utility.UTC_ZONE, "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'"));
        }
        for (Map.Entry<String, EntityProperty> ent : properties.entrySet()) {
            String edmTypeString;
            if (ent.getKey().equals("PartitionKey") || ent.getKey().equals("RowKey") || ent.getKey().equals("Timestamp") || ent.getKey().equals("Etag")) continue;
            EntityProperty currProp = ent.getValue();
            if (currProp.getEdmType().mustAnnotateType()) {
                edmTypeString = currProp.getEdmType().toString();
                generator.writeStringField(ent.getKey() + "@odata.type", edmTypeString);
                generator.writeStringField(ent.getKey(), ent.getValue().getValueAsString());
                continue;
            }
            if (currProp.getEdmType() == EdmType.DOUBLE && !currProp.getIsNull()) {
                edmTypeString = currProp.getEdmType().toString();
                Double value = currProp.getValueAsDouble();
                if (value.equals(Double.POSITIVE_INFINITY) || value.equals(Double.NEGATIVE_INFINITY) || value.equals(Double.NaN)) {
                    generator.writeStringField(ent.getKey() + "@odata.type", edmTypeString);
                    generator.writeStringField(ent.getKey(), ent.getValue().getValueAsString());
                    continue;
                }
                TableParser.writeJsonProperty(generator, ent);
                continue;
            }
            TableParser.writeJsonProperty(generator, ent);
        }
        generator.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSingleJsonEntity(OutputStream outStream, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        JsonGenerator generator = jsonFactory.createGenerator(outStream);
        try {
            TableParser.writeJsonEntity(generator, format, entity, isTableEntry, opContext);
        }
        finally {
            generator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSingleJsonEntity(StringWriter strWriter, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        JsonGenerator generator = jsonFactory.createGenerator((Writer)strWriter);
        try {
            TableParser.writeJsonEntity(generator, format, entity, isTableEntry, opContext);
        }
        finally {
            generator.close();
        }
    }

    private static <T extends TableEntity, R> TableResult parseAtomEntity(XMLStreamReader xmlr, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException, StorageException {
        int eventType = xmlr.getEventType();
        TableResult res = new TableResult();
        xmlr.require(1, null, "entry");
        String etag = StringEscapeUtils.unescapeHtml4((String)xmlr.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "etag"));
        res.setEtag(etag);
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            String name = xmlr.getName().toString();
            if (eventType != 1) continue;
            if (name.equals("{http://www.w3.org/2005/Atom}id")) {
                Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"id");
                continue;
            }
            if (!name.equals("{http://schemas.microsoft.com/ado/2007/08/dataservices/metadata}properties")) continue;
            if (resolver == null && clazzType == null) {
                return res;
            }
            res.setProperties(TableParser.readAtomProperties(xmlr, opContext));
            break;
        }
        if ((eventType = xmlr.next()) == 4) {
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "content");
        eventType = xmlr.next();
        if (eventType == 4) {
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "entry");
        String rowKey = null;
        String partitionKey = null;
        Date timestamp = null;
        EntityProperty tempProp = res.getProperties().remove("PartitionKey");
        if (tempProp != null) {
            partitionKey = tempProp.getValueAsString();
        }
        if ((tempProp = res.getProperties().remove("RowKey")) != null) {
            rowKey = tempProp.getValueAsString();
        }
        if ((tempProp = res.getProperties().remove("Timestamp")) != null) {
            timestamp = tempProp.getValueAsDate();
        }
        if (resolver != null) {
            res.setResult(resolver.resolve(partitionKey, rowKey, timestamp, res.getProperties(), res.getEtag()));
        } else if (clazzType != null) {
            TableEntity entity = (TableEntity)clazzType.newInstance();
            entity.setEtag(res.getEtag());
            entity.setPartitionKey(partitionKey);
            entity.setRowKey(rowKey);
            entity.setTimestamp(timestamp);
            entity.readEntity(res.getProperties(), opContext);
            res.setResult(entity);
        }
        return res;
    }

    private static <T extends TableEntity, R> ODataPayload<?> parseAtomQueryResponse(InputStream inStream, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException, StorageException {
        ODataPayload corePayload = null;
        ODataPayload resolvedPayload = null;
        ODataPayload commonPayload = null;
        if (resolver != null) {
            commonPayload = resolvedPayload = new ODataPayload();
        } else {
            corePayload = new ODataPayload();
            commonPayload = corePayload;
        }
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream((InputStream)inStream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "feed");
        eventType = xmlr.next();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (!name.equals("{http://www.w3.org/2005/Atom}entry")) continue;
                TableResult res = TableParser.parseAtomEntity(xmlr, clazzType, resolver, opContext);
                if (corePayload != null) {
                    corePayload.tableResults.add(res);
                }
                if (resolver != null) {
                    resolvedPayload.results.add(res.getResult());
                    continue;
                }
                corePayload.results.add((TableEntity)res.getResult());
                continue;
            }
            if (eventType != 2 || !name.equals("{http://www.w3.org/2005/Atom}feed")) continue;
            break;
        }
        xmlr.require(2, null, "feed");
        return commonPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends TableEntity, R> TableResult parseSingleOpAtomResponse(InputStream inStream, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream((InputStream)inStream);
        try {
            xmlr.require(7, null, null);
            xmlr.next();
            TableResult res = TableParser.parseAtomEntity(xmlr, clazzType, resolver, opContext);
            res.setHttpStatusCode(httpStatusCode);
            TableResult tableResult = res;
            return tableResult;
        }
        finally {
            xmlr.close();
        }
    }

    private static HashMap<String, EntityProperty> readAtomProperties(XMLStreamReader xmlr, OperationContext opContext) throws XMLStreamException, ParseException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "properties");
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            if (eventType == 1 && xmlr.getNamespaceURI().equals("http://schemas.microsoft.com/ado/2007/08/dataservices")) {
                String key = xmlr.getLocalName();
                String val = "";
                String edmType = null;
                if (xmlr.getAttributeCount() > 0) {
                    edmType = xmlr.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type");
                }
                if ((eventType = xmlr.next()) == 4) {
                    val = xmlr.getText();
                    eventType = xmlr.next();
                }
                xmlr.require(2, null, key);
                EntityProperty newProp = new EntityProperty(val, EdmType.parse(edmType));
                properties.put(key, newProp);
                continue;
            }
            if (eventType != 2 || !xmlr.getName().toString().equals("{http://schemas.microsoft.com/ado/2007/08/dataservices/metadata}properties")) continue;
        }
        xmlr.require(2, null, "properties");
        return properties;
    }

    private static void writeAtomEntity(TableEntity entity, boolean isTableEntry, XMLStreamWriter xmlw, OperationContext opContext) throws XMLStreamException, StorageException {
        HashMap<String, EntityProperty> properties = entity.writeEntity(opContext);
        if (properties == null) {
            properties = new HashMap();
        }
        if (!isTableEntry) {
            Utility.assertNotNull("PartitionKey", entity.getPartitionKey());
            Utility.assertNotNull("RowKey", entity.getRowKey());
            Utility.assertNotNull("Timestamp", entity.getTimestamp());
        }
        xmlw.writeStartElement("entry");
        xmlw.writeNamespace("d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
        xmlw.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        xmlw.writeNamespace(null, "http://www.w3.org/2005/Atom");
        xmlw.writeStartElement("content");
        xmlw.writeAttribute("type", "application/xml");
        xmlw.writeStartElement("m", "properties", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        if (!isTableEntry) {
            xmlw.writeStartElement("d", "PartitionKey", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("xml", "xml", "space", "preserve");
            xmlw.writeCharacters(entity.getPartitionKey());
            xmlw.writeEndElement();
            xmlw.writeStartElement("d", "RowKey", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("xml", "xml", "space", "preserve");
            xmlw.writeCharacters(entity.getRowKey());
            xmlw.writeEndElement();
            if (entity.getTimestamp() == null) {
                entity.setTimestamp(new Date());
            }
            xmlw.writeStartElement("d", "Timestamp", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", EdmType.DATE_TIME.toString());
            xmlw.writeCharacters(Utility.getTimeByZoneAndFormat(entity.getTimestamp(), Utility.UTC_ZONE, "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'"));
            xmlw.writeEndElement();
        }
        for (Map.Entry<String, EntityProperty> ent : properties.entrySet()) {
            String edmTypeString;
            if (ent.getKey().equals("PartitionKey") || ent.getKey().equals("RowKey") || ent.getKey().equals("Timestamp") || ent.getKey().equals("Etag")) continue;
            EntityProperty currProp = ent.getValue();
            xmlw.writeStartElement("d", ent.getKey(), "http://schemas.microsoft.com/ado/2007/08/dataservices");
            if (currProp.getEdmType() == EdmType.STRING) {
                xmlw.writeAttribute("xml", "xml", "space", "preserve");
            } else if (currProp.getEdmType().toString().length() != 0 && (edmTypeString = currProp.getEdmType().toString()).length() != 0) {
                xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", edmTypeString);
            }
            if (currProp.getIsNull()) {
                xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null", "true");
            }
            xmlw.writeCharacters(currProp.getValueAsString());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndElement();
        xmlw.writeEndElement();
    }

    private static void writeSingleAtomEntity(OutputStream outStream, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws XMLStreamException, StorageException {
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outStream, "UTF-8");
        xmlw.writeStartDocument("UTF-8", "1.0");
        TableParser.writeAtomEntity(entity, isTableEntry, xmlw, opContext);
        xmlw.writeEndDocument();
        xmlw.flush();
    }

    private static void writeSingleAtomEntity(StringWriter strWriter, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws XMLStreamException, StorageException {
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(strWriter);
        xmlw.writeStartDocument("UTF-8", "1.0");
        TableParser.writeAtomEntity(entity, isTableEntry, xmlw, opContext);
        xmlw.writeEndDocument();
        xmlw.flush();
    }

    private static String getETagFromTimestamp(String timestampString) throws UnsupportedEncodingException {
        timestampString = URLEncoder.encode(timestampString, "UTF-8");
        return "W/\"datetime'" + timestampString + "'\"";
    }

    private static EdmType evaluateEdmType(JsonToken token, String value) throws JsonParseException, IOException {
        EdmType edmType = null;
        edmType = token == JsonToken.VALUE_NULL ? EdmType.NULL : (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE ? EdmType.BOOLEAN : (token == JsonToken.VALUE_NUMBER_FLOAT ? EdmType.DOUBLE : (token == JsonToken.VALUE_NUMBER_INT ? EdmType.INT32 : EdmType.STRING)));
        return edmType;
    }

    private static void writeJsonProperty(JsonGenerator generator, Map.Entry<String, EntityProperty> prop) throws JsonGenerationException, IOException {
        EdmType edmType = prop.getValue().getEdmType();
        if (prop.getValue().getIsNull()) {
            generator.writeNullField(prop.getKey());
        } else if (edmType == EdmType.BOOLEAN) {
            generator.writeBooleanField(prop.getKey(), prop.getValue().getValueAsBoolean());
        } else if (edmType == EdmType.DOUBLE) {
            generator.writeNumberField(prop.getKey(), prop.getValue().getValueAsDouble());
        } else if (edmType == EdmType.INT32) {
            generator.writeNumberField(prop.getKey(), prop.getValue().getValueAsInteger());
        } else {
            generator.writeStringField(prop.getKey(), prop.getValue().getValueAsString());
        }
    }

    private static JsonParser createJsonParserFromStream(InputStream streamRef) throws JsonParseException, IOException {
        JsonParser parser = jsonFactory.createParser(streamRef);
        return parser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }
}

