/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.OML_O33_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.OML_O33_PRIOR_RESULT;
import ca.uhn.hl7v2.model.v25.segment.DG1;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.model.v25.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OML_O33_OBSERVATION_REQUEST
extends AbstractGroup {
    public OML_O33_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false);
            this.add(TCD.class, false, false);
            this.add(NTE.class, false, true);
            this.add(DG1.class, false, true);
            this.add(OML_O33_OBSERVATION.class, false, true);
            this.add(OML_O33_PRIOR_RESULT.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OML_O33_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TCD getTCD() {
        TCD ret = null;
        try {
            ret = (TCD)this.get("TCD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public DG1 getDG1() {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DG1 getDG1(int rep) {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDG1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DG1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public OML_O33_OBSERVATION getOBSERVATION() {
        OML_O33_OBSERVATION ret = null;
        try {
            ret = (OML_O33_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O33_OBSERVATION getOBSERVATION(int rep) {
        OML_O33_OBSERVATION ret = null;
        try {
            ret = (OML_O33_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(OML_O33_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public OML_O33_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OML_O33_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OML_O33_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OML_O33_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public OML_O33_PRIOR_RESULT getPRIOR_RESULT() {
        OML_O33_PRIOR_RESULT ret = null;
        try {
            ret = (OML_O33_PRIOR_RESULT)this.get("PRIOR_RESULT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O33_PRIOR_RESULT getPRIOR_RESULT(int rep) {
        OML_O33_PRIOR_RESULT ret = null;
        try {
            ret = (OML_O33_PRIOR_RESULT)this.get("PRIOR_RESULT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRIOR_RESULTReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRIOR_RESULT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRIOR_RESULT(OML_O33_PRIOR_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRIOR_RESULT", (Structure)structure, rep);
    }

    public OML_O33_PRIOR_RESULT insertPRIOR_RESULT(int rep) throws HL7Exception {
        return (OML_O33_PRIOR_RESULT)super.insertRepetition("PRIOR_RESULT", rep);
    }

    public OML_O33_PRIOR_RESULT removePRIOR_RESULT(int rep) throws HL7Exception {
        return (OML_O33_PRIOR_RESULT)super.removeRepetition("PRIOR_RESULT", rep);
    }
}

