/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.rest.JMSConnectionInfoBean;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.MetricsInstrumentation;

public class V2AdminServlet
extends V1AdminServlet {
    private static final long serialVersionUID = 1L;
    private static final String INSTRUMENTATION_NAME = "v2admin";
    private static MetricsInstrumentation metricsInstrumentation = null;

    public V2AdminServlet() {
        super(INSTRUMENTATION_NAME);
        Instrumentation instrumentation;
        Services services = Services.get();
        if (services != null && (instrumentation = services.get(InstrumentationService.class).get()) instanceof MetricsInstrumentation) {
            metricsInstrumentation = (MetricsInstrumentation)instrumentation;
        }
    }

    @Override
    protected JsonBean getJMSConnectionInfo(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        Configuration conf = Services.get().getConf();
        JMSTopicService jmsTopicService = Services.get().get(JMSTopicService.class);
        String connectionProperties = conf.get("oozie.jms.producer.connection.properties");
        if (connectionProperties == null) {
            throw new XServletException(400, ErrorCode.E1601, "JMS connection property is not defined");
        }
        JMSConnectionInfoBean jmsBean = new JMSConnectionInfoBean();
        JMSConnectionInfo jmsInfo = new JMSConnectionInfo(connectionProperties);
        Properties jmsInfoProps = jmsInfo.getJNDIProperties();
        jmsInfoProps.remove("java.naming.security.principal");
        jmsBean.setJNDIProperties(jmsInfoProps);
        if (jmsTopicService == null) {
            throw new XServletException(400, ErrorCode.E1601, "JMSTopicService is not initialized. JMS notificationmay not be enabled");
        }
        jmsBean.setTopicPrefix(jmsTopicService.getTopicPrefix());
        jmsBean.setTopicPatternProperties(jmsTopicService.getTopicPatternProperties());
        return jmsBean;
    }

    @Override
    protected Map<String, String> getOozieURLs() throws XServletException {
        Map<String, String> serverUrls = null;
        try {
            serverUrls = Services.get().get(JobsConcurrencyService.class).getServerUrls();
        }
        catch (Exception ex) {
            throw new XServletException(400, ErrorCode.E0307, ex.getMessage(), ex);
        }
        return serverUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendMetricsResponse(HttpServletResponse response) throws IOException, XServletException {
        if (metricsInstrumentation != null) {
            response.setStatus(200);
            response.setContentType("application/json; charset=\"UTF-8\"");
            try {
                metricsInstrumentation.writeJSONResponse((OutputStream)response.getOutputStream());
            }
            finally {
                response.getOutputStream().close();
            }
        } else {
            response.setStatus(503);
            response.sendError(503, "MetricsInstrumentationService is not running");
        }
    }

    @Override
    protected void sendInstrumentationResponse(HttpServletResponse response, Instrumentation instr) throws IOException, XServletException {
        if (metricsInstrumentation == null) {
            super.sendInstrumentationResponse(response, instr);
        } else {
            response.setStatus(503);
            response.sendError(503, "InstrumentationService is not running");
        }
    }
}

