/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Daemon;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class JvmPauseMonitorService
implements Service {
    private static XLog LOG = XLog.getLog(JvmPauseMonitorService.class);
    public static final String CONF_PREFIX = "oozie.service.JvmPauseMonitorService.";
    private static final long SLEEP_INTERVAL_MS = 500L;
    private long warnThresholdMs;
    private static final String WARN_THRESHOLD_KEY = "oozie.service.JvmPauseMonitorService.warn-threshold.ms";
    private static final long WARN_THRESHOLD_DEFAULT = 10000L;
    private long infoThresholdMs;
    private static final String INFO_THRESHOLD_KEY = "oozie.service.JvmPauseMonitorService.info-threshold.ms";
    private static final long INFO_THRESHOLD_DEFAULT = 1000L;
    private Thread monitorThread;
    private volatile boolean shouldRun = true;
    private Instrumentation instrumentation;

    @Override
    public void init(Services services) throws ServiceException {
        Configuration conf = services.getConf();
        this.warnThresholdMs = conf.getLong(WARN_THRESHOLD_KEY, 10000L);
        this.infoThresholdMs = conf.getLong(INFO_THRESHOLD_KEY, 1000L);
        this.instrumentation = services.get(InstrumentationService.class).get();
        Preconditions.checkState((this.monitorThread == null ? 1 : 0) != 0, (Object)"Already started");
        this.monitorThread = new Daemon((Runnable)new Monitor());
        this.monitorThread.start();
    }

    @Override
    public void destroy() {
        this.shouldRun = false;
        this.monitorThread.interrupt();
        try {
            this.monitorThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Class<? extends Service> getInterface() {
        return JvmPauseMonitorService.class;
    }

    private String formatMessage(long extraSleepTime, Map<String, GcTimes> gcTimesAfterSleep, Map<String, GcTimes> gcTimesBeforeSleep) {
        Sets.SetView gcBeanNames = Sets.intersection(gcTimesAfterSleep.keySet(), gcTimesBeforeSleep.keySet());
        ArrayList gcDiffs = Lists.newArrayList();
        for (String name : gcBeanNames) {
            GcTimes diff = gcTimesAfterSleep.get(name).subtract(gcTimesBeforeSleep.get(name));
            if (diff.gcCount == 0L) continue;
            gcDiffs.add("GC pool '" + name + "' had collection(s): " + diff.toString());
        }
        String ret = "Detected pause in JVM or host machine (eg GC): pause of approximately " + extraSleepTime + "ms\n";
        ret = gcDiffs.isEmpty() ? ret + "No GCs detected" : ret + Joiner.on((String)"\n").join((Iterable)gcDiffs);
        return ret;
    }

    private Map<String, GcTimes> getGcTimes() {
        HashMap map = Maps.newHashMap();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            map.put(gcBean.getName(), new GcTimes(gcBean));
        }
        return map;
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            Stopwatch sw = new Stopwatch();
            Map gcTimesBeforeSleep = JvmPauseMonitorService.this.getGcTimes();
            while (JvmPauseMonitorService.this.shouldRun) {
                sw.reset().start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                long extraSleepTime = sw.elapsedMillis() - 500L;
                Map gcTimesAfterSleep = JvmPauseMonitorService.this.getGcTimes();
                if (extraSleepTime > JvmPauseMonitorService.this.warnThresholdMs) {
                    LOG.warn(JvmPauseMonitorService.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                    JvmPauseMonitorService.this.instrumentation.incr("jvm", "pause.warn-threshold", 1L);
                } else if (extraSleepTime > JvmPauseMonitorService.this.infoThresholdMs) {
                    LOG.info(JvmPauseMonitorService.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                    JvmPauseMonitorService.this.instrumentation.incr("jvm", "pause.info-threshold", 1L);
                }
                JvmPauseMonitorService.this.instrumentation.incr("jvm", "pause.extraSleepTime", extraSleepTime);
                gcTimesBeforeSleep = gcTimesAfterSleep;
            }
        }
    }

    private static class GcTimes {
        private long gcCount;
        private long gcTimeMillis;

        private GcTimes(GarbageCollectorMXBean gcBean) {
            this.gcCount = gcBean.getCollectionCount();
            this.gcTimeMillis = gcBean.getCollectionTime();
        }

        private GcTimes(long count, long time) {
            this.gcCount = count;
            this.gcTimeMillis = time;
        }

        private GcTimes subtract(GcTimes other) {
            return new GcTimes(this.gcCount - other.gcCount, this.gcTimeMillis - other.gcTimeMillis);
        }

        public String toString() {
            return "count=" + this.gcCount + " time=" + this.gcTimeMillis + "ms";
        }
    }
}

