/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.StringBlob;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.QueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;

public class WorkflowActionQueryExecutor
extends QueryExecutor<WorkflowActionBean, WorkflowActionQuery> {
    private static WorkflowActionQueryExecutor instance = new WorkflowActionQueryExecutor();

    private WorkflowActionQueryExecutor() {
    }

    public static QueryExecutor<WorkflowActionBean, WorkflowActionQuery> getInstance() {
        return instance;
    }

    @Override
    public Query getUpdateQuery(WorkflowActionQuery namedQuery, WorkflowActionBean actionBean, EntityManager em) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case UPDATE_ACTION: {
                query.setParameter("conf", (Object)actionBean.getConfBlob());
                query.setParameter("consoleUrl", (Object)actionBean.getConsoleUrl());
                query.setParameter("data", (Object)actionBean.getDataBlob());
                query.setParameter("stats", (Object)actionBean.getStatsBlob());
                query.setParameter("externalChildIDs", (Object)actionBean.getExternalChildIDsBlob());
                query.setParameter("errorCode", (Object)actionBean.getErrorCode());
                query.setParameter("errorMessage", (Object)actionBean.getErrorMessage());
                query.setParameter("externalId", (Object)actionBean.getExternalId());
                query.setParameter("externalStatus", (Object)actionBean.getExternalStatus());
                query.setParameter("name", (Object)actionBean.getName());
                query.setParameter("cred", (Object)actionBean.getCred());
                query.setParameter("retries", (Object)actionBean.getRetries());
                query.setParameter("trackerUri", (Object)actionBean.getTrackerUri());
                query.setParameter("transition", (Object)actionBean.getTransition());
                query.setParameter("type", (Object)actionBean.getType());
                query.setParameter("endTime", (Object)actionBean.getEndTimestamp());
                query.setParameter("executionPath", (Object)actionBean.getExecutionPath());
                query.setParameter("lastCheckTime", (Object)actionBean.getLastCheckTimestamp());
                query.setParameter("logToken", (Object)actionBean.getLogToken());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("pendingAge", (Object)actionBean.getPendingAgeTimestamp());
                query.setParameter("signalValue", (Object)actionBean.getSignalValue());
                query.setParameter("slaXml", (Object)actionBean.getSlaXmlBlob());
                query.setParameter("startTime", (Object)actionBean.getStartTimestamp());
                query.setParameter("status", (Object)actionBean.getStatusStr());
                query.setParameter("wfId", (Object)actionBean.getWfId());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_ACTION_FOR_LAST_CHECKED_TIME: {
                query.setParameter("lastCheckTime", (Object)actionBean.getLastCheckTimestamp());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_ACTION_PENDING: {
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("pendingAge", (Object)actionBean.getPendingAgeTimestamp());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_ACTION_STATUS_PENDING: {
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("pendingAge", (Object)actionBean.getPendingAgeTimestamp());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_ACTION_PENDING_TRANS: {
                query.setParameter("transition", (Object)actionBean.getTransition());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("pendingAge", (Object)actionBean.getPendingAgeTimestamp());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_ACTION_PENDING_TRANS_ERROR: {
                query.setParameter("transition", (Object)actionBean.getTransition());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("pendingAge", (Object)actionBean.getPendingAgeTimestamp());
                query.setParameter("errorCode", (Object)actionBean.getErrorCode());
                query.setParameter("errorMessage", (Object)actionBean.getErrorMessage());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_ACTION_START: {
                query.setParameter("startTime", (Object)actionBean.getStartTimestamp());
                query.setParameter("externalChildIDs", (Object)actionBean.getExternalChildIDsBlob());
                query.setParameter("conf", (Object)actionBean.getConfBlob());
                query.setParameter("errorCode", (Object)actionBean.getErrorCode());
                query.setParameter("errorMessage", (Object)actionBean.getErrorMessage());
                query.setParameter("externalId", (Object)actionBean.getExternalId());
                query.setParameter("trackerUri", (Object)actionBean.getTrackerUri());
                query.setParameter("consoleUrl", (Object)actionBean.getConsoleUrl());
                query.setParameter("lastCheckTime", (Object)actionBean.getLastCheckTimestamp());
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("externalStatus", (Object)actionBean.getExternalStatus());
                query.setParameter("data", (Object)actionBean.getDataBlob());
                query.setParameter("retries", (Object)actionBean.getRetries());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("pendingAge", (Object)actionBean.getPendingAgeTimestamp());
                query.setParameter("userRetryCount", (Object)actionBean.getUserRetryCount());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_ACTION_CHECK: {
                query.setParameter("externalChildIDs", (Object)actionBean.getExternalChildIDsBlob());
                query.setParameter("externalStatus", (Object)actionBean.getExternalStatus());
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("data", (Object)actionBean.getDataBlob());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("errorCode", (Object)actionBean.getErrorCode());
                query.setParameter("errorMessage", (Object)actionBean.getErrorMessage());
                query.setParameter("lastCheckTime", (Object)actionBean.getLastCheckTimestamp());
                query.setParameter("retries", (Object)actionBean.getRetries());
                query.setParameter("pendingAge", (Object)actionBean.getPendingAgeTimestamp());
                query.setParameter("startTime", (Object)actionBean.getStartTimestamp());
                query.setParameter("stats", (Object)actionBean.getStatsBlob());
                query.setParameter("userRetryCount", (Object)actionBean.getUserRetryCount());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_ACTION_END: {
                query.setParameter("errorCode", (Object)actionBean.getErrorCode());
                query.setParameter("errorMessage", (Object)actionBean.getErrorMessage());
                query.setParameter("retries", (Object)actionBean.getRetries());
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("endTime", (Object)actionBean.getEndTimestamp());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("pendingAge", (Object)actionBean.getPendingAgeTimestamp());
                query.setParameter("signalValue", (Object)actionBean.getSignalValue());
                query.setParameter("userRetryCount", (Object)actionBean.getUserRetryCount());
                query.setParameter("externalStatus", (Object)actionBean.getExternalStatus());
                query.setParameter("stats", (Object)actionBean.getStatsBlob());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public Query getSelectQuery(WorkflowActionQuery namedQuery, EntityManager em, Object ... parameters) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case GET_ACTION: 
            case GET_ACTION_ID_TYPE_LASTCHECK: 
            case GET_ACTION_FAIL: 
            case GET_ACTION_SIGNAL: 
            case GET_ACTION_CHECK: 
            case GET_ACTION_END: 
            case GET_ACTION_COMPLETED: {
                query.setParameter("id", parameters[0]);
                break;
            }
            case GET_RUNNING_ACTIONS: {
                Timestamp ts = new Timestamp(System.currentTimeMillis() - (long)((Integer)parameters[0] * 1000));
                query.setParameter("lastCheckTime", (Object)ts);
                break;
            }
            case GET_PENDING_ACTIONS: {
                Long minimumPendingAgeSecs = (Long)parameters[0];
                Timestamp pts = new Timestamp(System.currentTimeMillis() - minimumPendingAgeSecs * 1000L);
                query.setParameter("pendingAge", (Object)pts);
                break;
            }
            case GET_ACTIONS_FOR_WORKFLOW_RERUN: {
                query.setParameter("wfId", parameters[0]);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public int executeUpdate(WorkflowActionQuery namedQuery, WorkflowActionBean actionBean) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getUpdateQuery(namedQuery, actionBean, em);
        int ret = jpaService.executeUpdate(namedQuery.name(), query, em);
        return ret;
    }

    private WorkflowActionBean constructBean(WorkflowActionQuery namedQuery, Object ret) throws JPAExecutorException {
        WorkflowActionBean bean;
        switch (namedQuery) {
            case GET_ACTION: {
                bean = (WorkflowActionBean)ret;
                break;
            }
            case GET_ACTION_ID_TYPE_LASTCHECK: {
                bean = new WorkflowActionBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setType((String)arr[1]);
                bean.setLastCheckTime(DateUtils.toDate((Timestamp)arr[2]));
                break;
            }
            case GET_ACTION_FAIL: {
                bean = new WorkflowActionBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setJobId((String)arr[1]);
                bean.setName((String)arr[2]);
                bean.setStatusStr((String)arr[3]);
                bean.setPending((Integer)arr[4]);
                bean.setType((String)arr[5]);
                bean.setLogToken((String)arr[6]);
                bean.setTransition((String)arr[7]);
                bean.setErrorInfo((String)arr[8], (String)arr[9]);
                break;
            }
            case GET_ACTION_SIGNAL: {
                bean = new WorkflowActionBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setJobId((String)arr[1]);
                bean.setName((String)arr[2]);
                bean.setStatusStr((String)arr[3]);
                bean.setPending((Integer)arr[4]);
                bean.setPendingAge(DateUtils.toDate((Timestamp)arr[5]));
                bean.setType((String)arr[6]);
                bean.setLogToken((String)arr[7]);
                bean.setTransition((String)arr[8]);
                bean.setErrorInfo((String)arr[9], (String)arr[10]);
                bean.setExecutionPath((String)arr[11]);
                bean.setSignalValue((String)arr[12]);
                bean.setSlaXmlBlob((StringBlob)arr[13]);
                break;
            }
            case GET_ACTION_CHECK: {
                bean = new WorkflowActionBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setJobId((String)arr[1]);
                bean.setName((String)arr[2]);
                bean.setStatusStr((String)arr[3]);
                bean.setPending((Integer)arr[4]);
                bean.setPendingAge(DateUtils.toDate((Timestamp)arr[5]));
                bean.setType((String)arr[6]);
                bean.setLogToken((String)arr[7]);
                bean.setTransition((String)arr[8]);
                bean.setRetries((Integer)arr[9]);
                bean.setUserRetryCount((Integer)arr[10]);
                bean.setUserRetryMax((Integer)arr[11]);
                bean.setUserRetryInterval((Integer)arr[12]);
                bean.setTrackerUri((String)arr[13]);
                bean.setStartTime(DateUtils.toDate((Timestamp)arr[14]));
                bean.setEndTime(DateUtils.toDate((Timestamp)arr[15]));
                bean.setLastCheckTime(DateUtils.toDate((Timestamp)arr[16]));
                bean.setErrorInfo((String)arr[17], (String)arr[18]);
                bean.setExternalId((String)arr[19]);
                bean.setExternalStatus((String)arr[20]);
                bean.setExternalChildIDsBlob((StringBlob)arr[21]);
                bean.setConfBlob((StringBlob)arr[22]);
                break;
            }
            case GET_ACTION_END: {
                bean = new WorkflowActionBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setJobId((String)arr[1]);
                bean.setName((String)arr[2]);
                bean.setStatusStr((String)arr[3]);
                bean.setPending((Integer)arr[4]);
                bean.setPendingAge(DateUtils.toDate((Timestamp)arr[5]));
                bean.setType((String)arr[6]);
                bean.setLogToken((String)arr[7]);
                bean.setTransition((String)arr[8]);
                bean.setRetries((Integer)arr[9]);
                bean.setTrackerUri((String)arr[10]);
                bean.setUserRetryCount((Integer)arr[11]);
                bean.setUserRetryMax((Integer)arr[12]);
                bean.setUserRetryInterval((Integer)arr[13]);
                bean.setStartTime(DateUtils.toDate((Timestamp)arr[14]));
                bean.setEndTime(DateUtils.toDate((Timestamp)arr[15]));
                bean.setErrorInfo((String)arr[16], (String)arr[17]);
                bean.setExternalId((String)arr[18]);
                bean.setExternalStatus((String)arr[19]);
                bean.setExternalChildIDsBlob((StringBlob)arr[20]);
                bean.setConfBlob((StringBlob)arr[21]);
                bean.setDataBlob((StringBlob)arr[22]);
                bean.setStatsBlob((StringBlob)arr[23]);
                break;
            }
            case GET_ACTION_COMPLETED: {
                bean = new WorkflowActionBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setJobId((String)arr[1]);
                bean.setStatusStr((String)arr[2]);
                bean.setType((String)arr[3]);
                bean.setLogToken((String)arr[4]);
                break;
            }
            case GET_RUNNING_ACTIONS: {
                bean = new WorkflowActionBean();
                bean.setId((String)ret);
                break;
            }
            case GET_PENDING_ACTIONS: {
                bean = new WorkflowActionBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setJobId((String)arr[1]);
                bean.setStatusStr((String)arr[2]);
                bean.setType((String)arr[3]);
                bean.setPendingAge(DateUtils.toDate((Timestamp)arr[4]));
                break;
            }
            case GET_ACTIONS_FOR_WORKFLOW_RERUN: {
                bean = new WorkflowActionBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setName((String)arr[1]);
                bean.setStatusStr((String)arr[2]);
                bean.setEndTime(DateUtils.toDate((Timestamp)arr[3]));
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot construct action bean for " + namedQuery.name());
            }
        }
        return bean;
    }

    @Override
    public WorkflowActionBean get(WorkflowActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        Object ret = jpaService.executeGet(namedQuery.name(), query, em);
        if (ret == null) {
            throw new JPAExecutorException(ErrorCode.E0605, query.toString());
        }
        WorkflowActionBean bean = this.constructBean(namedQuery, ret);
        return bean;
    }

    @Override
    public List<WorkflowActionBean> getList(WorkflowActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        List<?> retList = jpaService.executeGetList(namedQuery.name(), query, em);
        ArrayList<WorkflowActionBean> beanList = new ArrayList<WorkflowActionBean>();
        if (retList != null) {
            for (Object ret : retList) {
                beanList.add(this.constructBean(namedQuery, ret));
            }
        }
        return beanList;
    }

    @Override
    public Object getSingleValue(WorkflowActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        throw new UnsupportedOperationException();
    }

    public static enum WorkflowActionQuery {
        UPDATE_ACTION,
        UPDATE_ACTION_FOR_LAST_CHECKED_TIME,
        UPDATE_ACTION_START,
        UPDATE_ACTION_CHECK,
        UPDATE_ACTION_END,
        UPDATE_ACTION_PENDING,
        UPDATE_ACTION_STATUS_PENDING,
        UPDATE_ACTION_PENDING_TRANS,
        UPDATE_ACTION_PENDING_TRANS_ERROR,
        GET_ACTION,
        GET_ACTION_ID_TYPE_LASTCHECK,
        GET_ACTION_FAIL,
        GET_ACTION_SIGNAL,
        GET_ACTION_CHECK,
        GET_ACTION_END,
        GET_ACTION_COMPLETED,
        GET_RUNNING_ACTIONS,
        GET_PENDING_ACTIONS,
        GET_ACTIONS_FOR_WORKFLOW_RERUN;

    }
}

