/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.examples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ftp4che.FTPConnection;
import org.ftp4che.FTPConnectionFactory;
import org.ftp4che.commands.Command;
import org.ftp4che.exception.AuthenticationNotSupportedException;
import org.ftp4che.exception.ConfigurationException;
import org.ftp4che.exception.FtpIOException;
import org.ftp4che.exception.FtpWorkflowException;
import org.ftp4che.util.ftpfile.FTPFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UltimateBugFinder {
    private static Logger log = Logger.getLogger((String)"MAIN");
    private static List<Properties> connections;
    private static FTPFile homeDirectory;
    private static FTPFile testfile1mb;
    private static FTPFile testfile5mb;
    private static FTPFile testfile10mb;
    private static FTPFile testdir;

    public UltimateBugFinder(List<Properties> connections) {
        UltimateBugFinder.connections = connections;
    }

    private static void execute() {
        for (Properties conf : connections) {
            FTPConnection conn = null;
            try {
                conn = FTPConnectionFactory.getInstance(conf);
            }
            catch (ConfigurationException ce) {
                log.error((Object)"could not get an instance of FTPConnection!", (Throwable)ce);
            }
            try {
                conn.connect();
                conn.checkSystem();
                conn.sendCommand(new Command("NOOP"));
                conn.noOperation();
                conn.setTransferType(false);
                conn.setTransferType(true);
                conn.getWorkDirectory();
                conn.makeDirectory("testdir");
                conn.changeDirectory("testdir");
                conn.changeToParentDirectory();
                conn.removeDirectory("testdir");
                conn.makeDirectory("testdir");
                conn.removeDirectory(new FTPFile(conn.getWorkDirectory(), "testdir", true));
                conn.makeDirectory("test");
                conn.changeDirectory("test");
                conn.uploadFile(testfile1mb, new FTPFile(conn.getWorkDirectory(), "1mb", false));
                conn.uploadFile(testfile5mb, new FTPFile(conn.getWorkDirectory(), "5mb", false));
                conn.uploadFile(testfile10mb, new FTPFile(conn.getWorkDirectory(), "10mb", false));
                conn.downloadFile(new FTPFile(conn.getWorkDirectory(), "1mb", false), new FTPFile(new File(homeDirectory.getFile(), "downloaded_1mb")));
                conn.downloadFile(new FTPFile(conn.getWorkDirectory(), "5mb", false), new FTPFile(new File(homeDirectory.getFile(), "downloaded_5mb")));
                conn.downloadFile(new FTPFile(conn.getWorkDirectory(), "10mb", false), new FTPFile(new File(homeDirectory.getFile(), "downloaded_10mb")));
                conn.renameFile(new FTPFile(conn.getWorkDirectory(), "1mb", false), new FTPFile(conn.getWorkDirectory(), "1mb_renamed", false));
                conn.renameFile(new FTPFile(conn.getWorkDirectory(), "5mb", false), new FTPFile(conn.getWorkDirectory(), "5mb_renamed", false));
                conn.renameFile(new FTPFile(conn.getWorkDirectory(), "10mb", false), new FTPFile(conn.getWorkDirectory(), "10mb_renamed", false));
                conn.deleteFile(new FTPFile(conn.getWorkDirectory(), "1mb_renamed", false));
                conn.deleteFile(new FTPFile(conn.getWorkDirectory(), "5mb_renamed", false));
                conn.deleteFile(new FTPFile(conn.getWorkDirectory(), "10mb_renamed", false));
                conn.changeToParentDirectory();
                conn.removeDirectory("test");
                conn.uploadDirectory(testdir, new FTPFile(conn.getWorkDirectory(), "testdir", true));
                conn.changeDirectory("testdir");
                conn.getDirectoryListing();
                conn.getDirectoryListing("testdir");
                conn.getFastDirectoryListing();
                conn.changeToParentDirectory();
                conn.downloadDirectory(new FTPFile("", "testdir", true), new FTPFile(new File(homeDirectory.getFile(), "testdir_downloaded")));
                conn.deleteDirectory(new FTPFile("", "testdir", true));
                conn.sendSiteCommand("HELP");
                conn.disconnect();
            }
            catch (AuthenticationNotSupportedException anse) {
                log.error((Object)"The used connect authentification method is not supported!", (Throwable)anse);
            }
            catch (FtpWorkflowException fwe) {
                log.error((Object)"Some exception concerning the FTP workflow occured!", (Throwable)fwe);
            }
            catch (FtpIOException fio) {
                log.error((Object)"An Ftp IO Error occured!", (Throwable)fio);
            }
            catch (IOException ioe) {
                log.error((Object)"An IO Error!", (Throwable)ioe);
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<Properties> conns = new ArrayList<Properties>();
        Properties pt1 = new Properties();
        pt1.setProperty("connection.host", "127.0.0.1");
        pt1.setProperty("connection.port", "21");
        pt1.setProperty("user.login", "ftpuser");
        pt1.setProperty("user.password", "ftp4che");
        pt1.setProperty("connection.type", "FTP_CONNECTION");
        pt1.setProperty("connection.timeout", "10000");
        pt1.setProperty("connection.passive", "true");
        Properties pt2 = new Properties();
        pt2.setProperty("connection.host", "172.25.12.197");
        pt2.setProperty("connection.port", "23");
        pt2.setProperty("user.login", "ftpuser");
        pt2.setProperty("user.password", "ftp4che");
        pt2.setProperty("connection.type", "FTP_CONNECTION");
        pt2.setProperty("connection.timeout", "10000");
        pt2.setProperty("connection.passive", "true");
        Properties pt3 = new Properties();
        pt3.setProperty("connection.host", "172.25.12.200");
        pt3.setProperty("connection.port", "21");
        pt3.setProperty("user.login", "ftpuser");
        pt3.setProperty("user.password", "ftp4che");
        pt3.setProperty("connection.type", "FTP_CONNECTION");
        pt3.setProperty("connection.timeout", "10000");
        pt3.setProperty("connection.passive", "true");
        Properties pt4 = new Properties();
        pt4.setProperty("connection.host", "172.25.13.186");
        pt4.setProperty("connection.port", "21");
        pt4.setProperty("user.login", "ftpuser");
        pt4.setProperty("user.password", "ftp4che");
        pt4.setProperty("connection.type", "FTP_CONNECTION");
        pt4.setProperty("connection.timeout", "10000");
        pt4.setProperty("connection.passive", "true");
        Properties pt5 = new Properties();
        pt5.setProperty("connection.host", "172.25.13.149");
        pt5.setProperty("connection.port", "21");
        pt5.setProperty("user.login", "ftpuser");
        pt5.setProperty("user.password", "ftp4che");
        pt5.setProperty("connection.type", "FTP_CONNECTION");
        pt5.setProperty("connection.timeout", "10000");
        pt5.setProperty("connection.passive", "true");
        conns.add(pt1);
        UltimateBugFinder ubf = new UltimateBugFinder(conns);
        UltimateBugFinder.execute();
    }

    static {
        homeDirectory = new FTPFile(new File("/tmp"));
        testfile1mb = new FTPFile(new File("/tmp/1mb"));
        testfile5mb = new FTPFile(new File("/tmp/5mb"));
        testfile10mb = new FTPFile(new File("/tmp/10mb"));
        testdir = new FTPFile(new File("/tmp/uploaddir"));
    }
}

