/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.tabletype;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.pms.messages.Messages;

public class TableTypeSettings {
    public static final int TYPE_OTHER = 0;
    public static final int TYPE_DIMENSION = 1;
    public static final int TYPE_FACT = 2;
    private static final String[] typeCodes = new String[]{"Other", "Dimension", "Fact"};
    private static final String[] typeDescriptions = new String[]{Messages.getString("TableTypeSettings.USER_OTHER_DESC"), Messages.getString("TableTypeSettings.USER_DIMENSION_DESC"), Messages.getString("TableTypeSettings.USER_FACT_DESC")};
    public static final TableTypeSettings OTHER = new TableTypeSettings(0);
    public static final TableTypeSettings DIMENSION = new TableTypeSettings(1);
    public static final TableTypeSettings FACT = new TableTypeSettings(2);
    public static final TableTypeSettings[] types = new TableTypeSettings[]{OTHER, DIMENSION, FACT};
    private int type;

    public TableTypeSettings(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isFact() {
        return this.type == 2;
    }

    public boolean isDimension() {
        return this.type == 1;
    }

    public String getDescription() {
        return typeDescriptions[this.type];
    }

    public String getCode() {
        return typeCodes[this.type];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableTypeSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TableTypeSettings rhs = (TableTypeSettings)obj;
        return new EqualsBuilder().append(this.type, rhs.type).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(233, 281).append(this.type).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.type).toString();
    }

    public static TableTypeSettings getType(String description) {
        int i;
        for (i = 0; i < typeDescriptions.length; ++i) {
            if (!typeDescriptions[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        for (i = 0; i < typeCodes.length; ++i) {
            if (!typeCodes[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        return OTHER;
    }

    public static String[] getTypeDescriptions() {
        return (String[])typeDescriptions.clone();
    }
}

