/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

public class CsvDataReader {
    private static final Log logger = LogFactory.getLog(QueryXmlHelper.class);
    private String fileLocation;
    private boolean headerPresent;
    private String enclosure;
    private String delimiter;
    private int rowLimit;
    private List<String> header;
    private List<List<String>> data;
    private int columnCount;

    public CsvDataReader(String fileLocation, boolean headerPresent, String delimiter, String enclosure, int rowLimit) {
        this.fileLocation = fileLocation;
        this.headerPresent = headerPresent;
        this.delimiter = delimiter;
        this.enclosure = enclosure;
        this.rowLimit = rowLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> loadData() {
        String line = null;
        ArrayList<List<String>> dataSample = new ArrayList<List<String>>(this.rowLimit);
        ArrayList<String> rowData = null;
        InputStreamReader reader = null;
        CSVTokenizer csvt = null;
        LineIterator lineIterator = null;
        try {
            InputStream inputStream = KettleVFS.getInputStream((String)this.fileLocation);
            reader = new InputStreamReader(inputStream);
            lineIterator = new LineIterator((Reader)reader);
            int row = 0;
            while (row < this.rowLimit && lineIterator.hasNext()) {
                line = lineIterator.nextLine();
                ++row;
                csvt = new CSVTokenizer(line, this.delimiter, this.enclosure, false);
                rowData = new ArrayList<String>();
                int count = 0;
                while (csvt.hasMoreTokens()) {
                    rowData.add(csvt.nextToken());
                    ++count;
                }
                if (this.columnCount < count) {
                    this.columnCount = count;
                }
                if (this.headerPresent && row == 1) {
                    this.header = rowData;
                    continue;
                }
                dataSample.add(rowData);
            }
        }
        catch (KettleFileException e) {
            try {
                logger.error((Object)Messages.getString("CsvDataReader.ERROR_0001_Failed", new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                LineIterator.closeQuietly(lineIterator);
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            LineIterator.closeQuietly(lineIterator);
            IOUtils.closeQuietly((Reader)reader);
        }
        LineIterator.closeQuietly((LineIterator)lineIterator);
        IOUtils.closeQuietly((Reader)reader);
        this.data = dataSample;
        return dataSample;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<String> getColumnData(int columnNumber) {
        ArrayList<String> dataSample = new ArrayList<String>(this.rowLimit);
        for (List<String> row : this.data) {
            if (row.size() <= columnNumber) continue;
            dataSample.add(row.get(columnNumber));
        }
        return dataSample;
    }

    public int getColumnCount() {
        return this.columnCount;
    }
}

