/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckerException;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.visitor.TypeCheckingExpVisitor;

public class TypeCheckingRelVisitor
extends LogicalRelationalNodesVisitor {
    private CompilationMessageCollector msgCollector;

    public TypeCheckingRelVisitor(OperatorPlan plan, CompilationMessageCollector msgCollector) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
        this.msgCollector = msgCollector;
    }

    @Override
    public void visit(LOLoad load) {
    }

    @Override
    public void visit(LOStore store) throws FrontendException {
        store.resetSchema();
        store.getSchema();
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
        filter.resetSchema();
        LogicalExpressionPlan comparisonPlan = filter.getFilterPlan();
        if (comparisonPlan.getSources().size() > 1) {
            int errCode = 1057;
            String msg = "Filter's cond plan can only have one output";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(filter, msg, errCode, (byte)2, null);
        }
        this.visitExpressionPlan(comparisonPlan, filter);
        byte innerCondType = ((LogicalExpression)comparisonPlan.getSources().get(0)).getType();
        if (innerCondType != 5) {
            int errCode = 1058;
            String msg = "Filter's condition must evaluate to boolean. Found: " + DataType.findTypeName(innerCondType);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(filter, msg, errCode, (byte)2, null);
        }
        try {
            filter.resetSchema();
            filter.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1059;
            String msg = "Problem while reconciling output schema of Filter";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(filter, msg, errCode, (byte)2, fe);
        }
    }

    private void throwTypeCheckerException(Operator op, String msg, int errCode, byte input, FrontendException fe) throws TypeCheckerException {
        if (fe == null) {
            throw new TypeCheckerException(op, msg, errCode, 2);
        }
        throw new TypeCheckerException(op, msg, errCode, 2, fe);
    }

    @Override
    public void visit(LOGenerate gen) throws FrontendException {
        for (int i = 0; i < gen.getOutputPlans().size(); ++i) {
            LogicalExpressionPlan expPlan = gen.getOutputPlans().get(i);
            if (expPlan.getSources().size() > 1) {
                int errCode = 1057;
                String msg = "LOGenerate expression plan can only have one output";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                this.throwTypeCheckerException(gen, msg, errCode, (byte)4, null);
            }
            this.visitExpressionPlan(expPlan, gen);
        }
        gen.resetSchema();
        gen.getSchema();
    }

    @Override
    public void visit(LOInnerLoad innerLoad) throws FrontendException {
        innerLoad.resetSchema();
        innerLoad.getSchema();
    }

    @Override
    public void visit(LOForEach forEach) throws FrontendException {
        try {
            new TypeCheckingRelVisitor((OperatorPlan)forEach.getInnerPlan(), this.msgCollector).visit();
            forEach.resetSchema();
            forEach.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1059;
            String msg = "Problem while reconciling output schema of ForEach";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(forEach, msg, errCode, (byte)2, fe);
        }
    }

    private void visitExpressionPlan(LogicalExpressionPlan explPlan, LogicalRelationalOperator relOp) throws FrontendException {
        TypeCheckingExpVisitor expTypeCheck = new TypeCheckingExpVisitor(explPlan, this.msgCollector, relOp);
        expTypeCheck.visit();
    }

    @Override
    public void visit(LOUnion u) throws FrontendException {
        u.resetSchema();
        ArrayList<Operator> inputs = new ArrayList<Operator>(u.getInputs());
        if (inputs.size() < 2) {
            throw new AssertionError((Object)"Union with Count(Operand) < 2");
        }
        LogicalSchema schema = null;
        try {
            schema = u.getSchema();
        }
        catch (FrontendException fee) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of Union";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(u, msg, errCode, (byte)2, fee);
        }
        if (schema != null && !u.isOnSchema()) {
            for (int i = 0; i < inputs.size(); ++i) {
                LOForEach insertedOp = this.insertCastForEachInBetweenIfNecessary((LogicalRelationalOperator)inputs.get(i), u);
                if (insertedOp == null) continue;
                if (insertedOp.getAlias() == null) {
                    insertedOp.setAlias(((LogicalRelationalOperator)inputs.get(i)).getAlias());
                }
                try {
                    this.visit(insertedOp);
                    continue;
                }
                catch (FrontendException fee) {
                    int errCode = 1056;
                    String msg = "Problem while casting inputs of Union";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    this.throwTypeCheckerException(u, msg, errCode, (byte)2, fee);
                }
            }
        }
        u.resetSchema();
        u.getSchema();
    }

    private LOForEach insertCastForEachInBetweenIfNecessary(LogicalRelationalOperator fromOp, LogicalRelationalOperator toOp) throws FrontendException {
        List<Operator> preList = this.plan.getPredecessors(toOp);
        boolean found = false;
        for (Operator tmpOp : preList) {
            if (tmpOp != fromOp) continue;
            found = true;
            break;
        }
        if (!found) {
            int errCode = 1077;
            String msg = "Two operators that require a cast in between are not adjacent.";
            this.throwTypeCheckerException(fromOp, msg, errCode, (byte)2, null);
        }
        LogicalSchema fromSchema = null;
        LogicalSchema toSchema = null;
        try {
            fromSchema = fromOp.getSchema();
            toSchema = toOp.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schema from input of " + fromOp.getClass().getSimpleName();
            this.throwTypeCheckerException(fromOp, msg, errCode, (byte)4, fe);
        }
        if (fromSchema.size() != toSchema.size()) {
            int errCode = 1078;
            String msg = "Schema size mismatch for casting. Input schema size: " + fromSchema.size() + ". Target schema size: " + toSchema.size();
            this.throwTypeCheckerException(toOp, msg, errCode, (byte)2, null);
        }
        ArrayList<LogicalExpressionPlan> generatePlans = new ArrayList<LogicalExpressionPlan>();
        LogicalPlan innerPlan = new LogicalPlan();
        LOGenerate loGen = new LOGenerate(innerPlan, generatePlans, new boolean[toSchema.size()]);
        innerPlan.add(loGen);
        LOForEach foreach = new LOForEach(this.plan);
        foreach.setInnerPlan(innerPlan);
        int castNeededCounter = 0;
        for (int i = 0; i < fromSchema.size(); ++i) {
            LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, i);
            innerPlan.add(innerLoad);
            innerPlan.connect(innerLoad, loGen);
            LogicalExpressionPlan genPlan = new LogicalExpressionPlan();
            ProjectExpression project = new ProjectExpression(genPlan, i, 0, loGen);
            genPlan.add(project);
            LogicalSchema.LogicalFieldSchema fs = null;
            fs = fromSchema.getField(i);
            LogicalSchema.LogicalFieldSchema outFieldSchema = toSchema.getField(i);
            if (outFieldSchema.type != fs.type) {
                ++castNeededCounter;
                new CastExpression(genPlan, project, outFieldSchema);
            }
            generatePlans.add(genPlan);
        }
        if (castNeededCounter > 0) {
            ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
            for (int i = 0; i < toSchema.size(); ++i) {
                flattenList.add(false);
            }
            this.plan.add(foreach);
            this.plan.insertBetween(fromOp, foreach, toOp);
            return foreach;
        }
        this.plan.remove(foreach);
        return null;
    }

    @Override
    public void visit(LOSplitOutput op) throws FrontendException {
        LogicalExpressionPlan condPlan;
        op.resetSchema();
        OperatorPlan lp = op.getPlan();
        List<Operator> list = lp.getPredecessors(op);
        if (list.size() != 1) {
            int errCode = 2008;
            String msg = "LOSplitOutput cannot have more than one input. Found: " + list.size() + " input(s).";
            this.throwTypeCheckerException(op, msg, errCode, (byte)4, null);
        }
        if ((condPlan = op.getFilterPlan()).getSources().size() != 1) {
            int errCode = 1057;
            String msg = "Split's inner plan can only have one output (leaf)";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(op, msg, errCode, (byte)2, null);
        }
        this.visitExpressionPlan(condPlan, op);
        byte innerCondType = ((LogicalExpression)condPlan.getSources().get(0)).getType();
        if (innerCondType != 5) {
            int errCode = 1058;
            String msg = "Split's condition must evaluate to boolean. Found: " + DataType.findTypeName(innerCondType);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(op, msg, errCode, (byte)2, null);
        }
        try {
            op.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of SplitOutput";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(op, msg, errCode, (byte)2, fe);
        }
    }

    @Override
    public void visit(LODistinct op) throws VisitorException {
        op.resetSchema();
        try {
            op.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of Distinct";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(op, msg, errCode, (byte)2, fe);
        }
    }

    @Override
    public void visit(LOLimit limit) throws FrontendException {
        String msg;
        limit.resetSchema();
        LogicalExpressionPlan expressionPlan = limit.getLimitPlan();
        if (expressionPlan != null) {
            if (expressionPlan.getSources().size() > 1) {
                int errCode = 1057;
                String msg2 = "Limit's expression plan can only have one output";
                this.msgCollector.collect(msg2, CompilationMessageCollector.MessageType.Error);
                this.throwTypeCheckerException(limit, msg2, errCode, (byte)2, null);
            }
            this.visitExpressionPlan(expressionPlan, limit);
            byte innerCondType = ((LogicalExpression)expressionPlan.getSources().get(0)).getType();
            if (innerCondType == 50) {
                this.insertAtomicCastForInnerPlan(expressionPlan, limit, (byte)15);
            } else if (innerCondType != 15 && innerCondType != 10) {
                int errCode = 1058;
                msg = "Limit's expression must evaluate to Long or Integer. Found: " + DataType.findTypeName(innerCondType);
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                this.throwTypeCheckerException(limit, msg, errCode, (byte)2, null);
            }
        }
        try {
            limit.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            msg = "Problem while reading schemas from inputs of Limit";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(limit, msg, errCode, (byte)2, fe);
        }
    }

    @Override
    public void visit(LOCross cs) throws VisitorException {
        cs.resetSchema();
        try {
            cs.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of Cross";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(cs, msg, errCode, (byte)2, fe);
        }
    }

    @Override
    public void visit(LOSort sort) throws FrontendException {
        sort.resetSchema();
        for (int i = 0; i < sort.getSortColPlans().size(); ++i) {
            LogicalExpressionPlan sortColPlan = sort.getSortColPlans().get(i);
            if (sortColPlan.getSources().size() != 1) {
                int errCode = 1057;
                String msg = "Sort's inner plan can only have one output (leaf)";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                this.throwTypeCheckerException(sort, msg, errCode, (byte)2, null);
            }
            this.visitExpressionPlan(sortColPlan, sort);
        }
        try {
            sort.getSchema();
        }
        catch (FrontendException fee) {
            int errCode = 1059;
            String msg = "Problem while reconciling output schema of Sort";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(sort, msg, errCode, (byte)2, fee);
        }
    }

    @Override
    public void visit(LORank rank) throws FrontendException {
        rank.resetSchema();
        List<LogicalExpressionPlan> rankColPlans = rank.getRankColPlans();
        for (int i = 0; i < rankColPlans.size(); ++i) {
            LogicalExpressionPlan rankColPlan = rankColPlans.get(i);
            if (rankColPlan.getSources().size() != 1) {
                int errCode = 1057;
                String msg = "Rank's inner plan can only have one output (leaf)";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                this.throwTypeCheckerException(rank, msg, errCode, (byte)2, null);
            }
            this.visitExpressionPlan(rankColPlan, rank);
        }
        try {
            rank.getSchema();
        }
        catch (FrontendException fee) {
            int errCode = 1059;
            String msg = "Problem while reconciling output schema of Rank";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(rank, msg, errCode, (byte)2, fee);
        }
    }

    @Override
    public void visit(LOSplit split) throws VisitorException {
        OperatorPlan lp = split.getPlan();
        List<Operator> inputList = lp.getPredecessors(split);
        if (inputList.size() != 1) {
            int errCode = 2008;
            String msg = "LOSplit cannot have more than one input. Found: " + inputList.size() + " input(s).";
            this.throwTypeCheckerException(split, msg, errCode, (byte)4, null);
        }
        split.resetSchema();
        try {
            split.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1059;
            String msg = "Problem while reconciling output schema of Split";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(split, msg, errCode, (byte)2, fe);
        }
    }

    @Override
    public void visit(LOJoin join) throws FrontendException {
        int errCode;
        try {
            join.resetSchema();
            join.getSchema();
        }
        catch (FrontendException fe) {
            int errCode2 = 1060;
            String msg = "Cannot resolve Join output schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(join, msg, errCode2, (byte)2, fe);
        }
        MultiMap<Integer, LogicalExpressionPlan> joinColPlans = join.getExpressionPlans();
        List<Operator> inputs = join.getInputs((LogicalPlan)this.plan);
        for (int i = 0; i < inputs.size(); ++i) {
            ArrayList<LogicalExpressionPlan> innerPlans = new ArrayList<LogicalExpressionPlan>(joinColPlans.get(i));
            for (int j = 0; j < innerPlans.size(); ++j) {
                LogicalExpressionPlan innerPlan = innerPlans.get(j);
                if (innerPlan.getSources().size() != 1) {
                    int errCode3 = 1057;
                    String msg = "Join's inner plans can only have one output (leaf)";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    this.throwTypeCheckerException(join, msg, errCode3, (byte)2, null);
                }
                this.visitExpressionPlan(innerPlan, join);
            }
        }
        try {
            int i;
            if (!this.isJoinOnMultiCols(join)) {
                byte groupType = this.getAtomicJoinColType(join);
                for (i = 0; i < inputs.size(); ++i) {
                    Collection<LogicalExpressionPlan> exprPlans = join.getJoinPlan(i);
                    LogicalExpressionPlan exprPlan = exprPlans.iterator().next();
                    byte innerType = ((LogicalExpression)exprPlan.getSources().get(0)).getType();
                    if (innerType == groupType) continue;
                    this.insertAtomicCastForInnerPlan(exprPlan, join, groupType);
                }
            } else {
                LogicalSchema groupBySchema = this.getSchemaFromInnerPlans(join.getExpressionPlans(), join);
                for (i = 0; i < inputs.size(); ++i) {
                    ArrayList<LogicalExpressionPlan> innerPlans = new ArrayList<LogicalExpressionPlan>(join.getJoinPlan(i));
                    for (int j = 0; j < innerPlans.size(); ++j) {
                        LogicalExpressionPlan innerPlan = (LogicalExpressionPlan)innerPlans.get(j);
                        LogicalExpression outputExp = (LogicalExpression)innerPlan.getSources().get(0);
                        byte innerType = outputExp.getType();
                        byte expectedType = groupBySchema.getField((int)j).type;
                        if (!DataType.isAtomic(innerType) && 110 != innerType) {
                            int errCode4 = 1057;
                            String msg = "Join's inner plans can onlyhave one output (leaf)";
                            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                            this.throwTypeCheckerException(join, msg, errCode4, (byte)2, null);
                        }
                        if (innerType == expectedType) continue;
                        this.insertAtomicCastForInnerPlan(innerPlan, join, expectedType);
                    }
                }
            }
        }
        catch (FrontendException fe) {
            errCode = 1060;
            String msg = "Cannot resolve Join output schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(join, msg, errCode, (byte)2, fe);
        }
        try {
            join.resetSchema();
            join.getSchema();
        }
        catch (FrontendException fe) {
            errCode = 1060;
            String msg = "Cannot resolve Join output schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(join, msg, errCode, (byte)2, fe);
        }
    }

    private boolean isJoinOnMultiCols(LOJoin join) {
        MultiMap<Integer, LogicalExpressionPlan> exprPlans = join.getExpressionPlans();
        if (exprPlans == null || exprPlans.size() == 0) {
            throw new AssertionError((Object)"LOJoin.isJoinOnMultiCols() can only be called  after it has an join expression plans ");
        }
        return exprPlans.get(0).size() > 1;
    }

    private byte getAtomicJoinColType(LOJoin join) throws FrontendException {
        if (this.isJoinOnMultiCols(join)) {
            int errCode = 1010;
            String msg = "getAtomicJoinColType is used only when dealing with atomic group col";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        byte groupType = 50;
        for (int i = 0; i < this.plan.getPredecessors(join).size(); ++i) {
            ArrayList<LogicalExpressionPlan> innerPlans = new ArrayList<LogicalExpressionPlan>(join.getJoinPlan(i));
            if (innerPlans.size() != 1) {
                int errCode = 1012;
                String msg = "Each COGroup input has to have the same number of inner plans";
                throw new FrontendException(msg, errCode, 2, false, null);
            }
            byte innerType = ((LogicalExpression)((LogicalExpressionPlan)innerPlans.get(0)).getSources().get(0)).getType();
            if ((groupType = DataType.mergeType(groupType, innerType)) != -1) continue;
            int errCode = 1107;
            String msg = "Cannot merge join keys, incompatible types";
            throw new FrontendException(msg, errCode, 2);
        }
        return groupType;
    }

    private byte getAtomicColType(MultiMap<Integer, LogicalExpressionPlan> allExprPlans) throws FrontendException {
        if (this.isMultiExprPlanPerInput(allExprPlans)) {
            int errCode = 1010;
            String msg = "getAtomicJoinColType is used only when dealing with atomic group col";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        byte groupType = 50;
        for (int i = 0; i < allExprPlans.size(); ++i) {
            ArrayList<LogicalExpressionPlan> innerPlans = new ArrayList<LogicalExpressionPlan>(allExprPlans.get(i));
            if (innerPlans.size() != 1) {
                int errCode = 1012;
                String msg = "Each COGroup input has to have the same number of inner plans";
                throw new FrontendException(msg, errCode, 2, false, null);
            }
            byte innerType = ((LogicalExpression)((LogicalExpressionPlan)innerPlans.get(0)).getSources().get(0)).getType();
            if ((groupType = DataType.mergeType(groupType, innerType)) != -1) continue;
            int errCode = 1107;
            String msg = "Cannot merge join keys, incompatible types";
            throw new FrontendException(msg, errCode, 2);
        }
        return groupType;
    }

    private boolean isMultiExprPlanPerInput(MultiMap<Integer, LogicalExpressionPlan> exprPlans) {
        if (exprPlans == null || exprPlans.size() == 0) {
            throw new AssertionError((Object)"LOJoin.isJoinOnMultiCols() can only be called  after it has an join expression plans ");
        }
        return exprPlans.get(0).size() > 1;
    }

    private void insertAtomicCastForInnerPlan(LogicalExpressionPlan innerPlan, LogicalRelationalOperator relOp, byte toType) throws FrontendException {
        List<Operator> outputs;
        if (!DataType.isUsableType(toType)) {
            int errCode = 1051;
            String msg = "Cannot cast to " + DataType.findTypeName(toType);
            this.throwTypeCheckerException(relOp, msg, errCode, (byte)2, null);
        }
        if ((outputs = innerPlan.getSources()).size() > 1) {
            int errCode = 2060;
            String msg = "Expected one output. Found " + outputs.size() + "  outputs.";
            this.throwTypeCheckerException(relOp, msg, errCode, (byte)4, null);
        }
        LogicalExpression currentOutput = (LogicalExpression)outputs.get(0);
        TypeCheckingExpVisitor.collectCastWarning(relOp, currentOutput.getType(), toType, this.msgCollector);
        LogicalSchema.LogicalFieldSchema newFS = new LogicalSchema.LogicalFieldSchema(currentOutput.getFieldSchema().alias, null, toType);
        new CastExpression(innerPlan, currentOutput, newFS);
        this.visitExpressionPlan(innerPlan, relOp);
    }

    private LogicalSchema getSchemaFromInnerPlans(MultiMap<Integer, LogicalExpressionPlan> exprPlans, LogicalRelationalOperator op) throws FrontendException {
        int i;
        ArrayList<LogicalSchema.LogicalFieldSchema> fsList = new ArrayList<LogicalSchema.LogicalFieldSchema>();
        int outputSchemaSize = exprPlans.get(0).size();
        for (i = 0; i < outputSchemaSize; ++i) {
            fsList.add(new LogicalSchema.LogicalFieldSchema(null, null, 50));
        }
        for (i = 0; i < exprPlans.size(); ++i) {
            ArrayList<LogicalExpressionPlan> innerPlans = new ArrayList<LogicalExpressionPlan>(exprPlans.get(i));
            for (int j = 0; j < innerPlans.size(); ++j) {
                LogicalExpression eOp = (LogicalExpression)((LogicalExpressionPlan)innerPlans.get(j)).getSources().get(0);
                byte innerType = eOp.getType();
                if (eOp instanceof ProjectExpression && ((ProjectExpression)eOp).isProjectStar()) {
                    int errCode = 1013;
                    String msg = "Grouping attributes can either be star (*) or a list of expressions, but not both.";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new FrontendException(msg, errCode, 2, false, null);
                }
                LogicalSchema.LogicalFieldSchema groupFs = (LogicalSchema.LogicalFieldSchema)fsList.get(j);
                groupFs.type = DataType.mergeType(groupFs.type, innerType);
                if (groupFs.type != -1) continue;
                String colType = "join";
                if (op instanceof LOCogroup) {
                    colType = "group";
                }
                String msg = colType + " column no. " + (j + 1) + " in relation no. " + (i + 1) + " of  " + colType + " statement has datatype " + DataType.findTypeName(innerType) + " which is incompatible with type of corresponding column" + " in earlier relation(s) in the statement";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                TypeCheckerException ex = new TypeCheckerException((Operator)op, msg, 1130, 2);
                ex.setMarkedAsShowToUser(true);
                throw ex;
            }
        }
        LogicalSchema tupleSchema = new LogicalSchema();
        for (LogicalSchema.LogicalFieldSchema fs : fsList) {
            tupleSchema.addField(fs);
        }
        return tupleSchema;
    }

    @Override
    public void visit(LOCogroup cg) throws FrontendException {
        int errCode;
        try {
            cg.resetSchema();
            cg.getSchema();
        }
        catch (FrontendException fe) {
            int errCode2 = 1060;
            String msg = "Cannot resolve COGroup output schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(cg, msg, errCode2, (byte)2, fe);
        }
        MultiMap<Integer, LogicalExpressionPlan> groupByPlans = cg.getExpressionPlans();
        List<Operator> inputs = cg.getInputs((LogicalPlan)this.plan);
        for (int i = 0; i < inputs.size(); ++i) {
            ArrayList<LogicalExpressionPlan> innerPlans = new ArrayList<LogicalExpressionPlan>(cg.getExpressionPlans().get(i));
            for (int j = 0; j < innerPlans.size(); ++j) {
                LogicalExpressionPlan innerPlan = (LogicalExpressionPlan)innerPlans.get(j);
                if (innerPlan.getSources().size() != 1) {
                    int errCode3 = 1057;
                    String msg = "COGroup's inner plans can onlyhave one output (leaf)";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    this.throwTypeCheckerException(cg, msg, errCode3, (byte)2, null);
                }
                this.visitExpressionPlan(innerPlan, cg);
            }
        }
        try {
            int i;
            if (!this.isCoGroupOnMultiCols(cg)) {
                byte groupType = this.getAtomicColType(cg.getExpressionPlans());
                for (i = 0; i < inputs.size(); ++i) {
                    ArrayList<LogicalExpressionPlan> innerPlans = new ArrayList<LogicalExpressionPlan>(cg.getExpressionPlans().get(i));
                    byte innerType = ((LogicalExpression)((LogicalExpressionPlan)innerPlans.get(0)).getSources().get(0)).getType();
                    if (innerType == groupType) continue;
                    this.insertAtomicCastForInnerPlan((LogicalExpressionPlan)innerPlans.get(0), cg, groupType);
                }
            } else {
                LogicalSchema groupBySchema = this.getSchemaFromInnerPlans(cg.getExpressionPlans(), cg);
                for (i = 0; i < inputs.size(); ++i) {
                    ArrayList<LogicalExpressionPlan> innerPlans = new ArrayList<LogicalExpressionPlan>(groupByPlans.get(i));
                    for (int j = 0; j < innerPlans.size(); ++j) {
                        LogicalExpressionPlan innerPlan = (LogicalExpressionPlan)innerPlans.get(j);
                        byte innerType = ((LogicalExpression)innerPlan.getSources().get(0)).getType();
                        byte expectedType = 50;
                        if (!DataType.isAtomic(innerType) && 110 != innerType) {
                            int errCode4 = 1061;
                            String msg = "Sorry, group by complex types will be supported soon";
                            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                            this.throwTypeCheckerException(cg, msg, errCode4, (byte)2, null);
                        }
                        if (innerType == (expectedType = (byte)groupBySchema.getField((int)j).type)) continue;
                        this.insertAtomicCastForInnerPlan(innerPlan, cg, expectedType);
                    }
                }
            }
        }
        catch (FrontendException fe) {
            errCode = 1060;
            String msg = "Cannot resolve COGroup output schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(cg, msg, errCode, (byte)2, fe);
        }
        try {
            cg.resetSchema();
            cg.getSchema();
        }
        catch (FrontendException fe) {
            errCode = 1060;
            String msg = "Cannot resolve COGroup output schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            this.throwTypeCheckerException(cg, msg, errCode, (byte)2, fe);
        }
    }

    private boolean isCoGroupOnMultiCols(LOCogroup coGroup) {
        MultiMap<Integer, LogicalExpressionPlan> exprPlans = coGroup.getExpressionPlans();
        if (exprPlans == null || exprPlans.size() == 0) {
            throw new AssertionError((Object)"LOCoGroup.isJoinOnMultiCols() can only becalled  after it has an join expression plans ");
        }
        return exprPlans.get(0).size() > 1;
    }
}

