/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.runtime;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners.DiscreteProbabilitySampleGenerator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners.WeightedRangePartitioner;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigProcessor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.tez.runtime.library.common.ConfigUtils;

public class WeightedRangePartitionerTez
extends WeightedRangePartitioner {
    private static final Log LOG = LogFactory.getLog(WeightedRangePartitionerTez.class);
    private Integer estimatedNumPartitions;

    @Override
    public int getPartition(PigNullableWritable key, Writable value, int numPartitions) {
        if (this.estimatedNumPartitions != null) {
            numPartitions = this.estimatedNumPartitions;
        }
        return super.getPartition(key, value, numPartitions);
    }

    @Override
    public void init() {
        Map<String, Object> quantileMap = null;
        if (PigProcessor.sampleMap == null) {
            LOG.warn((Object)"Quantiles map is empty");
            this.inited = true;
            return;
        }
        quantileMap = PigProcessor.sampleMap;
        long start = System.currentTimeMillis();
        try {
            DataBag quantilesList = (DataBag)quantileMap.get("quantiles.list");
            InternalMap weightedPartsData = (InternalMap)quantileMap.get("weighted.parts");
            this.estimatedNumPartitions = (Integer)quantileMap.get("pig.exec.estimated.num.parallelism");
            this.convertToArray(quantilesList);
            for (Map.Entry ent : weightedPartsData.entrySet()) {
                Tuple key = (Tuple)ent.getKey();
                float[] probVec = this.getProbVec((Tuple)ent.getValue());
                this.weightedParts.put(this.getPigNullableWritable(key), new DiscreteProbabilitySampleGenerator(probVec));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.comparator = ConfigUtils.getIntermediateInputKeyComparator((Configuration)this.job);
        LOG.info((Object)("Initialized WeightedRangePartitionerTez. Time taken: " + (System.currentTimeMillis() - start)));
        this.inited = true;
    }
}

