/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import org.pentaho.hadoop.shim.common.HiveSQLUtils;

public class DriverProxyInvocationChain {
    public static final String PENTAHO_CURRENT_DBNAME = "pentaho.current.dbname";
    private static boolean initialized = false;
    private static final Date NULL_DATE = new Date(0L){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "NULL";
        }
    };
    protected static Class<? extends DatabaseMetaData> hive1DbMetaDataClass = null;
    protected static Class<? extends DatabaseMetaData> hive2DbMetaDataClass = null;
    protected static Class<? extends ResultSet> hive1ResultSetClass = null;
    protected static Class<? extends ResultSet> hive2ResultSetClass = null;
    protected static Class<?> hive1ClientClass = null;
    protected static Class<?> hive2ClientClass = null;
    protected static Class<? extends Statement> hive1StatementClass = null;
    protected static Class<? extends Statement> hive2StatementClass = null;
    protected static ClassLoader driverProxyClassLoader = null;

    public static Driver getProxy(Class<? extends Driver> intf, Driver obj) {
        driverProxyClassLoader = obj.getClass().getClassLoader();
        if (!initialized) {
            DriverProxyInvocationChain.init();
        }
        return (Driver)Proxy.newProxyInstance(driverProxyClassLoader, new Class[]{intf}, (InvocationHandler)new DriverInvocationHandler(obj));
    }

    protected static void init() {
        ClassLoader cl = driverProxyClassLoader;
        try {
            hive1DbMetaDataClass = Class.forName("org.apache.hadoop.hive.jdbc.HiveDatabaseMetaData", false, cl);
            hive1ResultSetClass = Class.forName("org.apache.hadoop.hive.jdbc.HiveQueryResultSet", false, cl);
            hive1ClientClass = Class.forName("org.apache.hadoop.hive.service.HiveInterface", false, cl);
            hive1StatementClass = Class.forName("org.apache.hadoop.hive.jdbc.HiveStatement", false, cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            hive2DbMetaDataClass = Class.forName("org.apache.hive.jdbc.HiveDatabaseMetaData", false, cl);
            hive2ResultSetClass = Class.forName("org.apache.hive.jdbc.HiveQueryResultSet", false, cl);
            hive2ClientClass = Class.forName("org.apache.hive.service.cli.thrift.TCLIService$Iface", false, cl);
            hive2StatementClass = Class.forName("org.apache.hive.jdbc.HiveStatement", false, cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        initialized = true;
    }

    protected static void useSchema(String dbName, Statement statement) throws SQLException {
        if (dbName.trim().length() > 0) {
            String queries = String.format("use %s", dbName);
            statement.execute(queries);
        }
    }

    protected static boolean isInitialized() {
        return initialized;
    }

    public static void setInitialized(boolean initialized) {
        DriverProxyInvocationChain.initialized = initialized;
    }

    private static class ResultSetMetaDataInvocationHandler
    implements InvocationHandler {
        ResultSetMetaData rsmd;

        public ResultSetMetaDataInvocationHandler(ResultSetMetaData r) {
            this.rsmd = r;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                String methodName = method.getName();
                if (("getColumnName".equals(methodName) || "getColumnLabel".equals(methodName)) && args != null && args.length == 1) {
                    return this.getColumnName((Integer)args[0]);
                }
                return method.invoke((Object)this.rsmd, args);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    Throwable cause = t.getCause();
                    if (cause instanceof SQLException) {
                        if (cause.getMessage().equals("Method not supported")) {
                            String methodName = method.getName();
                            if ("isSigned".equals(methodName) && args != null) {
                                return this.isSigned((Integer)args[0]);
                            }
                            throw cause;
                        }
                        throw cause;
                    }
                    throw cause;
                }
                throw t;
            }
        }

        private String getColumnName(Integer column) throws SQLException {
            int dotIndex;
            String columnName = null;
            columnName = this.rsmd.getColumnName(column);
            if (columnName != null && (dotIndex = columnName.indexOf(46)) != -1) {
                return columnName.substring(dotIndex + 1);
            }
            return columnName;
        }

        public boolean isSigned(int column) throws SQLException {
            int numCols = this.rsmd.getColumnCount();
            if (column < 1 || column > numCols) {
                throw new SQLException("Invalid column value: " + column);
            }
            int type = this.rsmd.getColumnType(column);
            switch (type) {
                case -6: 
                case -5: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
    }

    private static class ResultSetInvocationHandler
    implements InvocationHandler {
        ResultSet rs;
        Statement st;

        public ResultSetInvocationHandler(ResultSet r) {
            this.rs = r;
        }

        public ResultSetInvocationHandler(ResultSet r, Statement s) {
            this.rs = r;
            this.st = s;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                String methodName = method.getName();
                if ("getString".equals(methodName) && args != null && args.length == 1 && args[0] instanceof String) {
                    return this.getString((String)args[0]);
                }
                if ("getType".equals(methodName)) {
                    return 1003;
                }
                Object o = method.invoke((Object)this.rs, args);
                if (o instanceof ResultSetMetaData) {
                    return (ResultSetMetaData)Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new ResultSetMetaDataInvocationHandler((ResultSetMetaData)o));
                }
                return o;
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    Throwable cause = t.getCause();
                    String methodName = method.getName();
                    if (cause instanceof SQLException) {
                        if (cause.getMessage().equals("Method not supported")) {
                            if ("getStatement".equals(methodName)) {
                                return this.getStatement();
                            }
                            throw cause;
                        }
                        throw cause;
                    }
                    if (cause instanceof IllegalMonitorStateException && "close".equals(methodName)) {
                        return null;
                    }
                    throw cause;
                }
                throw t;
            }
        }

        private Statement getStatement() {
            return this.st;
        }

        public String getString(String columnName) throws SQLException {
            String columnVal = null;
            SQLException exception = null;
            try {
                columnVal = this.rs.getString(columnName);
            }
            catch (SQLException se) {
                exception = se;
            }
            if (columnVal != null) {
                return columnVal;
            }
            if (columnName != null && "TABLE_NAME".equals(columnName) && columnName != null && "TABLE_NAME".equals(columnName)) {
                try {
                    columnVal = this.rs.getString(1);
                }
                catch (SQLException se) {
                    throw exception == null ? se : exception;
                }
            }
            return columnVal;
        }
    }

    private static class CaptureResultSetInvocationHandler<T extends Statement>
    implements InvocationHandler {
        T t;

        public CaptureResultSetInvocationHandler(T t) {
            this.t = t;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            try {
                boolean isSetTimestamp = "setTimestamp".equals(methodName);
                if (PreparedStatement.class.isInstance(proxy) && (isSetTimestamp || "setDate".equals(methodName)) && args[1] != NULL_DATE) {
                    PreparedStatement ps = (PreparedStatement)proxy;
                    if (args[1] == null) {
                        ps.setNull((Integer)args[0], isSetTimestamp ? 93 : 91);
                    } else {
                        String value;
                        if (args.length == 3 && java.util.Date.class.isAssignableFrom(method.getParameterTypes()[1]) && Calendar.class.isAssignableFrom(method.getParameterTypes()[2])) {
                            Calendar calendar = args[2] == null ? Calendar.getInstance() : Calendar.getInstance(((Calendar)args[2]).getTimeZone());
                            calendar.setTime((java.util.Date)args[1]);
                            value = isSetTimestamp ? new Timestamp(calendar.getTimeInMillis()).toString() : new Date(calendar.getTimeInMillis()).toString();
                        } else {
                            value = args[1].toString();
                        }
                        ps.setString((Integer)args[0], value);
                    }
                    return null;
                }
                return this.getProxiedObject(method.invoke(this.t, args));
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof SQLException && cause.getMessage().equals("Method not supported")) {
                    if ("getMetaData".equals(methodName) && (args == null || args.length == 0)) {
                        return this.getProxiedObject(this.getMetaData());
                    }
                    if (PreparedStatement.class.isInstance(proxy)) {
                        PreparedStatement ps = (PreparedStatement)proxy;
                        if ("setObject".equals(methodName) && args.length == 2 && Integer.class.isInstance(args[0])) {
                            int parameterIndex = (Integer)args[0];
                            Object x = args[1];
                            if (x == null) {
                                ps.setNull(parameterIndex, 0);
                            } else if (x instanceof String) {
                                ps.setString(parameterIndex, (String)x);
                            } else if (x instanceof Short) {
                                ps.setShort(parameterIndex, (Short)x);
                            } else if (x instanceof Integer) {
                                ps.setInt(parameterIndex, (Integer)x);
                            } else if (x instanceof Long) {
                                ps.setLong(parameterIndex, (Long)x);
                            } else if (x instanceof Float) {
                                ps.setFloat(parameterIndex, ((Float)x).floatValue());
                            } else if (x instanceof Double) {
                                ps.setDouble(parameterIndex, (Double)x);
                            } else if (x instanceof Boolean) {
                                ps.setBoolean(parameterIndex, (Boolean)x);
                            } else if (x instanceof Byte) {
                                ps.setByte(parameterIndex, (Byte)x);
                            } else if (x instanceof Character) {
                                ps.setString(parameterIndex, x.toString());
                            } else {
                                throw new SQLException("Type " + x.getClass() + " is not yet supported", cause);
                            }
                            return null;
                        }
                        if ("setNull".equals(methodName) && args.length == 2 && Integer.class.isInstance(args[0])) {
                            int parameterIndex = (Integer)args[0];
                            ps.setDate(parameterIndex, NULL_DATE);
                            return null;
                        }
                    }
                }
                throw cause;
            }
        }

        public ResultSetMetaData getMetaData() {
            ResultSetMetaData rsmd = null;
            if (this.t instanceof Statement) {
                try {
                    ResultSet resultSet = this.t.getResultSet();
                    rsmd = resultSet == null ? null : resultSet.getMetaData();
                }
                catch (SQLException se) {
                    rsmd = null;
                }
            }
            return rsmd;
        }

        private Object getProxiedObject(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof ResultSet) {
                ResultSet r = (ResultSet)o;
                return (ResultSet)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(r, (Statement)this.t));
            }
            if (o instanceof ResultSetMetaData) {
                ResultSetMetaData r = (ResultSetMetaData)o;
                return (ResultSetMetaData)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new ResultSetMetaDataInvocationHandler(r));
            }
            return o;
        }
    }

    private static class DatabaseMetaDataInvocationHandler
    implements InvocationHandler {
        DatabaseMetaData t;
        ConnectionInvocationHandler c;

        public DatabaseMetaDataInvocationHandler(DatabaseMetaData t, ConnectionInvocationHandler c) {
            this.t = t;
            this.c = c;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object o;
                String methodName = method.getName();
                if ("getTables".equals(methodName)) {
                    if (hive1DbMetaDataClass != null && hive1DbMetaDataClass.isAssignableFrom(this.t.getClass())) {
                        return this.getTables(this.t, hive1DbMetaDataClass, hive1StatementClass, hive1ClientClass, (String)args[0], (String)args[1], (String)args[2], (String[])args[3], method, args);
                    }
                    if (hive2DbMetaDataClass != null && hive2DbMetaDataClass.isAssignableFrom(this.t.getClass())) {
                        return this.getTables(this.t, hive2DbMetaDataClass, hive2StatementClass, hive2ClientClass, (String)args[0], (String)args[1], (String)args[2], (String[])args[3], method, args);
                    }
                } else {
                    if ("getConnection".equals(methodName)) {
                        return this.c;
                    }
                    if ("getIdentifierQuoteString".equals(methodName)) {
                        return this.getIdentifierQuoteString();
                    }
                }
                if ((o = method.invoke((Object)this.t, args)) instanceof ResultSet) {
                    ResultSet r = (ResultSet)o;
                    return (ResultSet)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(r));
                }
                return o;
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    Throwable cause = t.getCause();
                    throw cause;
                }
                throw t;
            }
        }

        public String getIdentifierQuoteString() throws SQLException {
            return "";
        }

        public ResultSet getTables(Object originalObject, Class<? extends DatabaseMetaData> dbMetadataClass, Class<? extends Statement> statementClass, Class<?> clientClass, String catalog, String schemaPattern, String tableNamePattern, String[] types, Method method, Object[] args) throws Exception {
            boolean tables = false;
            if (types == null) {
                tables = true;
            } else {
                for (String type : types) {
                    if (!"TABLE".equals(type)) continue;
                    tables = true;
                }
            }
            if (tables) {
                try {
                    ResultSet r;
                    ResultSet ret;
                    Object o = method.invoke(originalObject, args);
                    if (o instanceof ResultSet && (ret = (ResultSet)Proxy.newProxyInstance((r = (ResultSet)o).getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(r))).isBeforeFirst()) {
                        return ret;
                    }
                }
                catch (Exception o) {
                    // empty catch block
                }
                Statement showTables = null;
                if (this.c != null) {
                    Statement st = this.c.createStatement(this.c.connection, null);
                    showTables = (Statement)Proxy.newProxyInstance(st.getClass().getClassLoader(), new Class[]{Statement.class}, new CaptureResultSetInvocationHandler<Statement>(st));
                } else {
                    Constructor<? extends Statement> hiveStatementCtor = statementClass.getDeclaredConstructor(clientClass);
                    try {
                        Field clientField = dbMetadataClass.getDeclaredField("client");
                        Object client = clientField.get(originalObject);
                        showTables = hiveStatementCtor.newInstance(clientClass.cast(client));
                    }
                    catch (Exception e) {
                        showTables = null;
                    }
                    if (showTables == null) {
                        try {
                            Method getClient = dbMetadataClass.getDeclaredMethod("getClient", new Class[0]);
                            Object client = getClient.invoke(originalObject, new Object[0]);
                            showTables = hiveStatementCtor.newInstance(clientClass.cast(client));
                        }
                        catch (Exception e) {
                            showTables = null;
                        }
                    }
                }
                if (showTables != null) {
                    ResultSet rs = schemaPattern != null ? showTables.executeQuery(String.format("show tables in %s", schemaPattern)) : showTables.executeQuery("show tables");
                    if (rs != null) {
                        return (ResultSet)Proxy.newProxyInstance(rs.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(rs));
                    }
                    return null;
                }
                throw new Exception("Cannot execute SHOW TABLES query");
            }
            Method getTables = dbMetadataClass.getDeclaredMethod("getTables", String.class, String.class, String.class, String[].class);
            ResultSet rs = (ResultSet)getTables.invoke(originalObject, catalog, schemaPattern, tableNamePattern, types);
            return rs;
        }
    }

    private static class ConnectionInvocationHandler
    implements InvocationHandler {
        Connection connection;

        public ConnectionInvocationHandler(Connection obj) {
            this.connection = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Statement st;
            Object o = null;
            try {
                if ("prepareStatement".equals(method.getName())) {
                    String sql = (String)args[0];
                    args[0] = HiveSQLUtils.processSQLString(sql);
                }
                o = method.invoke((Object)this.connection, args);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    Throwable cause = t.getCause();
                    if (cause instanceof SQLException) {
                        String methodName = method.getName();
                        if (cause.getMessage().startsWith("Method not supported") || cause.getMessage().equals("enabling autocommit is not supported")) {
                            if ("createStatement".equals(methodName)) {
                                o = this.createStatement(this.connection, args);
                            }
                            if ("isReadOnly".equals(methodName)) {
                                o = Boolean.FALSE;
                            }
                            if ("setReadOnly".equals(methodName)) {
                                o = null;
                            }
                            if ("setAutoCommit".equals(methodName)) {
                                o = null;
                            }
                            throw cause;
                        }
                        throw cause;
                    }
                    throw cause;
                }
                throw t;
            }
            if (o instanceof DatabaseMetaData) {
                DatabaseMetaData dbmd = (DatabaseMetaData)o;
                return (DatabaseMetaData)Proxy.newProxyInstance(dbmd.getClass().getClassLoader(), new Class[]{DatabaseMetaData.class}, (InvocationHandler)new DatabaseMetaDataInvocationHandler(dbmd, this));
            }
            if (o instanceof PreparedStatement) {
                st = (PreparedStatement)o;
                return (PreparedStatement)Proxy.newProxyInstance(st.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, new CaptureResultSetInvocationHandler<Statement>(st));
            }
            if (o instanceof Statement) {
                st = (Statement)o;
                return (Statement)Proxy.newProxyInstance(st.getClass().getClassLoader(), new Class[]{Statement.class}, new CaptureResultSetInvocationHandler<Statement>(st));
            }
            return o;
        }

        public Statement createStatement(Connection c, Object[] args) throws SQLException {
            if (c.isClosed()) {
                throw new SQLException("Can't create Statement, connection is closed ");
            }
            return c.createStatement();
        }
    }

    private static class DriverInvocationHandler
    implements InvocationHandler {
        Driver driver;

        public DriverInvocationHandler(Driver obj) {
            this.driver = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object o = method.invoke((Object)this.driver, args);
                if (o instanceof Connection) {
                    Connection proxiedConnection = (Connection)Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler((Connection)o));
                    String dbName = HiveSQLUtils.getDatabaseNameFromURL((String)args[0]);
                    DriverProxyInvocationChain.useSchema(dbName, proxiedConnection.createStatement());
                    return proxiedConnection;
                }
                return o;
            }
            catch (Throwable t) {
                throw t instanceof InvocationTargetException ? t.getCause() : t;
            }
        }
    }
}

