/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Unit;

public final class TransformedUnit<Q extends Quantity>
extends DerivedUnit<Q> {
    private final Unit<Q> _parentUnit;
    private final UnitConverter _toParentUnit;
    private static final long serialVersionUID = 1L;

    TransformedUnit(Unit<Q> parentUnit, UnitConverter toParentUnit) {
        if (toParentUnit == UnitConverter.IDENTITY) {
            throw new IllegalArgumentException("Identity not allowed");
        }
        this._parentUnit = parentUnit;
        this._toParentUnit = toParentUnit;
    }

    public Unit<Q> getParentUnit() {
        return this._parentUnit;
    }

    public UnitConverter toParentUnit() {
        return this._toParentUnit;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof TransformedUnit)) {
            return false;
        }
        TransformedUnit thatUnit = (TransformedUnit)that;
        return this._parentUnit.equals(thatUnit._parentUnit) && this._toParentUnit.equals(thatUnit._toParentUnit);
    }

    @Override
    public int hashCode() {
        return this._parentUnit.hashCode() + this._toParentUnit.hashCode();
    }

    @Override
    public Unit<? super Q> getStandardUnit() {
        return this._parentUnit.getStandardUnit();
    }

    @Override
    public UnitConverter toStandardUnit() {
        return this._parentUnit.toStandardUnit().concatenate(this._toParentUnit);
    }
}

