/*
 * Decompiled with CFR 0.152.
 */
package com.ccg.net.ethernet;

import com.ccg.net.ethernet.BadAddressException;
import java.util.Collection;
import java.util.Vector;

public final class EthernetAddress {
    public static final EthernetAddress NULL = new EthernetAddress();
    private byte[] _Bytes = new byte[6];

    private static native boolean getLocalEthernet(int var0, byte[] var1);

    private static EthernetAddress getLocalEthernetAddress(int n) {
        byte[] byArray = new byte[6];
        if (!EthernetAddress.getLocalEthernet(n, byArray)) {
            return null;
        }
        return EthernetAddress.fromBytes(byArray);
    }

    public boolean isNull() {
        for (int i = 0; i < this._Bytes.length; ++i) {
            if (this._Bytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static EthernetAddress getPrimaryAdapter() throws UnsatisfiedLinkError {
        return EthernetAddress.getLocalEthernetAddress(0);
    }

    public static Collection getAllAdapters() throws UnsatisfiedLinkError {
        Vector<EthernetAddress> vector = new Vector<EthernetAddress>();
        EthernetAddress ethernetAddress = null;
        int n = 0;
        while ((ethernetAddress = EthernetAddress.getLocalEthernetAddress(n)) != null) {
            vector.addElement(ethernetAddress);
            ++n;
        }
        return vector;
    }

    EthernetAddress() {
    }

    public static EthernetAddress fromBytes(byte[] byArray) throws BadAddressException {
        if (byArray == null || byArray.length != 6) {
            throw new BadAddressException("ethernet address not 6 bytes long");
        }
        EthernetAddress ethernetAddress = new EthernetAddress();
        for (int i = 0; i < byArray.length; ++i) {
            ethernetAddress._Bytes[i] = byArray[i];
        }
        return ethernetAddress;
    }

    public byte[] getBytes() {
        return (byte[])this._Bytes.clone();
    }

    public static EthernetAddress fromString(String string) throws BadAddressException {
        byte[] byArray = new byte[6];
        int n = 0;
        boolean bl = true;
        boolean bl2 = true;
        int n2 = -1;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            int n4 = Character.digit(c, 16);
            if (n4 == -1) {
                if (bl2) {
                    n = 0;
                    continue;
                }
                if (n2 == -1) continue;
                if (n >= byArray.length) {
                    throw new BadAddressException("too many bytes in \"" + string + "\"");
                }
                byArray[n++] = (byte)n2;
                n2 = -1;
                bl = true;
                continue;
            }
            bl2 = false;
            if (bl) {
                n2 = n4;
                bl = false;
                continue;
            }
            n2 <<= 4;
            n2 += n4;
            bl = true;
            if (n >= byArray.length) {
                throw new BadAddressException("too many bytes in \"" + string + "\"");
            }
            byArray[n++] = (byte)n2;
            n2 = -1;
        }
        if (n2 != -1 && !bl) {
            if (n >= byArray.length) {
                throw new BadAddressException("too many bytes in \"" + string + "\"");
            }
            byArray[n++] = (byte)n2;
        }
        if (n != byArray.length) {
            throw new BadAddressException("not enough bytes in \"" + string + "\"");
        }
        EthernetAddress ethernetAddress = new EthernetAddress();
        ethernetAddress._Bytes = byArray;
        return ethernetAddress;
    }

    public int hashCode() {
        int n = this._Bytes.length;
        if (n == 0) {
            return 0;
        }
        int n2 = this._Bytes[0];
        for (int i = 1; i < n; ++i) {
            n2 *= 37;
            n2 += this._Bytes[i];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EthernetAddress)) {
            return false;
        }
        byte[] byArray = ((EthernetAddress)object)._Bytes;
        if (byArray.length != this._Bytes.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == this._Bytes[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n = this._Bytes.length;
        StringBuffer stringBuffer = new StringBuffer(n * 3);
        for (int i = 0; i < n; ++i) {
            int n2 = this._Bytes[i];
            int n3 = n2 >> 4 & 0xF;
            n2 &= 0xF;
            if (i != 0) {
                stringBuffer.append(':');
            }
            stringBuffer.append(Character.forDigit(n3, 16));
            stringBuffer.append(Character.forDigit(n2, 16));
        }
        return stringBuffer.toString();
    }
}

