/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.IRootModelNode;
import org.pentaho.agilebi.modeler.nodes.MeasuresCollection;
import org.pentaho.agilebi.modeler.propforms.MainModelerNodePropertiesForm;
import org.pentaho.ui.xul.stereotype.Bindable;

public class MainModelNode
extends AbstractMetaDataModelNode<AbstractMetaDataModelNode>
implements IRootModelNode {
    private static final long serialVersionUID = 2399128598598210134L;
    String name = "Untitled";
    private MeasuresCollection measures = new MeasuresCollection();
    private DimensionMetaDataCollection dimensions = new DimensionMetaDataCollection();
    private transient PropertyChangeListener listener;
    private ModelerWorkspace workspace;
    private static final String CLASSNAME = "pentaho-smallmodelbutton";

    public MainModelNode() {
        super(CLASSNAME);
        this.add(this.measures);
        this.add(this.dimensions);
        this.setExpanded(true);
        this.dimensions.setExpanded(true);
    }

    public MainModelNode(ModelerWorkspace workspace) {
        this();
        this.workspace = workspace;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return ModelerMessagesHolder.getMessages().getString("Main.Model.Name.Template", this.getName());
    }

    @Bindable
    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            String prevDisplay = this.getDisplayName();
            this.name = name;
            this.firePropertyChange("name", oldName, this.name);
            this.firePropertyChange("displayName", prevDisplay, this.getName());
            this.validateNode();
        }
    }

    @Override
    @Bindable
    public String getImage() {
        return "images/sm_model_icon.png";
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Override
    protected void fireCollectionChanged() {
        this.changeSupport.firePropertyChange("children", null, this);
    }

    @Override
    public void onAdd(AbstractMetaDataModelNode child) {
        child.addPropertyChangeListener("children", this.getListener());
        child.addPropertyChangeListener("valid", this.validListener);
    }

    @Override
    public void onRemove(AbstractMetaDataModelNode child) {
        child.removePropertyChangeListener(this.getListener());
        child.removePropertyChangeListener(this.validListener);
    }

    public DimensionMetaDataCollection getDimensions() {
        return this.dimensions;
    }

    public MeasuresCollection getMeasures() {
        return this.measures;
    }

    @Bindable
    public boolean isEditingDisabled() {
        return true;
    }

    @Override
    public Class<MainModelerNodePropertiesForm> getPropertiesForm() {
        return MainModelerNodePropertiesForm.class;
    }

    @Override
    @Bindable
    public String getValidImage() {
        return this.getImage();
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validationMessages.clear();
        if ("".equals(this.getName())) {
            this.valid = false;
            this.validationMessages.add("Node is emtpy");
        }
        if (this.children.size() != 2) {
            this.valid = false;
            this.validationMessages.add("Invalid Structure");
        }
        for (AbstractMetaDataModelNode child : this.children) {
            this.valid &= child.isValid();
            this.validationMessages.addAll(child.getValidationMessages());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
        result = 31 * result + (this.measures == null ? 0 : this.measures.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(MainModelNode obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MainModelNode other = obj;
        if (this.dimensions == null ? other.dimensions != null : !this.dimensions.equals(other.dimensions)) {
            return false;
        }
        if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
            return false;
        }
        if (this.measures == null ? other.measures != null : !this.measures.equals(other.measures)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    private PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!MainModelNode.this.suppressEvents) {
                        MainModelNode.this.fireCollectionChanged();
                    }
                }
            };
        }
        return this.listener;
    }

    @Override
    public void setSupressEvents(boolean suppress) {
        super.setSupressEvents(suppress);
        if (!suppress) {
            this.firePropertyChange("valid", !this.isValid(), this.isValid());
        }
    }

    public boolean getSuppressEvents() {
        return this.suppressEvents;
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return false;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        throw new ModelerException(new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0])));
    }

    @Override
    public ModelerWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(ModelerWorkspace workspace) {
        this.workspace = workspace;
    }
}

