/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.validation;

import java.util.List;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.CheckStepsExtension;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.dataservice.validation.StepValidation;
import org.pentaho.di.trans.dataservice.validation.ValidationUtil;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;

public class MongoDbBasicValidation
implements StepValidation {
    private static Class<?> PKG = MongoDbBasicValidation.class;

    @Override
    public boolean supportsStep(StepMeta step, LogChannelInterface log) {
        return step.getStepMetaInterface() instanceof MongoDbInputMeta;
    }

    @Override
    public void checkStep(CheckStepsExtension checkStepExtension, DataServiceMeta dataServiceMeta, LogChannelInterface log) {
        StepMeta stepMeta = checkStepExtension.getStepMetas()[0];
        List remarks = checkStepExtension.getRemarks();
        MongoDbInputMeta mongoDbMeta = (MongoDbInputMeta)checkStepExtension.getStepMetas()[0].getStepMetaInterface();
        VariableSpace space = checkStepExtension.getVariableSpace();
        this.checkOutputJson(stepMeta, remarks, mongoDbMeta);
        this.checkPushdownParameter(stepMeta, remarks, mongoDbMeta, space);
        this.checkParameterGenerationOptimizedMeta(checkStepExtension, dataServiceMeta, log);
    }

    private void checkParameterGenerationOptimizedMeta(CheckStepsExtension checkStepExtension, DataServiceMeta dataServiceMeta, LogChannelInterface log) {
        StepMeta checkedStepMeta = checkStepExtension.getStepMetas()[0];
        for (ParameterGeneration paramGen : ValidationUtil.getParameterGenerationsForStep(dataServiceMeta, checkedStepMeta.getName())) {
            MongoDbInputMeta mongoDbMeta = (MongoDbInputMeta)checkStepExtension.getStepMetas()[0].getStepMetaInterface();
            if (!Const.isEmpty((String)mongoDbMeta.getJsonQuery()) && mongoDbMeta.getJsonQuery().contains(paramGen.getParameterName())) continue;
            checkStepExtension.getRemarks().add(ValidationUtil.warn(BaseMessages.getString(PKG, (String)"MongoDbBasicValidation.MissingDefinedParam.Message", (String[])new String[]{checkedStepMeta.getName(), paramGen.getParameterName()}), checkedStepMeta));
        }
    }

    private void checkPushdownParameter(StepMeta stepMeta, List<CheckResultInterface> remarks, MongoDbInputMeta mongoDbMeta, VariableSpace space) {
        String json = mongoDbMeta.getJsonQuery();
        if (Const.isEmpty((String)json) || !ValidationUtil.paramSubstitutionModifiesString(json, space)) {
            remarks.add((CheckResultInterface)ValidationUtil.warn(BaseMessages.getString(PKG, (String)"MongoDbBasicValidation.NoParameters.Message", (String[])new String[]{stepMeta.getName()}), stepMeta));
        }
    }

    private void checkOutputJson(StepMeta stepMeta, List<CheckResultInterface> remarks, MongoDbInputMeta mongoDbMeta) {
        if (mongoDbMeta.getOutputJson()) {
            remarks.add((CheckResultInterface)ValidationUtil.warn(BaseMessages.getString(PKG, (String)"MongoDbBasicValidation.JsonOutputType.Message", (String[])new String[]{stepMeta.getName()}), stepMeta));
        }
    }
}

