/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.optimization.PushDownType;
import org.pentaho.di.trans.dataservice.optimization.SourceTargetFields;
import org.pentaho.di.trans.dataservice.optimization.paramgen.AutoParameterGenerationService;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationService;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationServiceFactory;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ui.ParameterGenerationController;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ui.ParameterGenerationModel;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ui.ParameterGenerationOverlay;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ui.SourceTargetAdapter;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metaverse.api.ILineageClient;

public class ParameterGenerationFactory
implements PushDownFactory {
    private final List<ParameterGenerationServiceFactory> factories;
    private ILineageClient lineageClient;

    public ParameterGenerationFactory(List<ParameterGenerationServiceFactory> factories) {
        this.factories = factories;
    }

    public ILineageClient getLineageClient() {
        return this.lineageClient;
    }

    public void setLineageClient(ILineageClient lineageClient) {
        this.lineageClient = lineageClient;
    }

    @Override
    public String getName() {
        return "Parameter Generation";
    }

    @Override
    public Class<? extends PushDownType> getType() {
        return ParameterGeneration.class;
    }

    @Override
    public ParameterGeneration createPushDown() {
        return new ParameterGeneration(this);
    }

    @Override
    public ParameterGenerationOverlay createOverlay() {
        return new ParameterGenerationOverlay(this);
    }

    public ParameterGenerationController createController(DataServiceModel dialogModel) {
        ParameterGenerationModel model = new ParameterGenerationModel(this, dialogModel);
        return new ParameterGenerationController(this, model);
    }

    public SourceTargetAdapter createSourceTargetAdapter(SourceTargetFields sourceTargetFields) {
        return new SourceTargetAdapter(sourceTargetFields);
    }

    public AutoParameterGenerationService createAutoOptimizationService() {
        return new AutoParameterGenerationService((ILineageClient)Preconditions.checkNotNull((Object)this.lineageClient, (Object)"Lineage Client is unavailable"), this);
    }

    public ParameterGenerationService getService(StepMeta stepMeta) {
        Optional<ParameterGenerationServiceFactory> factory = this.getFactory(stepMeta);
        return factory.isPresent() ? ((ParameterGenerationServiceFactory)factory.get()).getService(stepMeta) : null;
    }

    public boolean supportsStep(StepMeta stepMeta) {
        return this.getFactory(stepMeta).isPresent();
    }

    private Optional<ParameterGenerationServiceFactory> getFactory(final StepMeta stepMeta) {
        return Iterables.tryFind(this.factories, (Predicate)new Predicate<ParameterGenerationServiceFactory>(){

            public boolean apply(ParameterGenerationServiceFactory input) {
                return input.supportsStep(stepMeta);
            }
        });
    }
}

