/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CommandFactory
extends Configured {
    private Map<String, Class<? extends Command>> classMap = new HashMap<String, Class<? extends Command>>();
    private Map<String, Command> objectMap = new HashMap<String, Command>();

    public CommandFactory() {
        this(null);
    }

    public CommandFactory(Configuration conf) {
        super(conf);
    }

    public void registerCommands(Class<?> registrarClass) {
        try {
            registrarClass.getMethod("registerCommands", CommandFactory.class).invoke(null, this);
        }
        catch (Exception e) {
            throw new RuntimeException(StringUtils.stringifyException(e));
        }
    }

    public void addClass(Class<? extends Command> cmdClass, String ... names) {
        for (String name : names) {
            this.classMap.put(name, cmdClass);
        }
    }

    public void addObject(Command cmdObject, String ... names) {
        for (String name : names) {
            this.objectMap.put(name, cmdObject);
            this.classMap.put(name, null);
        }
    }

    public Command getInstance(String cmd) {
        return this.getInstance(cmd, this.getConf());
    }

    public Command getInstance(String cmdName, Configuration conf) {
        Class<? extends Command> cmdClass;
        if (conf == null) {
            throw new NullPointerException("configuration is null");
        }
        Command instance = this.objectMap.get(cmdName);
        if (instance == null && (cmdClass = this.classMap.get(cmdName)) != null) {
            instance = ReflectionUtils.newInstance(cmdClass, conf);
            instance.setName(cmdName);
        }
        return instance;
    }

    public String[] getNames() {
        Object[] names = this.classMap.keySet().toArray(new String[0]);
        Arrays.sort(names);
        return names;
    }
}

