/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hive.jdbc.JdbcUriParseException;
import org.apache.hive.jdbc.ZooKeeperHiveClientException;
import org.apache.hive.jdbc.ZooKeeperHiveClientHelper;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.thrift.TStatus;
import org.apache.hive.service.cli.thrift.TStatusCode;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;

class Utils {
    static final Log LOG = LogFactory.getLog((String)Utils.class.getName());
    static final String URL_PREFIX = "jdbc:hive2://";
    static final String DEFAULT_PORT = "10000";
    static final String DEFAULT_DATABASE = "default";
    private static final String URI_JDBC_PREFIX = "jdbc:";
    private static final String URI_HIVE_PREFIX = "hive2:";
    static final String HIVE_SERVER2_RETRY_KEY = "hive.server2.retryserver";
    static final String HIVE_SERVER2_RETRY_TRUE = "true";
    static final String HIVE_SERVER2_RETRY_FALSE = "false";

    Utils() {
    }

    static void verifySuccessWithInfo(TStatus status) throws SQLException {
        Utils.verifySuccess(status, true);
    }

    static void verifySuccess(TStatus status) throws SQLException {
        Utils.verifySuccess(status, false);
    }

    static void verifySuccess(TStatus status, boolean withInfo) throws SQLException {
        if (status.getStatusCode() == TStatusCode.SUCCESS_STATUS || withInfo && status.getStatusCode() == TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            return;
        }
        throw new HiveSQLException(status);
    }

    static JdbcConnectionParams parseURL(String uri, Properties info) throws JdbcUriParseException, SQLException, ZooKeeperHiveClientException {
        String varStr;
        String confStr;
        JdbcConnectionParams connParams = new JdbcConnectionParams();
        if (!uri.startsWith(URL_PREFIX)) {
            throw new JdbcUriParseException("Bad URL format: Missing prefix jdbc:hive2://");
        }
        if (uri.equalsIgnoreCase(URL_PREFIX)) {
            connParams.setEmbeddedMode(true);
            return connParams;
        }
        String dummyAuthorityString = "dummyhost:00000";
        String suppliedAuthorities = Utils.getAuthorities(uri, connParams);
        if (suppliedAuthorities == null || suppliedAuthorities.isEmpty()) {
            connParams.setEmbeddedMode(true);
        } else {
            LOG.info((Object)("Supplied authorities: " + suppliedAuthorities));
            String[] authorityList = suppliedAuthorities.split(",");
            connParams.setSuppliedAuthorityList(authorityList);
            uri = uri.replace(suppliedAuthorities, dummyAuthorityString);
        }
        URI jdbcURI = URI.create(uri.substring(URI_JDBC_PREFIX.length()));
        Pattern pattern = Pattern.compile("([^;]*)=([^;]*)[;]?");
        String sessVars = jdbcURI.getPath();
        if (sessVars != null && !sessVars.isEmpty()) {
            String dbName = "";
            if (!(sessVars = sessVars.substring(1)).contains(";")) {
                dbName = sessVars;
            } else {
                dbName = sessVars.substring(0, sessVars.indexOf(59));
                if ((sessVars = sessVars.substring(sessVars.indexOf(59) + 1)) != null) {
                    Matcher sessMatcher = pattern.matcher(sessVars);
                    while (sessMatcher.find()) {
                        if (connParams.getSessionVars().put(sessMatcher.group(1), sessMatcher.group(2)) == null) continue;
                        throw new JdbcUriParseException("Bad URL format: Multiple values for property " + sessMatcher.group(1));
                    }
                }
            }
            if (!dbName.isEmpty()) {
                connParams.setDbName(dbName);
            }
        }
        if ((confStr = jdbcURI.getQuery()) != null) {
            Matcher confMatcher = pattern.matcher(confStr);
            while (confMatcher.find()) {
                connParams.getHiveConfs().put(confMatcher.group(1), confMatcher.group(2));
            }
        }
        if ((varStr = jdbcURI.getFragment()) != null) {
            Matcher varMatcher = pattern.matcher(varStr);
            while (varMatcher.find()) {
                connParams.getHiveVars().put(varMatcher.group(1), varMatcher.group(2));
            }
        }
        for (Map.Entry<Object, Object> kv : info.entrySet()) {
            if (!(kv.getKey() instanceof String)) continue;
            String key = (String)kv.getKey();
            if (key.startsWith("hivevar:")) {
                connParams.getHiveVars().put(key.substring("hivevar:".length()), info.getProperty(key));
                continue;
            }
            if (!key.startsWith("hiveconf:")) continue;
            connParams.getHiveConfs().put(key.substring("hiveconf:".length()), info.getProperty(key));
        }
        if (info.containsKey("user")) {
            connParams.getSessionVars().put("user", info.getProperty("user"));
            if (info.containsKey("password")) {
                connParams.getSessionVars().put("password", info.getProperty("password"));
            }
        }
        if (info.containsKey("auth")) {
            connParams.getSessionVars().put("auth", info.getProperty("auth"));
        }
        String usageUrlBase = "jdbc:hive2://<host>:<port>/dbName;";
        String newUsage = usageUrlBase + "saslQop" + "=<qop_value>";
        Utils.handleParamDeprecation(connParams.getSessionVars(), connParams.getSessionVars(), "sasl.qop", "saslQop", newUsage);
        newUsage = usageUrlBase + "transportMode" + "=<transport_mode_value>";
        Utils.handleParamDeprecation(connParams.getHiveConfs(), connParams.getSessionVars(), "hive.server2.transport.mode", "transportMode", newUsage);
        newUsage = usageUrlBase + "httpPath" + "=<http_path_value>";
        Utils.handleParamDeprecation(connParams.getHiveConfs(), connParams.getSessionVars(), "hive.server2.thrift.http.path", "httpPath", newUsage);
        if (connParams.isEmbeddedMode()) {
            connParams.setHost(jdbcURI.getHost());
            connParams.setPort(jdbcURI.getPort());
        } else {
            Utils.configureConnParams(connParams);
            String authorityStr = connParams.getHost() + ":" + connParams.getPort();
            LOG.info((Object)("Resolved authority: " + authorityStr));
            uri = uri.replace(dummyAuthorityString, authorityStr);
            connParams.setJdbcUriString(uri);
        }
        return connParams;
    }

    private static void handleParamDeprecation(Map<String, String> fromMap, Map<String, String> toMap, String deprecatedName, String newName, String newUsage) {
        if (fromMap.containsKey(deprecatedName)) {
            LOG.warn((Object)"***** JDBC param deprecation *****");
            LOG.warn((Object)("The use of " + deprecatedName + " is deprecated."));
            LOG.warn((Object)("Please use " + newName + " like so: " + newUsage));
            String paramValue = fromMap.remove(deprecatedName);
            toMap.put(newName, paramValue);
        }
    }

    private static String getAuthorities(String uri, JdbcConnectionParams connParams) throws JdbcUriParseException {
        String toIndexChar;
        int fromIndex = URL_PREFIX.length();
        int toIndex = -1;
        ArrayList<String> toIndexChars = new ArrayList<String>(Arrays.asList("/", "?", "#"));
        Iterator<String> i$ = toIndexChars.iterator();
        while (i$.hasNext() && (toIndex = uri.indexOf(toIndexChar = i$.next(), fromIndex)) <= 0) {
        }
        String authorities = toIndex < 0 ? uri.substring(fromIndex) : uri.substring(fromIndex, toIndex);
        return authorities;
    }

    private static void configureConnParams(JdbcConnectionParams connParams) throws JdbcUriParseException, ZooKeeperHiveClientException {
        String serviceDiscoveryMode = connParams.getSessionVars().get("serviceDiscoveryMode");
        if (serviceDiscoveryMode != null && "zooKeeper".equalsIgnoreCase(serviceDiscoveryMode)) {
            connParams.setZooKeeperEnsemble(Utils.joinStringArray(connParams.getAuthorityList(), ","));
            ZooKeeperHiveClientHelper.configureConnParams(connParams);
        } else {
            String authority = connParams.getAuthorityList()[0];
            URI jdbcURI = URI.create("hive2://" + authority);
            if (jdbcURI.getAuthority() != null) {
                String host = jdbcURI.getHost();
                int port = jdbcURI.getPort();
                if (host == null) {
                    throw new JdbcUriParseException("Bad URL format. Hostname not found  in authority part of the url: " + jdbcURI.getAuthority() + ". Are you missing a '/' after the hostname ?");
                }
                if (port <= 0) {
                    port = Integer.parseInt(DEFAULT_PORT);
                }
                connParams.setHost(jdbcURI.getHost());
                connParams.setPort(jdbcURI.getPort());
            }
        }
    }

    static void updateConnParamsFromZooKeeper(JdbcConnectionParams connParams) throws ZooKeeperHiveClientException {
        connParams.getRejectedHostZnodePaths().add(connParams.getCurrentHostZnodePath());
        String oldServerHost = connParams.getHost();
        int oldServerPort = connParams.getPort();
        ZooKeeperHiveClientHelper.configureConnParams(connParams);
        connParams.setJdbcUriString(connParams.getJdbcUriString().replace(oldServerHost + ":" + oldServerPort, connParams.getHost() + ":" + connParams.getPort()));
        LOG.info((Object)("Selected HiveServer2 instance with uri: " + connParams.getJdbcUriString()));
    }

    private static String joinStringArray(String[] stringArray, String seperator) {
        StringBuilder stringBuilder = new StringBuilder();
        int end = stringArray.length;
        for (int cur = 0; cur < end; ++cur) {
            if (cur > 0) {
                stringBuilder.append(seperator);
            }
            stringBuilder.append(stringArray[cur]);
        }
        return stringBuilder.toString();
    }

    static int getVersionPart(String fullVersion, int position) {
        int version = -1;
        try {
            String[] tokens = fullVersion.split("[\\.-]");
            if (tokens != null && tokens.length > 1 && tokens[position] != null) {
                version = Integer.parseInt(tokens[position]);
            }
        }
        catch (Exception e) {
            version = -1;
        }
        return version;
    }

    static boolean needToSendCredentials(CookieStore cookieStore, String cookieName, boolean isSSL) {
        if (cookieName == null || cookieStore == null) {
            return true;
        }
        List cookies = cookieStore.getCookies();
        for (Cookie c : cookies) {
            if (c.isSecure() && !isSSL || !c.getName().equals(cookieName)) continue;
            return false;
        }
        return true;
    }

    static class JdbcConnectionParams {
        static final String AUTH_TYPE = "auth";
        static final String AUTH_QOP_DEPRECATED = "sasl.qop";
        static final String AUTH_QOP = "saslQop";
        static final String AUTH_SIMPLE = "noSasl";
        static final String AUTH_TOKEN = "delegationToken";
        static final String AUTH_USER = "user";
        static final String AUTH_PRINCIPAL = "principal";
        static final String AUTH_PASSWD = "password";
        static final String AUTH_KERBEROS_AUTH_TYPE = "kerberosAuthType";
        static final String AUTH_KERBEROS_AUTH_TYPE_FROM_SUBJECT = "fromSubject";
        static final String ANONYMOUS_USER = "anonymous";
        static final String ANONYMOUS_PASSWD = "anonymous";
        static final String USE_SSL = "ssl";
        static final String SSL_TRUST_STORE = "sslTrustStore";
        static final String SSL_TRUST_STORE_PASSWORD = "trustStorePassword";
        static final String TRANSPORT_MODE_DEPRECATED = "hive.server2.transport.mode";
        static final String TRANSPORT_MODE = "transportMode";
        static final String HTTP_PATH_DEPRECATED = "hive.server2.thrift.http.path";
        static final String HTTP_PATH = "httpPath";
        static final String SERVICE_DISCOVERY_MODE = "serviceDiscoveryMode";
        static final String SERVICE_DISCOVERY_MODE_NONE = "none";
        static final String SERVICE_DISCOVERY_MODE_ZOOKEEPER = "zooKeeper";
        static final String ZOOKEEPER_NAMESPACE = "zooKeeperNamespace";
        static final String ZOOKEEPER_DEFAULT_NAMESPACE = "hiveserver2";
        static final String COOKIE_AUTH = "cookieAuth";
        static final String COOKIE_AUTH_FALSE = "false";
        static final String COOKIE_NAME = "cookieName";
        static final String DEFAULT_COOKIE_NAMES_HS2 = "hive.server2.auth";
        static final String HTTP_HEADER_PREFIX = "http.header.";
        static final String USE_TWO_WAY_SSL = "twoWay";
        static final String TRUE = "true";
        static final String SSL_KEY_STORE = "sslKeyStore";
        static final String SSL_KEY_STORE_PASSWORD = "keyStorePassword";
        static final String SSL_KEY_STORE_TYPE = "JKS";
        static final String SUNX509_ALGORITHM_STRING = "SunX509";
        static final String SUNJSSE_ALGORITHM_STRING = "SunJSSE";
        static final String SSL_TRUST_STORE_TYPE = "JKS";
        private static final String HIVE_VAR_PREFIX = "hivevar:";
        private static final String HIVE_CONF_PREFIX = "hiveconf:";
        private String host = null;
        private int port = 0;
        private String jdbcUriString;
        private String dbName = "default";
        private Map<String, String> hiveConfs = new LinkedHashMap<String, String>();
        private Map<String, String> hiveVars = new LinkedHashMap<String, String>();
        private Map<String, String> sessionVars = new LinkedHashMap<String, String>();
        private boolean isEmbeddedMode = false;
        private String[] authorityList;
        private String zooKeeperEnsemble = null;
        private String currentHostZnodePath;
        private List<String> rejectedHostZnodePaths = new ArrayList<String>();

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getJdbcUriString() {
            return this.jdbcUriString;
        }

        public String getDbName() {
            return this.dbName;
        }

        public Map<String, String> getHiveConfs() {
            return this.hiveConfs;
        }

        public Map<String, String> getHiveVars() {
            return this.hiveVars;
        }

        public boolean isEmbeddedMode() {
            return this.isEmbeddedMode;
        }

        public Map<String, String> getSessionVars() {
            return this.sessionVars;
        }

        public String[] getAuthorityList() {
            return this.authorityList;
        }

        public String getZooKeeperEnsemble() {
            return this.zooKeeperEnsemble;
        }

        public List<String> getRejectedHostZnodePaths() {
            return this.rejectedHostZnodePaths;
        }

        public String getCurrentHostZnodePath() {
            return this.currentHostZnodePath;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setJdbcUriString(String jdbcUriString) {
            this.jdbcUriString = jdbcUriString;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setHiveConfs(Map<String, String> hiveConfs) {
            this.hiveConfs = hiveConfs;
        }

        public void setHiveVars(Map<String, String> hiveVars) {
            this.hiveVars = hiveVars;
        }

        public void setEmbeddedMode(boolean embeddedMode) {
            this.isEmbeddedMode = embeddedMode;
        }

        public void setSessionVars(Map<String, String> sessionVars) {
            this.sessionVars = sessionVars;
        }

        public void setSuppliedAuthorityList(String[] authorityList) {
            this.authorityList = authorityList;
        }

        public void setZooKeeperEnsemble(String zooKeeperEnsemble) {
            this.zooKeeperEnsemble = zooKeeperEnsemble;
        }

        public void setCurrentHostZnodePath(String currentHostZnodePath) {
            this.currentHostZnodePath = currentHostZnodePath;
        }
    }
}

