/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.fonts.cache.FirstLevelFontCache;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class DefaultFontStorage
implements FontStorage {
    private static final Log logger = LogFactory.getLog(DefaultFontStorage.class);
    private FirstLevelFontCache knownMetrics;
    private FontRegistry registry;
    private FontMetricsFactory metricsFactory;
    private FontKey lookupKey;
    private int hits;
    private int misses;

    public DefaultFontStorage(FontRegistry registry) {
        this.knownMetrics = new FirstLevelFontCache(registry.getSecondLevelCache());
        this.registry = registry;
        this.metricsFactory = registry.createMetricsFactory();
        this.lookupKey = new FontKey();
    }

    @Override
    public FontRegistry getFontRegistry() {
        return this.registry;
    }

    @Override
    public FontMetrics getFontMetrics(FontIdentifier record, FontContext context) {
        if (record == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        this.lookupKey.setAliased(context.isAntiAliased());
        this.lookupKey.setFontSize(context.getFontSize());
        this.lookupKey.setIdentifier(record);
        this.lookupKey.setFractional(context.isFractionalMetrics());
        FontMetrics cachedMetrics = this.knownMetrics.getFontMetrics(this.lookupKey);
        if (cachedMetrics != null) {
            ++this.hits;
            return cachedMetrics;
        }
        ++this.misses;
        FontKey key = new FontKey(record, context.isAntiAliased(), context.isFractionalMetrics(), context.getFontSize());
        FontMetrics metrics = this.metricsFactory.createMetrics(record, context);
        this.knownMetrics.putFontMetrics(key, metrics);
        return metrics;
    }

    @Override
    public void commit() {
        logger.debug((Object)("Font-Storage: hits=" + this.hits + ", misses=" + this.misses));
        this.knownMetrics.commit();
    }
}

