/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionRemoveJPAExecutor
implements JPAExecutor<Void> {
    private String coordActionId = null;

    public CoordActionRemoveJPAExecutor(String coordActionId) {
        ParamChecker.notNull(coordActionId, "coordActionId");
        this.coordActionId = coordActionId;
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        int actionsDeleted;
        Query g = em.createNamedQuery("DELETE_UNSCHEDULED_ACTION");
        g.setParameter("id", (Object)this.coordActionId);
        try {
            actionsDeleted = g.executeUpdate();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        if (actionsDeleted == 0) {
            throw new JPAExecutorException(ErrorCode.E1022, this.coordActionId);
        }
        return null;
    }

    @Override
    public String getName() {
        return "CoordActionRemoveJPAExecutor";
    }
}

