/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogCopyService;
import org.apache.oozie.util.XLog;

public class XLogPurgeXCommand
extends XCommand<Void> {
    private List<String> wfList;
    private List<String> coordList;
    private List<String> bundleList;

    public XLogPurgeXCommand(List<String> wfList, List<String> coordList, List<String> bundleList) {
        super("XLogPurge", "XLogPurge", 0);
        this.wfList = wfList;
        this.coordList = coordList;
        this.bundleList = bundleList;
    }

    @Override
    protected Void execute() throws CommandException {
        XLogCopyService xls = Services.get().get(XLogCopyService.class);
        String hdfsDir = xls.getConfHdfsLogDir();
        XLog.Info.get().clear();
        XLog log = XLog.getLog(this.getClass());
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        URI uri = new Path(hdfsDir).toUri();
        JobConf fsConf = has.createJobConf(uri.getAuthority());
        FileSystem fs = null;
        try {
            fs = has.createFileSystem(System.getProperty("user.name"), uri, (Configuration)fsConf);
        }
        catch (Exception ex) {
            log.error((Object)"user has to be specified to access hdfs", new HadoopAccessorException(ErrorCode.E0902, "user has to be specified to access FileSystem"));
        }
        this.deleteJobLogs(fs, hdfsDir, this.wfList);
        this.deleteJobLogs(fs, hdfsDir, this.coordList);
        this.deleteJobLogs(fs, hdfsDir, this.bundleList);
        try {
            fs.close();
        }
        catch (IOException ex) {
            this.LOG.error("cannot close filesystem");
        }
        return null;
    }

    private void deleteJobLogs(FileSystem fs, String hdfsDir, List<String> jobIds) {
        Path[] paths = null;
        try {
            FileStatus[] fileStatuses = fs.listStatus(new Path(hdfsDir));
            paths = FileUtil.stat2Paths((FileStatus[])fileStatuses);
        }
        catch (IOException ex) {
            this.LOG.error("file not found " + ex.getMessage());
        }
        for (Path path : paths) {
            for (String jobId : jobIds) {
                Path p = new Path(path, jobId + ".log");
                try {
                    if (!fs.exists(p)) continue;
                    fs.delete(p, true);
                }
                catch (IOException ex) {
                    this.LOG.error((Object)"cannot delete job logs in hdfs", new HadoopAccessorException(ErrorCode.E0902, "cannot delete file " + p));
                }
            }
        }
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

