/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.util.IPasswordService;
import org.pentaho.platform.api.util.PasswordServiceException;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.lifecycle.AbstractBackingRepositoryLifecycleManager;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultUserRepositoryLifecycleManager
extends AbstractBackingRepositoryLifecycleManager {
    private static final Log logger = LogFactory.getLog(DefaultUserRepositoryLifecycleManager.class);
    private static final ITenant DEFAULT_TENANT = JcrTenantUtils.getDefaultTenant();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final IRoleAuthorizationPolicyRoleBindingDao roleBindingDao;
    private final IPasswordService passwordService;
    private final IUserRoleDao userRoleDao;
    private Map<String, List<String>> roleMappings;
    private Map<String, List<String>> userRoleMappings;
    private String singleTenantAdminPassword;
    private String nonAdminPassword;
    private String singleTenantAdminUserName;
    private List<String> systemRoles;
    public static final String DEFAULT_USERS_LOADED_METADATA = "defaultUsersLoaded";

    public DefaultUserRepositoryLifecycleManager(IRoleAuthorizationPolicyRoleBindingDao roleBindingDao, IPasswordService passwordService, IUserRoleDao userRoleDao, String singleTenantAdminUserName, List<String> systemRoles, TransactionTemplate txnTemplate, JcrTemplate adminJcrTemplate, IPathConversionHelper pathConversionHelper) {
        super(txnTemplate, adminJcrTemplate, pathConversionHelper);
        this.roleBindingDao = roleBindingDao;
        this.passwordService = passwordService;
        this.userRoleDao = userRoleDao;
        this.singleTenantAdminUserName = singleTenantAdminUserName;
        this.systemRoles = systemRoles;
    }

    public void newTenant() {
    }

    public void newTenant(ITenant arg0) {
    }

    public void newUser() {
    }

    public void newUser(ITenant arg0, String arg1) {
    }

    public void shutdown() {
    }

    public void startup() {
        if (!this.doesMetadataExists(DEFAULT_USERS_LOADED_METADATA).booleanValue()) {
            this.configureRoles();
            try {
                this.configureUsers();
            }
            catch (PasswordServiceException e) {
                logger.error((Object)"Failed configuring users.", (Throwable)e);
            }
            this.addMetadataToRepository(DEFAULT_USERS_LOADED_METADATA);
        }
    }

    private void configureRoles() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Configuring default role mappings.");
        }
        for (String roleName : this.roleMappings.keySet()) {
            IPentahoRole role = this.userRoleDao.getRole(DEFAULT_TENANT, roleName);
            if (role == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating user role: " + roleName));
                }
                this.userRoleDao.createRole(DEFAULT_TENANT, roleName, "", EMPTY_STRING_ARRAY);
                List<String> logicalRoles = this.roleMappings.get(roleName);
                if (logicalRoles.size() > 0) {
                    this.roleBindingDao.setRoleBindings(DEFAULT_TENANT, roleName, logicalRoles);
                }
                if (!logger.isDebugEnabled()) continue;
                StringBuffer buffer = new StringBuffer();
                for (String logicalRole : logicalRoles) {
                    buffer.append(logicalRole + " ");
                }
                logger.debug((Object)("Create Role[" + roleName + "] with logical roles [ " + buffer + " ]"));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Skipping config. Role[" + roleName + "] already registered."));
        }
    }

    private void configureUsers() throws PasswordServiceException {
        String singleTenantAdminPlainTextPassword = this.passwordService.decrypt(this.singleTenantAdminPassword);
        String nonAdminPasswordPlainTextPassword = this.passwordService.decrypt(this.nonAdminPassword);
        for (String userName : this.userRoleMappings.keySet()) {
            IPentahoUser user = this.userRoleDao.getUser(DEFAULT_TENANT, userName);
            if (user != null) continue;
            StringBuffer buffer = new StringBuffer();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating user: " + userName));
            }
            ArrayList<String> roleNames = new ArrayList<String>();
            for (String roleName : this.userRoleMappings.get(userName)) {
                if (this.roleMappings.containsKey(roleName) || this.systemRoles.contains(roleName)) {
                    roleNames.add(roleName);
                    buffer.append(roleName + "  ");
                    continue;
                }
                logger.error((Object)("Unable to map undefined role to user. User[" + userName + "] Role[" + roleName + "]"));
            }
            if (this.singleTenantAdminUserName.equals(userName)) {
                this.userRoleDao.createUser(DEFAULT_TENANT, userName, singleTenantAdminPlainTextPassword, "user", roleNames.toArray(EMPTY_STRING_ARRAY));
            } else {
                this.userRoleDao.createUser(DEFAULT_TENANT, userName, nonAdminPasswordPlainTextPassword, "user", roleNames.toArray(EMPTY_STRING_ARRAY));
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Created user: " + userName + "with role mappings [" + buffer + "]"));
        }
    }

    public Map<String, List<String>> getRoleMappings() {
        return this.roleMappings;
    }

    public void setRoleMappings(Map<String, List<String>> roleMappings) {
        this.roleMappings = roleMappings;
    }

    public Map<String, List<String>> getUserRoleMappings() {
        return this.userRoleMappings;
    }

    public void setUserRoleMappings(Map<String, List<String>> userRoleMappings) {
        this.userRoleMappings = userRoleMappings;
    }

    public String getNonAdminPassword() {
        return this.nonAdminPassword;
    }

    public void setNonAdminPassword(String nonAdminPassword) {
        this.nonAdminPassword = nonAdminPassword;
    }

    public String getSingleTenantAdminPassword() {
        return this.singleTenantAdminPassword;
    }

    public void setSingleTenantAdminPassword(String singleTenantAdminPassword) {
        this.singleTenantAdminPassword = singleTenantAdminPassword;
    }
}

