/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.sqlfileoutput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sqlfileoutput.SQLFileOutputMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SQLFileOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SQLFileOutputMeta.class;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlTruncate;
    private Button wTruncate;
    private FormData fdlTruncate;
    private FormData fdTruncate;
    private Label wlStartNewLine;
    private Button wStartNewLine;
    private FormData fdlStartNewLine;
    private FormData fdStartNewLine;
    private Label wlAddToResult;
    private Button wAddToResult;
    private FormData fdlAddToResult;
    private FormData fdAddToResult;
    private Label wlAddCreate;
    private Button wAddCreate;
    private FormData fdlAddCreate;
    private FormData fdAddCreate;
    private Group wGConnection;
    private Group wFileName;
    private FormData fdGConnection;
    private FormData fdFileName;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdFilename;
    private Label wlExtension;
    private TextVar wExtension;
    private FormData fdlExtension;
    private FormData fdExtension;
    private Label wlAddStepnr;
    private Button wAddStepnr;
    private FormData fdlAddStepnr;
    private FormData fdAddStepnr;
    private Label wlAddDate;
    private Button wAddDate;
    private FormData fdlAddDate;
    private FormData fdAddDate;
    private Label wlAddTime;
    private Button wAddTime;
    private FormData fdlAddTime;
    private FormData fdAddTime;
    private Button wbShowFiles;
    private FormData fdbShowFiles;
    private Label wlAppend;
    private Button wAppend;
    private FormData fdlAppend;
    private FormData fdAppend;
    private Label wlSplitEvery;
    private Text wSplitEvery;
    private FormData fdlSplitEvery;
    private FormData fdSplitEvery;
    private Label wlEncoding;
    private CCombo wEncoding;
    private FormData fdlEncoding;
    private FormData fdEncoding;
    private Label wlFormat;
    private CCombo wFormat;
    private FormData fdlFormat;
    private FormData fdFormat;
    private boolean gotEncodings = false;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wGeneralTab;
    private CTabItem wContentTab;
    private Composite wGeneralComp;
    private Composite wContentComp;
    private FormData fdGeneralComp;
    private FormData fdContentComp;
    private Label wlCreateParentFolder;
    private Button wCreateParentFolder;
    private FormData fdlCreateParentFolder;
    private FormData fdCreateParentFolder;
    private Label wlDoNotOpenNewFileInit;
    private Button wDoNotOpenNewFileInit;
    private FormData fdlDoNotOpenNewFileInit;
    private FormData fdDoNotOpenNewFileInit;
    private SQLFileOutputMeta input;

    public SQLFileOutputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (SQLFileOutputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.DialogTitle", (String[])new String[0]));
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.GeneralTab.TabTitle", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)generalLayout);
        this.wGConnection = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wGConnection);
        this.wGConnection.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Group.ConnectionInfos.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        this.wGConnection.setLayout((Layout)groupLayout);
        this.wConnection = this.addConnectionLine((Composite)this.wGConnection, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSchema = new Label((Composite)this.wGConnection, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.wGConnection, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TargetSchema.Tooltip", (String[])new String[0]));
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin);
        this.fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData(this.fdSchema);
        this.wlTable = new Label((Composite)this.wGConnection, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.wGConnection, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.wGConnection, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TargetTable.Tooltip", (String[])new String[0]));
        this.wTable.addModifyListener(lsMod);
        this.fdTable = new FormData();
        this.fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.fdGConnection = new FormData();
        this.fdGConnection.left = new FormAttachment(0, margin);
        this.fdGConnection.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdGConnection.right = new FormAttachment(100, -margin);
        this.wGConnection.setLayoutData((Object)this.fdGConnection);
        this.wFileName = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wFileName);
        this.wFileName.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Group.File.Label", (String[])new String[0]));
        FormLayout groupFileLayout = new FormLayout();
        groupFileLayout.marginWidth = 10;
        groupFileLayout.marginHeight = 10;
        this.wFileName.setLayout((Layout)groupFileLayout);
        this.wlAddCreate = new Label((Composite)this.wFileName, 131072);
        this.wlAddCreate.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.CreateTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddCreate);
        this.fdlAddCreate = new FormData();
        this.fdlAddCreate.left = new FormAttachment(0, 0);
        this.fdlAddCreate.top = new FormAttachment((Control)this.wGConnection, margin);
        this.fdlAddCreate.right = new FormAttachment(middle, -margin);
        this.wlAddCreate.setLayoutData((Object)this.fdlAddCreate);
        this.wAddCreate = new Button((Composite)this.wFileName, 32);
        this.wAddCreate.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.CreateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddCreate);
        this.fdAddCreate = new FormData();
        this.fdAddCreate.left = new FormAttachment(middle, 0);
        this.fdAddCreate.top = new FormAttachment((Control)this.wGConnection, margin);
        this.fdAddCreate.right = new FormAttachment(100, 0);
        this.wAddCreate.setLayoutData((Object)this.fdAddCreate);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SQLFileOutputDialog.this.ActiveTruncate();
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.wAddCreate.addSelectionListener((SelectionListener)lsSelMod);
        this.wlTruncate = new Label((Composite)this.wFileName, 131072);
        this.wlTruncate.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TruncateTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTruncate);
        this.fdlTruncate = new FormData();
        this.fdlTruncate.left = new FormAttachment(0, 0);
        this.fdlTruncate.top = new FormAttachment((Control)this.wAddCreate, margin);
        this.fdlTruncate.right = new FormAttachment(middle, -margin);
        this.wlTruncate.setLayoutData((Object)this.fdlTruncate);
        this.wTruncate = new Button((Composite)this.wFileName, 32);
        this.wTruncate.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TruncateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTruncate);
        this.fdTruncate = new FormData();
        this.fdTruncate.left = new FormAttachment(middle, 0);
        this.fdTruncate.top = new FormAttachment((Control)this.wAddCreate, margin);
        this.fdTruncate.right = new FormAttachment(100, 0);
        this.wTruncate.setLayoutData((Object)this.fdTruncate);
        SelectionAdapter lsSelTMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.wTruncate.addSelectionListener((SelectionListener)lsSelTMod);
        this.wlStartNewLine = new Label((Composite)this.wFileName, 131072);
        this.wlStartNewLine.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.StartNewLine.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStartNewLine);
        this.fdlStartNewLine = new FormData();
        this.fdlStartNewLine.left = new FormAttachment(0, 0);
        this.fdlStartNewLine.top = new FormAttachment((Control)this.wTruncate, margin);
        this.fdlStartNewLine.right = new FormAttachment(middle, -margin);
        this.wlStartNewLine.setLayoutData((Object)this.fdlStartNewLine);
        this.wStartNewLine = new Button((Composite)this.wFileName, 32);
        this.wStartNewLine.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.StartNewLine.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wStartNewLine);
        this.fdStartNewLine = new FormData();
        this.fdStartNewLine.left = new FormAttachment(middle, 0);
        this.fdStartNewLine.top = new FormAttachment((Control)this.wTruncate, margin);
        this.fdStartNewLine.right = new FormAttachment(100, 0);
        this.wStartNewLine.setLayoutData((Object)this.fdStartNewLine);
        SelectionAdapter lsSelSMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.wStartNewLine.addSelectionListener((SelectionListener)lsSelSMod);
        this.wlFilename = new Label((Composite)this.wFileName, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment((Control)this.wStartNewLine, margin);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbFilename = new Button((Composite)this.wFileName, 0x1000008);
        this.props.setLook((Control)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment((Control)this.wStartNewLine, 0);
        this.wbFilename.setLayoutData((Object)this.fdbFilename);
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.wFileName, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.top = new FormAttachment((Control)this.wStartNewLine, margin);
        this.fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wFilename.setLayoutData(this.fdFilename);
        this.wlCreateParentFolder = new Label((Composite)this.wFileName, 131072);
        this.wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateParentFolder);
        this.fdlCreateParentFolder = new FormData();
        this.fdlCreateParentFolder.left = new FormAttachment(0, 0);
        this.fdlCreateParentFolder.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        this.wlCreateParentFolder.setLayoutData((Object)this.fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)this.wFileName, 32);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateParentFolder);
        this.fdCreateParentFolder = new FormData();
        this.fdCreateParentFolder.left = new FormAttachment(middle, 0);
        this.fdCreateParentFolder.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdCreateParentFolder.right = new FormAttachment(100, 0);
        this.wCreateParentFolder.setLayoutData((Object)this.fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        this.wlDoNotOpenNewFileInit = new Label((Composite)this.wFileName, 131072);
        this.wlDoNotOpenNewFileInit.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.DoNotOpenNewFileInit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDoNotOpenNewFileInit);
        this.fdlDoNotOpenNewFileInit = new FormData();
        this.fdlDoNotOpenNewFileInit.left = new FormAttachment(0, 0);
        this.fdlDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        this.fdlDoNotOpenNewFileInit.right = new FormAttachment(middle, -margin);
        this.wlDoNotOpenNewFileInit.setLayoutData((Object)this.fdlDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit = new Button((Composite)this.wFileName, 32);
        this.wDoNotOpenNewFileInit.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.DoNotOpenNewFileInit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDoNotOpenNewFileInit);
        this.fdDoNotOpenNewFileInit = new FormData();
        this.fdDoNotOpenNewFileInit.left = new FormAttachment(middle, 0);
        this.fdDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        this.fdDoNotOpenNewFileInit.right = new FormAttachment(100, 0);
        this.wDoNotOpenNewFileInit.setLayoutData((Object)this.fdDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        this.wlExtension = new Label((Composite)this.wFileName, 131072);
        this.wlExtension.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        this.props.setLook((Control)this.wlExtension);
        this.fdlExtension = new FormData();
        this.fdlExtension.left = new FormAttachment(0, 0);
        this.fdlExtension.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        this.fdlExtension.right = new FormAttachment(middle, -margin);
        this.wlExtension.setLayoutData((Object)this.fdlExtension);
        this.wExtension = new TextVar((VariableSpace)this.transMeta, (Composite)this.wFileName, 18436);
        this.props.setLook((Control)this.wExtension);
        this.wExtension.addModifyListener(lsMod);
        this.fdExtension = new FormData();
        this.fdExtension.left = new FormAttachment(middle, 0);
        this.fdExtension.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        this.fdExtension.right = new FormAttachment(100, -margin);
        this.wExtension.setLayoutData(this.fdExtension);
        this.wlAddStepnr = new Label((Composite)this.wFileName, 131072);
        this.wlAddStepnr.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddStepnr.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddStepnr);
        this.fdlAddStepnr = new FormData();
        this.fdlAddStepnr.left = new FormAttachment(0, 0);
        this.fdlAddStepnr.top = new FormAttachment((Control)this.wExtension, 2 * margin);
        this.fdlAddStepnr.right = new FormAttachment(middle, -margin);
        this.wlAddStepnr.setLayoutData((Object)this.fdlAddStepnr);
        this.wAddStepnr = new Button((Composite)this.wFileName, 32);
        this.props.setLook((Control)this.wAddStepnr);
        this.fdAddStepnr = new FormData();
        this.fdAddStepnr.left = new FormAttachment(middle, 0);
        this.fdAddStepnr.top = new FormAttachment((Control)this.wExtension, 2 * margin);
        this.fdAddStepnr.right = new FormAttachment(100, 0);
        this.wAddStepnr.setLayoutData((Object)this.fdAddStepnr);
        this.wAddStepnr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddDate = new Label((Composite)this.wFileName, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddDate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddDate);
        this.fdlAddDate = new FormData();
        this.fdlAddDate.left = new FormAttachment(0, 0);
        this.fdlAddDate.top = new FormAttachment((Control)this.wAddStepnr, margin);
        this.fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)this.fdlAddDate);
        this.wAddDate = new Button((Composite)this.wFileName, 32);
        this.props.setLook((Control)this.wAddDate);
        this.fdAddDate = new FormData();
        this.fdAddDate.left = new FormAttachment(middle, 0);
        this.fdAddDate.top = new FormAttachment((Control)this.wAddStepnr, margin);
        this.fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)this.fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddTime = new Label((Composite)this.wFileName, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddTime.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddTime);
        this.fdlAddTime = new FormData();
        this.fdlAddTime.left = new FormAttachment(0, 0);
        this.fdlAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        this.fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)this.fdlAddTime);
        this.wAddTime = new Button((Composite)this.wFileName, 32);
        this.props.setLook((Control)this.wAddTime);
        this.fdAddTime = new FormData();
        this.fdAddTime.left = new FormAttachment(middle, 0);
        this.fdAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        this.fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)this.fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        this.wlAppend = new Label((Composite)this.wFileName, 131072);
        this.wlAppend.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Append.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAppend);
        this.fdlAppend = new FormData();
        this.fdlAppend.left = new FormAttachment(0, 0);
        this.fdlAppend.top = new FormAttachment((Control)this.wAddTime, margin);
        this.fdlAppend.right = new FormAttachment(middle, -margin);
        this.wlAppend.setLayoutData((Object)this.fdlAppend);
        this.wAppend = new Button((Composite)this.wFileName, 32);
        this.wAppend.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Append.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAppend);
        this.fdAppend = new FormData();
        this.fdAppend.left = new FormAttachment(middle, 0);
        this.fdAppend.top = new FormAttachment((Control)this.wAddTime, margin);
        this.fdAppend.right = new FormAttachment(100, 0);
        this.wAppend.setLayoutData((Object)this.fdAppend);
        this.wAppend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        this.wlSplitEvery = new Label((Composite)this.wFileName, 131072);
        this.wlSplitEvery.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.SplitEvery.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSplitEvery);
        this.fdlSplitEvery = new FormData();
        this.fdlSplitEvery.left = new FormAttachment(0, 0);
        this.fdlSplitEvery.top = new FormAttachment((Control)this.wAppend, margin);
        this.fdlSplitEvery.right = new FormAttachment(middle, -margin);
        this.wlSplitEvery.setLayoutData((Object)this.fdlSplitEvery);
        this.wSplitEvery = new Text((Composite)this.wFileName, 18436);
        this.props.setLook((Control)this.wSplitEvery);
        this.wSplitEvery.addModifyListener(lsMod);
        this.fdSplitEvery = new FormData();
        this.fdSplitEvery.left = new FormAttachment(middle, 0);
        this.fdSplitEvery.top = new FormAttachment((Control)this.wAppend, margin);
        this.fdSplitEvery.right = new FormAttachment(100, 0);
        this.wSplitEvery.setLayoutData((Object)this.fdSplitEvery);
        this.wbShowFiles = new Button((Composite)this.wFileName, 0x1000008);
        this.props.setLook((Control)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.ShowFiles.Button", (String[])new String[0]));
        this.fdbShowFiles = new FormData();
        this.fdbShowFiles.left = new FormAttachment(middle, 0);
        this.fdbShowFiles.top = new FormAttachment((Control)this.wSplitEvery, margin * 2);
        this.wbShowFiles.setLayoutData((Object)this.fdbShowFiles);
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputMeta tfoi = new SQLFileOutputMeta();
                SQLFileOutputDialog.this.getInfo(tfoi);
                String[] files = tfoi.getFiles(SQLFileOutputDialog.this.transMeta.environmentSubstitute(SQLFileOutputDialog.this.wFilename.getText()));
                if (files != null && files.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(SQLFileOutputDialog.this.shell, files, BaseMessages.getString((Class)PKG, (String)"SQLFileOutputDialog.SelectOutputFiles.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SQLFileOutputDialog.SelectOutputFiles.DialogMessage", (String[])new String[0]));
                    esd.setViewOnly();
                    esd.open();
                } else {
                    MessageBox mb = new MessageBox(SQLFileOutputDialog.this.shell, 33);
                    mb.setMessage(BaseMessages.getString((Class)PKG, (String)"SQLFileOutputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString((Class)PKG, (String)"System.DialogTitle.Error", (String[])new String[0]));
                    mb.open();
                }
            }
        });
        this.wlAddToResult = new Label((Composite)this.wFileName, 131072);
        this.wlAddToResult.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddToResult);
        this.fdlAddToResult = new FormData();
        this.fdlAddToResult.left = new FormAttachment(0, 0);
        this.fdlAddToResult.top = new FormAttachment((Control)this.wbShowFiles, margin);
        this.fdlAddToResult.right = new FormAttachment(middle, -margin);
        this.wlAddToResult.setLayoutData((Object)this.fdlAddToResult);
        this.wAddToResult = new Button((Composite)this.wFileName, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddFileToResult.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddToResult);
        this.fdAddToResult = new FormData();
        this.fdAddToResult.left = new FormAttachment(middle, 0);
        this.fdAddToResult.top = new FormAttachment((Control)this.wbShowFiles, margin);
        this.fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)this.fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        this.fdFileName = new FormData();
        this.fdFileName.left = new FormAttachment(0, margin);
        this.fdFileName.top = new FormAttachment((Control)this.wGConnection, 2 * margin);
        this.fdFileName.right = new FormAttachment(100, -margin);
        this.wFileName.setLayoutData((Object)this.fdFileName);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment(0, 0);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.props.setLook((Control)this.wGeneralComp);
        this.wContentTab = new CTabItem(this.wTabFolder, 0);
        this.wContentTab.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        this.wContentComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wContentComp);
        this.wContentComp.setLayout((Layout)contentLayout);
        String[] dats = Const.getDateFormats();
        this.wlFormat = new Label(this.wContentComp, 131072);
        this.wlFormat.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.DateFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFormat);
        this.fdlFormat = new FormData();
        this.fdlFormat.left = new FormAttachment(0, 0);
        this.fdlFormat.top = new FormAttachment(0, margin);
        this.fdlFormat.right = new FormAttachment(middle, -margin);
        this.wlFormat.setLayoutData((Object)this.fdlFormat);
        this.wFormat = new CCombo(this.wContentComp, 2056);
        this.wFormat.setEditable(true);
        this.props.setLook((Control)this.wFormat);
        this.wFormat.addModifyListener(lsMod);
        this.fdFormat = new FormData();
        this.fdFormat.left = new FormAttachment(middle, 0);
        this.fdFormat.top = new FormAttachment(0, margin);
        this.fdFormat.right = new FormAttachment(100, 0);
        this.wFormat.setLayoutData((Object)this.fdFormat);
        for (int x = 0; x < dats.length; ++x) {
            this.wFormat.add(dats[x]);
        }
        this.wlEncoding = new Label(this.wContentComp, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEncoding);
        this.fdlEncoding = new FormData();
        this.fdlEncoding.left = new FormAttachment(0, 0);
        this.fdlEncoding.top = new FormAttachment((Control)this.wFormat, margin);
        this.fdlEncoding.right = new FormAttachment(middle, -margin);
        this.wlEncoding.setLayoutData((Object)this.fdlEncoding);
        this.wEncoding = new CCombo(this.wContentComp, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        this.fdEncoding = new FormData();
        this.fdEncoding.left = new FormAttachment(middle, 0);
        this.fdEncoding.top = new FormAttachment((Control)this.wFormat, margin);
        this.fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)this.fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)SQLFileOutputDialog.this.shell.getDisplay(), 1);
                SQLFileOutputDialog.this.shell.setCursor(busy);
                SQLFileOutputDialog.this.setEncodings();
                SQLFileOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.fdContentComp = new FormData();
        this.fdContentComp.left = new FormAttachment(0, 0);
        this.fdContentComp.top = new FormAttachment(0, 0);
        this.fdContentComp.right = new FormAttachment(100, 0);
        this.fdContentComp.bottom = new FormAttachment(100, 0);
        this.wContentComp.setLayoutData((Object)this.wContentComp);
        this.wContentComp.layout();
        this.wContentTab.setControl((Control)this.wContentComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"System.Button.SQL", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCreate, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SQLFileOutputDialog.this.ok();
            }
        };
        this.lsCreate = new Listener(){

            public void handleEvent(Event e) {
                SQLFileOutputDialog.this.sql();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SQLFileOutputDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCreate.addListener(13, this.lsCreate);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.getTableName();
            }
        });
        this.wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SQLFileOutputDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*.txt", "*.TXT", "*"});
                if (SQLFileOutputDialog.this.wFilename.getText() != null) {
                    dialog.setFileName(SQLFileOutputDialog.this.transMeta.environmentSubstitute(SQLFileOutputDialog.this.wFilename.getText()));
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String extension = SQLFileOutputDialog.this.wExtension.getText();
                    if (extension != null && dialog.getFileName() != null && dialog.getFileName().endsWith("." + extension)) {
                        String fileName = dialog.getFileName();
                        SQLFileOutputDialog.this.wFilename.setText(dialog.getFilterPath() + System.getProperty("file.separator") + fileName.substring(0, fileName.length() - (extension.length() + 1)));
                    } else {
                        SQLFileOutputDialog.this.wFilename.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
                    }
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SQLFileOutputDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.ActiveTruncate();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void ActiveTruncate() {
        this.wlTruncate.setEnabled(!this.wAddCreate.getSelection());
        this.wTruncate.setEnabled(!this.wAddCreate.getSelection());
        if (this.wAddCreate.getSelection()) {
            this.wTruncate.setSelection(false);
        }
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    public void getData() {
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTablename() != null) {
            this.wTable.setText(this.input.getTablename());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        if (this.input.getFileName() != null) {
            this.wFilename.setText(this.input.getFileName());
        }
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        if (this.input.getExtension() != null) {
            this.wExtension.setText(this.input.getExtension());
        } else {
            this.wExtension.setText("sql");
        }
        if (this.input.getDateFormat() != null) {
            this.wFormat.setText(this.input.getDateFormat());
        }
        this.wSplitEvery.setText("" + this.input.getSplitEvery());
        this.wAddDate.setSelection(this.input.isDateInFilename());
        this.wAddTime.setSelection(this.input.isTimeInFilename());
        this.wAppend.setSelection(this.input.isFileAppended());
        this.wAddStepnr.setSelection(this.input.isStepNrInFilename());
        this.wTruncate.setSelection(this.input.truncateTable());
        this.wAddCreate.setSelection(this.input.createTable());
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        this.wAddToResult.setSelection(this.input.AddToResult());
        this.wStartNewLine.setSelection(this.input.StartNewLine());
        this.wDoNotOpenNewFileInit.setSelection(this.input.isDoNotOpenNewFileInit());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(SQLFileOutputMeta info) {
        info.setSchemaName(this.wSchema.getText());
        info.setTablename(this.wTable.getText());
        info.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        info.setTruncateTable(this.wTruncate.getSelection());
        info.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        info.setCreateTable(this.wAddCreate.getSelection());
        info.setFileName(this.wFilename.getText());
        info.setExtension(this.wExtension.getText());
        info.setDateFormat(this.wFormat.getText());
        info.setSplitEvery(Const.toInt((String)this.wSplitEvery.getText(), (int)0));
        info.setFileAppended(this.wAppend.getSelection());
        info.setStepNrInFilename(this.wAddStepnr.getSelection());
        info.setDateInFilename(this.wAddDate.getSelection());
        info.setTimeInFilename(this.wAddTime.getSelection());
        info.setEncoding(this.wEncoding.getText());
        info.setAddToResult(this.wAddToResult.getSelection());
        info.setStartNewLine(this.wStartNewLine.getSelection());
        info.setDoNotOpenNewFileInit(this.wDoNotOpenNewFileInit.getSelection());
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.ConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void getTableName() {
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            DatabaseMeta inf = this.transMeta.getDatabase(connr);
            this.logDebug(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Log.LookingAtConnection", (String[])new String[]{inf.toString()}));
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void sql() {
        try {
            SQLFileOutputMeta info = new SQLFileOutputMeta();
            this.getInfo(info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            StepMeta stepMeta = this.transMeta.findStep(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.NoSQL.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.NoSQL.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

