/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.Collections;
import java.util.List;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegates;

public class SharedObjectSyncUtil {
    private final ConnectionSynchronizationHandler connectionSynchronizationHandler = new ConnectionSynchronizationHandler();
    private final SlaveServerSynchronizationHandler slaveServerSynchronizationHandler = new SlaveServerSynchronizationHandler();
    private final ClusterSchemaSynchronizationHandler clusterSchemaSynchronizationHandler = new ClusterSchemaSynchronizationHandler();
    private final PartitionSchemaSynchronizationHandler partitionSchemaSynchronizationHandler = new PartitionSchemaSynchronizationHandler();
    private final StepMetaSynchronizationHandler stepMetaSynchronizationHandler = new StepMetaSynchronizationHandler();
    private final SpoonDelegates spoonDelegates;

    public SharedObjectSyncUtil(SpoonDelegates spoonDelegates) {
        this.spoonDelegates = spoonDelegates;
    }

    public synchronized void synchronizeConnections(DatabaseMeta database) {
        if (!database.isShared()) {
            return;
        }
        this.synchronizeJobs((SharedObjectInterface)database, this.connectionSynchronizationHandler);
        this.synchronizeTransformations((SharedObjectInterface)database, this.connectionSynchronizationHandler);
    }

    public synchronized void synchronizeSlaveServers(SlaveServer slaveServer) {
        if (!slaveServer.isShared()) {
            return;
        }
        this.synchronizeJobs((SharedObjectInterface)slaveServer, this.slaveServerSynchronizationHandler);
        this.synchronizeTransformations((SharedObjectInterface)slaveServer, this.slaveServerSynchronizationHandler);
    }

    public synchronized void synchronizeClusterSchemas(ClusterSchema clusterSchema) {
        if (!clusterSchema.isShared()) {
            return;
        }
        this.synchronizeTransformations((SharedObjectInterface)clusterSchema, this.clusterSchemaSynchronizationHandler);
    }

    public synchronized void synchronizePartitionSchemas(PartitionSchema partitionSchema) {
        if (!partitionSchema.isShared()) {
            return;
        }
        this.synchronizeTransformations((SharedObjectInterface)partitionSchema, this.partitionSchemaSynchronizationHandler);
    }

    public synchronized void synchronizeSteps(StepMeta step) {
        if (!step.isShared()) {
            return;
        }
        this.synchronizeTransformations((SharedObjectInterface)step, this.stepMetaSynchronizationHandler);
    }

    private void synchronizeJobs(SharedObjectInterface sourceObject, SynchronizationHandler handler) {
        for (JobMeta currentJob : this.spoonDelegates.jobs.getLoadedJobs()) {
            List<? extends SharedObjectInterface> objectsForSync = handler.getObjectsForSyncFromJob(currentJob);
            SharedObjectSyncUtil.synchronize(sourceObject, objectsForSync, handler);
        }
    }

    private void synchronizeTransformations(SharedObjectInterface object, SynchronizationHandler handler) {
        for (TransMeta currentTransformation : this.spoonDelegates.trans.getLoadedTransformations()) {
            List<? extends SharedObjectInterface> objectsForSync = handler.getObjectsForSyncFromTransformation(currentTransformation);
            SharedObjectSyncUtil.synchronize(object, objectsForSync, handler);
        }
    }

    private static void synchronize(SharedObjectInterface object, List<? extends SharedObjectInterface> objectsForSync, SynchronizationHandler handler) {
        for (SharedObjectInterface sharedObjectInterface : objectsForSync) {
            if (!sharedObjectInterface.isShared() || !sharedObjectInterface.getName().equals(object.getName()) || sharedObjectInterface == object) continue;
            handler.doSynchronization(object, sharedObjectInterface);
            break;
        }
    }

    private static class StepMetaSynchronizationHandler
    implements SynchronizationHandler {
        private StepMetaSynchronizationHandler() {
        }

        public List<StepMeta> getObjectsForSyncFromJob(JobMeta job) {
            return Collections.emptyList();
        }

        public List<StepMeta> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getSteps();
        }

        @Override
        public void doSynchronization(SharedObjectInterface source, SharedObjectInterface target) {
            ((StepMeta)target).replaceMeta((StepMeta)source);
        }
    }

    private static class PartitionSchemaSynchronizationHandler
    implements SynchronizationHandler {
        private PartitionSchemaSynchronizationHandler() {
        }

        public List<PartitionSchema> getObjectsForSyncFromJob(JobMeta job) {
            return Collections.emptyList();
        }

        public List<PartitionSchema> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getPartitionSchemas();
        }

        @Override
        public void doSynchronization(SharedObjectInterface source, SharedObjectInterface target) {
            ((PartitionSchema)target).replaceMeta((PartitionSchema)source);
        }
    }

    private static class ClusterSchemaSynchronizationHandler
    implements SynchronizationHandler {
        private ClusterSchemaSynchronizationHandler() {
        }

        public List<ClusterSchema> getObjectsForSyncFromJob(JobMeta job) {
            return Collections.emptyList();
        }

        public List<ClusterSchema> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getClusterSchemas();
        }

        @Override
        public void doSynchronization(SharedObjectInterface source, SharedObjectInterface target) {
            ((ClusterSchema)target).replaceMeta((ClusterSchema)source);
        }
    }

    private static class SlaveServerSynchronizationHandler
    implements SynchronizationHandler {
        private SlaveServerSynchronizationHandler() {
        }

        public List<SlaveServer> getObjectsForSyncFromJob(JobMeta job) {
            return job.getSlaveServers();
        }

        public List<SlaveServer> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getSlaveServers();
        }

        @Override
        public void doSynchronization(SharedObjectInterface source, SharedObjectInterface target) {
            ((SlaveServer)target).replaceMeta((SlaveServer)source);
        }
    }

    private static class ConnectionSynchronizationHandler
    implements SynchronizationHandler {
        private ConnectionSynchronizationHandler() {
        }

        public List<DatabaseMeta> getObjectsForSyncFromJob(JobMeta job) {
            return job.getDatabases();
        }

        public List<DatabaseMeta> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getDatabases();
        }

        @Override
        public void doSynchronization(SharedObjectInterface source, SharedObjectInterface target) {
            ((DatabaseMeta)target).replaceMeta((DatabaseMeta)source);
        }
    }

    public static interface SynchronizationHandler {
        public List<? extends SharedObjectInterface> getObjectsForSyncFromJob(JobMeta var1);

        public List<? extends SharedObjectInterface> getObjectsForSyncFromTransformation(TransMeta var1);

        public void doSynchronization(SharedObjectInterface var1, SharedObjectInterface var2);
    }
}

