/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.auth.controller;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.ui.core.auth.model.AuthProvider;
import org.pentaho.di.ui.core.auth.model.BasicAuthProvider;
import org.pentaho.di.ui.core.auth.model.KerberosAuthProvider;
import org.pentaho.di.ui.core.auth.model.NamedModelObject;
import org.pentaho.di.ui.core.auth.model.NamedProvider;
import org.pentaho.di.ui.core.auth.model.NoAuthAuthProvider;
import org.pentaho.di.ui.core.auth.model.ObjectListModel;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulFileDialog;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class AuthProviderController
extends AbstractXulEventHandler {
    protected BindingConvertor<NamedModelObject<NamedProvider>, String> selectedItemsNameBinding = new SelectedToStringConvertor();
    protected BindingConvertor<NamedModelObject<NamedProvider>, Object> selectedItemsItemBinding = new SelectedToItemConvertor();
    protected BindingConvertor<Collection<NamedModelObject<NamedProvider>>, Boolean> itemCountBinding = new RowCountToBooleanConvertor<NamedModelObject<NamedProvider>>();
    private XulDialog xulDialog;
    private BindingFactory bf;
    private ObjectListModel model = new ObjectListModel();
    AuthProvider activeProvider = null;
    private static LogChannelInterface log;
    ResourceBundle resourceBundle;

    public AuthProviderController() {
        log = new LogChannel((Object)"AuthProviderController");
        this.setName("handler");
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public BindingFactory getBindingFactory() {
        return this.bf;
    }

    public void init() {
        this.xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getRootElement();
        if (this.bf != null) {
            this.bind();
        }
    }

    public void setResourceBundle(ResourceBundle res) {
        this.resourceBundle = res;
    }

    public void open() {
        if (this.xulDialog != null) {
            this.xulDialog.show();
        }
    }

    public Collection<AuthProvider> getPossibleTypes() {
        ArrayList<AuthProvider> types = new ArrayList<AuthProvider>();
        types.add(new NoAuthAuthProvider(this.bf));
        types.add(new KerberosAuthProvider(this.bf));
        types.add(new BasicAuthProvider(this.bf));
        return types;
    }

    public void setNewOverlay(AuthProvider provider) throws XulException {
        AuthProvider current;
        if (provider == null) {
            provider = new NoAuthAuthProvider(this.bf);
        }
        if (this.activeProvider != null) {
            this.getXulDomContainer().removeOverlay(this.activeProvider.getOverlay());
        }
        this.getXulDomContainer().loadOverlay(provider.getOverlay());
        if (this.model.getSelectedItem() != null && (current = (AuthProvider)this.model.getSelectedItem().getItem()).getOverlay().equalsIgnoreCase(provider.getOverlay())) {
            try {
                current.bind();
            }
            catch (Exception e) {
                log.logError(this.resourceBundle.getString("error.on_bind"), (Throwable)e);
            }
        }
        this.activeProvider = provider;
    }

    public String getNewOverlay() {
        return "";
    }

    private void bind() {
        try {
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this, "possibleTypes", "method_list", "elements", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding(this.model.getModelObjects(), "children", "remove_button", "disabled", new BindingConvertor[]{this.itemCountBinding}).fireSourceChanged();
            this.bf.createBinding(this.model.getModelObjects(), "children", "name", "disabled", new BindingConvertor[]{this.itemCountBinding}).fireSourceChanged();
            this.bf.createBinding(this.model.getModelObjects(), "children", "method_list", "disabled", new BindingConvertor[]{this.itemCountBinding}).fireSourceChanged();
            this.bf.createBinding("auth_list", "selectedItem", "name", "!disabled", new BindingConvertor[]{BindingConvertor.object2Boolean()}).fireSourceChanged();
            this.bf.createBinding("auth_list", "selectedItem", "method_list", "!disabled", new BindingConvertor[]{BindingConvertor.object2Boolean()}).fireSourceChanged();
            this.bf.createBinding("auth_list", "selectedItem", "remove_button", "!disabled", new BindingConvertor[]{BindingConvertor.object2Boolean()}).fireSourceChanged();
            this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
            this.bf.createBinding("auth_list", "selectedItem", (Object)this.model, "selectedItem", new BindingConvertor[0]);
            Binding listBinding = this.bf.createBinding(this.model.getModelObjects(), "children", "auth_list", "elements", new BindingConvertor[0]);
            listBinding.fireSourceChanged();
            this.bf.createBinding((Object)this.model, "selectedItem", "name", "value", new BindingConvertor[]{this.selectedItemsNameBinding}).fireSourceChanged();
            this.bf.createBinding((Object)this, "newOverlay", "method_list", "selectedItem", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "selectedItem", "method_list", "selectedItem", new BindingConvertor[]{this.selectedItemsItemBinding}).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "selectedItem", (Object)this, "newOverlay", new BindingConvertor[]{this.selectedItemsItemBinding});
        }
        catch (XulException e) {
            log.logError(this.resourceBundle.getString("error.on_bind"), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.logError(this.resourceBundle.getString("error.on_execution"), (Throwable)e);
        }
    }

    public void onAccept() {
        this.xulDialog.hide();
    }

    public void onCancel() {
        this.xulDialog.hide();
    }

    public void addNew() {
        NamedProvider provider = new NamedProvider(this.generateUniqueName(), new NoAuthAuthProvider(this.bf));
        this.model.add(provider);
        this.model.setSelectedItem(provider);
    }

    private String generateUniqueName() {
        String name = this.resourceBundle.getString("uniquename.provider");
        int index = 0;
        boolean good = false;
        String potentialName = null;
        while (!good) {
            potentialName = name.concat(Integer.toString(++index));
            boolean found = false;
            for (NamedModelObject o : this.model.getModelObjects()) {
                if (!o.getName().equalsIgnoreCase(potentialName)) continue;
                found = true;
                break;
            }
            good = !found;
        }
        return potentialName;
    }

    public void remove() {
        int index = this.model.getModelObjects().indexOf((Object)this.model.getSelectedItem());
        if (index >= 1) {
            --index;
        }
        this.model.getModelObjects().remove((Object)this.model.getSelectedItem());
        if (!this.model.getModelObjects().isEmpty()) {
            this.model.setSelectedItem((NamedModelObject)this.model.getModelObjects().get(index));
        } else {
            this.model.setSelectedItem(null);
        }
    }

    public void browse() {
        try {
            XulTextbox filename = (XulTextbox)this.document.getElementById("keytab");
            XulFileDialog dialog = (XulFileDialog)this.document.createElement("filedialog");
            XulFileDialog.RETURN_CODE retval = dialog.showOpenDialog();
            if (retval == XulFileDialog.RETURN_CODE.OK) {
                File file = (File)dialog.getFile();
                filename.setValue(file.getAbsolutePath());
            }
        }
        catch (XulException e) {
            log.logError(this.resourceBundle.getString("error.file_browse"), (Throwable)e);
        }
    }

    public void addProviders(List<NamedProvider> providers) {
        if (providers == null || providers.isEmpty()) {
            return;
        }
        for (NamedProvider provider : providers) {
            this.model.add(provider);
        }
        this.model.setSelectedItem((NamedModelObject)this.model.getModelObjects().get(0));
    }

    ObjectListModel getModel() {
        return this.model;
    }

    private class RowCountToBooleanConvertor<T>
    extends BindingConvertor<Collection<T>, Boolean> {
        private RowCountToBooleanConvertor() {
        }

        public Boolean sourceToTarget(Collection<T> value) {
            return value == null || value.isEmpty();
        }

        public Collection<T> targetToSource(Boolean value) {
            return null;
        }
    }

    private class SelectedToStringConvertor
    extends BindingConvertor<NamedModelObject<NamedProvider>, String> {
        private SelectedToStringConvertor() {
        }

        public String sourceToTarget(NamedModelObject<NamedProvider> value) {
            if (value == null) {
                return "";
            }
            return value.getName();
        }

        public NamedModelObject<NamedProvider> targetToSource(String value) {
            if (AuthProviderController.this.model.getSelectedItem() != null) {
                AuthProviderController.this.model.setName(value);
            }
            return AuthProviderController.this.model.getSelectedItem();
        }
    }

    private class SelectedToItemConvertor
    extends BindingConvertor<NamedModelObject<NamedProvider>, Object> {
        private SelectedToItemConvertor() {
        }

        public Object sourceToTarget(NamedModelObject<NamedProvider> value) {
            if (value == null) {
                return null;
            }
            return value.getItem();
        }

        public NamedModelObject<NamedProvider> targetToSource(Object value) {
            if (AuthProviderController.this.model.getSelectedItem() != null) {
                AuthProvider provider = (AuthProvider)value;
                AuthProvider selectedProvider = (AuthProvider)AuthProviderController.this.model.getSelectedItem().getItem();
                AuthProvider providerToUse = null;
                if (selectedProvider.getOverlay().equals(provider.getOverlay())) {
                    providerToUse = selectedProvider;
                } else {
                    try {
                        providerToUse = provider.clone();
                        providerToUse.bind();
                    }
                    catch (Exception e) {
                        log.logError(AuthProviderController.this.resourceBundle.getString("error.new_provider"), (Throwable)e);
                    }
                }
                AuthProviderController.this.model.setItem(AuthProviderController.this.model.getSelectedItem(), providerToUse);
            }
            return AuthProviderController.this.model.getSelectedItem();
        }
    }
}

