/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.NullOutputStream;

public class SerializedObjectContainer
implements Serializable {
    private static final Log logger = LogFactory.getLog(SerializedObjectContainer.class);
    private transient Object[] data;

    public SerializedObjectContainer(Object[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = (Object[])data.clone();
        try {
            DebuggingObjectOutputStream objectOutputStream = new DebuggingObjectOutputStream((OutputStream)new NullOutputStream());
            try {
                objectOutputStream.writeObject(this);
            }
            catch (NotSerializableException nse) {
                logger.debug((Object)("Non-Serializable object found @Path: " + objectOutputStream.getStack()));
                throw nse;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Object is not serializable.");
        }
    }

    public Object[] getData() {
        return (Object[])this.data.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int count = this.data.length;
        stream.writeObject(this.data.getClass().getComponentType());
        stream.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Object object = this.data[i];
            if (object != null && object instanceof Serializable) {
                stream.writeInt(i);
                stream.writeObject(object);
                continue;
            }
            stream.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Class arrayType = (Class)stream.readObject();
        int count = stream.readInt();
        this.data = (Object[])Array.newInstance(arrayType, count);
        for (int i = 0; i < count; ++i) {
            int index = stream.readInt();
            if (index == -1) continue;
            this.data[i] = stream.readObject();
        }
    }

    public static class DebuggingObjectOutputStream
    extends ObjectOutputStream {
        private static final Field DEPTH_FIELD;
        private final List<Object> stack = new ArrayList<Object>();
        private boolean broken = false;

        public DebuggingObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object o) {
            int currentDepth = this.currentDepth();
            if (o instanceof IOException && currentDepth == 0) {
                this.broken = true;
            }
            if (!this.broken) {
                this.truncate(currentDepth);
                this.stack.add(o);
            }
            return o;
        }

        private void truncate(int depth) {
            while (this.stack.size() > depth) {
                this.pop();
            }
        }

        private Object pop() {
            return this.stack.remove(this.stack.size() - 1);
        }

        private int currentDepth() {
            try {
                Integer oneBased = (Integer)DEPTH_FIELD.get(this);
                return oneBased - 1;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        public List<Object> getStack() {
            return this.stack;
        }

        static {
            try {
                DEPTH_FIELD = ObjectOutputStream.class.getDeclaredField("depth");
                DEPTH_FIELD.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

