/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.pdi.vfs;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.operations.FileOperations;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.pentaho.platform.pdi.vfs.MetadataToMondrianVfsFileContent;

public class MetadataToMondrianVfsFileObject
implements FileObject {
    private String fileRef;
    private FileContent content = null;
    private FileName name;
    private FileType type;

    public int compareTo(FileObject o) {
        throw new UnsupportedOperationException();
    }

    public Iterator<FileObject> iterator() {
        throw new UnsupportedOperationException();
    }

    public MetadataToMondrianVfsFileObject(String fileRef) {
        this.fileRef = fileRef;
        this.type = FileType.FILE;
        this.name = new MetadataToMondrianVfsFileName(fileRef, this.type);
    }

    public MetadataToMondrianVfsFileObject(String fileRef, FileType type) {
        this.fileRef = fileRef;
        this.type = type;
        this.name = new MetadataToMondrianVfsFileName(fileRef, type);
    }

    public String getFileRef() {
        return this.fileRef;
    }

    public FileName getName() {
        return this.name;
    }

    public URL getURL() throws FileSystemException {
        URL url = null;
        try {
            url = new URL("mtm:/" + this.fileRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public boolean exists() throws FileSystemException {
        return this.fileRef.startsWith("http") || new File(this.fileRef).exists();
    }

    public boolean isHidden() throws FileSystemException {
        return false;
    }

    public boolean isReadable() throws FileSystemException {
        return this.exists();
    }

    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    public FileType getType() throws FileSystemException {
        return this.type;
    }

    public FileObject getParent() throws FileSystemException {
        return null;
    }

    public String getPublicURIString() {
        throw new UnsupportedOperationException();
    }

    public FileSystem getFileSystem() {
        return null;
    }

    public FileObject[] getChildren() throws FileSystemException {
        return null;
    }

    public FileObject getChild(String arg0) throws FileSystemException {
        return null;
    }

    public FileObject resolveFile(String arg0, NameScope arg1) throws FileSystemException {
        return null;
    }

    public boolean setExecutable(boolean b, boolean b1) throws FileSystemException {
        throw new UnsupportedOperationException();
    }

    public boolean setReadable(boolean b, boolean b1) throws FileSystemException {
        throw new UnsupportedOperationException();
    }

    public boolean setWritable(boolean b, boolean b1) throws FileSystemException {
        throw new UnsupportedOperationException();
    }

    public FileObject resolveFile(String arg0) throws FileSystemException {
        return null;
    }

    public FileObject[] findFiles(FileSelector arg0) throws FileSystemException {
        return null;
    }

    public void findFiles(FileSelector arg0, boolean arg1, List arg2) throws FileSystemException {
    }

    public boolean delete() throws FileSystemException {
        return false;
    }

    public int delete(FileSelector arg0) throws FileSystemException {
        return 0;
    }

    public int deleteAll() throws FileSystemException {
        throw new UnsupportedOperationException();
    }

    public void createFolder() throws FileSystemException {
    }

    public void createFile() throws FileSystemException {
    }

    public void copyFrom(FileObject arg0, FileSelector arg1) throws FileSystemException {
    }

    public void moveTo(FileObject arg0) throws FileSystemException {
    }

    public boolean canRenameTo(FileObject arg0) {
        return false;
    }

    public FileContent getContent() throws FileSystemException {
        this.content = new MetadataToMondrianVfsFileContent(this);
        return this.content;
    }

    public void close() throws FileSystemException {
        if (this.content != null) {
            this.content.close();
            this.content = null;
        }
    }

    public void refresh() throws FileSystemException {
    }

    public boolean isAttached() {
        return false;
    }

    public boolean isContentOpen() {
        return this.content != null && this.content.isOpen();
    }

    public boolean isExecutable() throws FileSystemException {
        throw new UnsupportedOperationException();
    }

    public boolean isFile() throws FileSystemException {
        throw new UnsupportedOperationException();
    }

    public boolean isFolder() throws FileSystemException {
        throw new UnsupportedOperationException();
    }

    public FileOperations getFileOperations() throws FileSystemException {
        return null;
    }

    public class MetadataToMondrianVfsFileName
    extends AbstractFileName {
        public MetadataToMondrianVfsFileName(String absPath, FileType type) {
            super("mtm", absPath, type);
        }

        protected void appendRootUri(StringBuilder stringBuilder, boolean b) {
        }

        public FileName createName(String absPath, FileType fileType) {
            MetadataToMondrianVfsFileName name = new MetadataToMondrianVfsFileName(absPath, fileType);
            return name;
        }
    }
}

