/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.procserver;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Timestamp;

public class Log {
    private static Thread lastThread = null;
    private static PrintStream logStream = null;
    private static PrintStream logStream2 = null;
    public static final String defaultLogName = "java-procs.log";
    public static final String prefixC = "--- ";

    private Log() {
    }

    public static void open(String string) throws IOException {
        logStream = new PrintStream(new FileOutputStream(string, false));
        logStream2 = System.out;
    }

    public static void open() throws IOException {
        Log.open(defaultLogName);
    }

    public static void close() throws IOException {
        logStream.close();
        logStream = null;
    }

    private static void checkThreadChange() {
        Thread thread = Thread.currentThread();
        if (thread != lastThread) {
            lastThread = thread;
            logStream.println("");
            logStream.println("---- Thread " + Integer.toHexString(thread.hashCode()) + " " + thread.getName() + " Timestamp: " + new Timestamp(System.currentTimeMillis()));
        }
    }

    public static synchronized void println(String string) {
        if (logStream != null) {
            Log.checkThreadChange();
            logStream.println(string);
            if (logStream2 != null) {
                System.out.println(prefixC + string);
            }
        }
    }

    public static synchronized void print(String string) {
        if (logStream != null) {
            Log.checkThreadChange();
            logStream.print(string);
        }
    }

    public static void log(String string) {
        Log.println(string);
    }

    public static void logErr(String string) {
        Log.println("ERR:  " + string);
    }

    public static void logTodo(String string) {
        Log.println("TODO: " + string);
    }

    public static synchronized void traceException(Throwable throwable) {
        if (logStream != null) {
            Log.checkThreadChange();
            logStream.println("Timestamp: " + new Timestamp(System.currentTimeMillis()));
            throwable.printStackTrace(logStream);
            if (logStream2 != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public static synchronized void whereAmI() {
        if (logStream != null) {
            Log.checkThreadChange();
            Log.log("whereAmI in Log");
            Throwable throwable = new Throwable();
            throwable.printStackTrace(logStream);
            throwable.printStackTrace(System.out);
        }
    }
}

