/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jruby;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.scripting.jruby.JrubyScriptEngine;
import org.apache.pig.scripting.jruby.PigJrubyLibrary;
import org.apache.pig.scripting.jruby.RubySchema;
import org.jruby.Ruby;
import org.jruby.embed.ScriptingContainer;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JrubyEvalFunc
extends EvalFunc<Object> {
    private String methodName;
    private long numRequiredArgs;
    private long numOptionalArgs;
    private String fileName;
    private String functionName;
    private boolean isInitialized = false;
    private String schemaPiece;
    private Object funcReceiver;
    private Object funcInfoEncapsulator;
    private static ScriptingContainer rubyEngine = JrubyScriptEngine.rubyEngine;
    private static Ruby ruby = rubyEngine.getProvider().getRuntime();

    private JrubyEvalFunc() {
    }

    public JrubyEvalFunc(String filename, String functionName) throws IOException {
        this.fileName = filename;
        this.functionName = functionName;
    }

    private void initialize() {
        this.funcInfoEncapsulator = JrubyScriptEngine.RubyFunctions.getFunctions("evalfunc", this.fileName).get(this.functionName);
        this.funcReceiver = rubyEngine.callMethod(this.funcInfoEncapsulator, "get_receiver", new Object[0]);
        this.methodName = (String)rubyEngine.callMethod(this.funcInfoEncapsulator, "method_name", String.class);
        this.numRequiredArgs = (Long)rubyEngine.callMethod(this.funcInfoEncapsulator, "required_args", Long.class);
        this.numOptionalArgs = (Long)rubyEngine.callMethod(this.funcInfoEncapsulator, "optional_args", Long.class);
        this.isInitialized = true;
    }

    @Override
    public Object exec(Tuple tuple) throws IOException {
        if (!this.isInitialized) {
            this.initialize();
        }
        try {
            IRubyObject rubyResult = null;
            if (tuple == null || this.numRequiredArgs == 0L && this.numOptionalArgs == 0L) {
                rubyResult = (IRubyObject)rubyEngine.callMethod(this.funcReceiver, this.methodName, IRubyObject.class);
            } else {
                Object[] args = PigJrubyLibrary.pigToRuby(ruby, tuple).toArray();
                if ((long)args.length >= this.numRequiredArgs && (this.numOptionalArgs == -1L || (long)args.length <= this.numRequiredArgs + this.numOptionalArgs)) {
                    rubyResult = (IRubyObject)rubyEngine.callMethod(this.funcReceiver, this.methodName, args, IRubyObject.class);
                } else {
                    String s = "Method " + this.methodName + " requires " + this.numRequiredArgs + " arguments and ";
                    s = s + (this.numOptionalArgs == -1L ? "unlimitated " : Long.valueOf(this.numOptionalArgs)) + " optional arguments. ";
                    s = s + "Instead, " + args.length + " arguments given.";
                    throw new RuntimeException(s);
                }
            }
            return PigJrubyLibrary.rubyToPig(rubyResult);
        }
        catch (Exception e) {
            throw new IOException("Error executing function", e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        if (!this.isInitialized) {
            this.initialize();
        }
        RubySchema rs = PigJrubyLibrary.pigToRuby(ruby, input);
        return PigJrubyLibrary.rubyToPig((RubySchema)((Object)rubyEngine.callMethod(this.funcInfoEncapsulator, "schema", new Object[]{rs, this.funcReceiver}, RubySchema.class)));
    }
}

