/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.FilterExtractor;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.UnaryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionFilterExtractor
extends FilterExtractor {
    private List<String> partitionCols;

    public PartitionFilterExtractor(LogicalExpressionPlan plan, List<String> partitionCols) {
        super(plan);
        this.partitionCols = new ArrayList<String>(partitionCols);
    }

    @Override
    protected FilterExtractor.KeyState checkPushDown(ProjectExpression project) throws FrontendException {
        String fieldName = project.getFieldSchema().alias;
        FilterExtractor.KeyState state = new FilterExtractor.KeyState();
        if (this.partitionCols.contains(fieldName)) {
            state.filterExpr = null;
            state.pushdownExpr = project;
        } else {
            state.filterExpr = this.addToFilterPlan(project);
            state.pushdownExpr = null;
        }
        return state;
    }

    @Override
    protected boolean isSupportedOpType(BinaryExpression binOp) {
        return true;
    }

    @Override
    protected boolean isSupportedOpType(UnaryExpression unaryOp) {
        return false;
    }
}

