/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.builtin.ToDate2ARGS;
import org.apache.pig.builtin.ToDate3ARGS;
import org.apache.pig.builtin.ToDateISO;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToDate
extends EvalFunc<DateTime> {
    private static final DateTimeFormatter isoDateTimeFormatter = ISODateTimeFormat.dateOptionalTimeParser().withOffsetParsed();

    @Override
    public DateTime exec(Tuple input) throws IOException {
        if (input == null || input.size() < 1 || input.get(0) == null) {
            return null;
        }
        return new DateTime((Object)DataType.toLong(input.get(0)));
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 30));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 15));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(ToDateISO.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(ToDate2ARGS.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(ToDate3ARGS.class.getName(), s));
        return funcList;
    }

    public static DateTimeZone extractDateTimeZone(String dtStr) {
        return isoDateTimeFormatter.parseDateTime(dtStr).getZone();
    }

    public static DateTime extractDateTime(String dtStr) {
        return isoDateTimeFormatter.parseDateTime(dtStr);
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

