/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.AlgebraicMathBase;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlgebraicFloatMathBase
extends AlgebraicMathBase<Float>
implements Accumulator<Float> {
    private Float intermediateVal = null;

    protected static Float getSeed(AlgebraicMathBase.KNOWN_OP op) {
        switch (op) {
            case SUM: {
                return Float.valueOf(0.0f);
            }
            case MIN: {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            case MAX: {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        return null;
    }

    private static Float doWork(Float arg1, Float arg2, AlgebraicMathBase.KNOWN_OP op) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        switch (op) {
            case MAX: {
                return Float.valueOf(Math.max(arg1.floatValue(), arg2.floatValue()));
            }
            case MIN: {
                return Float.valueOf(Math.min(arg1.floatValue(), arg2.floatValue()));
            }
            case SUM: {
                return Float.valueOf(arg1.floatValue() + arg2.floatValue());
            }
        }
        return null;
    }

    protected static Float doTupleWork(Tuple input, AlgebraicMathBase.KnownOpProvider opProvider) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        Float sofar = AlgebraicFloatMathBase.getSeed(opProvider.getOp());
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Float d = (Float)t.get(0);
                if (d == null) continue;
                sawNonNull = true;
                sofar = AlgebraicFloatMathBase.doWork(sofar, d, opProvider.getOp());
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                throw new ExecException("Problem doing work on Floats", errCode, 4, exp);
            }
        }
        return sawNonNull ? sofar : null;
    }

    @Override
    public Float exec(Tuple input) throws IOException {
        try {
            return AlgebraicFloatMathBase.doTupleWork(input, this.opProvider);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on Floats", errCode, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 20));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Float curVal = AlgebraicFloatMathBase.doTupleWork(b, this.opProvider);
            if (curVal == null) {
                return;
            }
            if (this.intermediateVal == null) {
                this.intermediateVal = AlgebraicFloatMathBase.getSeed(this.opProvider.getOp());
            }
            this.intermediateVal = AlgebraicFloatMathBase.doWork(this.intermediateVal, curVal, this.opProvider.getOp());
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on Floats", errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateVal = null;
    }

    @Override
    public Float getValue() {
        return this.intermediateVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Final
    extends AlgebraicMathBase.Final<Float> {
        @Override
        public Float exec(Tuple input) throws IOException {
            try {
                return AlgebraicFloatMathBase.doTupleWork(input, this);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on Floats", errCode, 4, e);
            }
        }
    }

    public static abstract class Intermediate
    extends AlgebraicMathBase.Intermediate {
        private static TupleFactory tfact = TupleFactory.getInstance();

        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(AlgebraicFloatMathBase.doTupleWork(input, this));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on Floats", errCode, 4, e);
            }
        }
    }
}

