/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import mondrian.olap.Util;
import mondrian.util.ArrayStack;
import mondrian.util.MondrianFloatingDecimal;

public class Format {
    private String formatString;
    private BasicFormat format;
    private FormatLocale locale;
    public static final int CacheLimit = 1000;
    private static final Map<String, Format> cache = new LinkedHashMap<String, Format>(){

        @Override
        public boolean removeEldestEntry(Map.Entry<String, Format> entry) {
            return this.size() > 1000;
        }
    };
    static final char thousandSeparator_en = ',';
    static final char decimalPlaceholder_en = '.';
    static final String dateSeparator_en = "/";
    static final String timeSeparator_en = ":";
    static final String currencySymbol_en = "$";
    static final String currencyFormat_en = "$#,##0.00";
    static final String[] daysOfWeekShort_en = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] daysOfWeekLong_en = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    static final String[] monthsShort_en = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};
    static final String[] monthsLong_en = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""};
    static final char intlCurrencySymbol = '\u00a4';
    private static final Map<String, FormatLocale> mapLocaleToFormatLocale = new HashMap<String, FormatLocale>();
    private static final Map<String, ArrayStack<Integer>> thousandSeparatorTokenMap = new HashMap<String, ArrayStack<Integer>>();
    static final FormatLocale locale_US = Format.createLocale('\u0000', '\u0000', null, null, null, null, null, null, null, null, Locale.US);
    private static final int GENERAL = 0;
    private static final int DATE = 1;
    private static final int NUMERIC = 2;
    private static final int STRING = 4;
    private static final int SPECIAL = 8;
    private static final int FORMAT_NULL = 0;
    private static final int FORMAT_C = 3;
    private static final int FORMAT_D = 4;
    private static final int FORMAT_DD = 5;
    private static final int FORMAT_DDD = 6;
    private static final int FORMAT_DDDD = 7;
    private static final int FORMAT_DDDDD = 8;
    private static final int FORMAT_DDDDDD = 9;
    private static final int FORMAT_W = 10;
    private static final int FORMAT_WW = 11;
    private static final int FORMAT_M = 12;
    private static final int FORMAT_MM = 13;
    private static final int FORMAT_MMM_UPPER = 14;
    private static final int FORMAT_MMMM_UPPER = 15;
    private static final int FORMAT_Q = 16;
    private static final int FORMAT_Y = 17;
    private static final int FORMAT_YY = 18;
    private static final int FORMAT_YYYY = 19;
    private static final int FORMAT_H = 20;
    private static final int FORMAT_HH = 21;
    private static final int FORMAT_N = 22;
    private static final int FORMAT_NN = 23;
    private static final int FORMAT_S = 24;
    private static final int FORMAT_SS = 25;
    private static final int FORMAT_TTTTT = 26;
    private static final int FORMAT_UPPER_AM_SOLIDUS_PM = 27;
    private static final int FORMAT_LOWER_AM_SOLIDUS_PM = 28;
    private static final int FORMAT_UPPER_A_SOLIDUS_P = 29;
    private static final int FORMAT_LOWER_A_SOLIDUS_P = 30;
    private static final int FORMAT_AMPM = 31;
    private static final int FORMAT_0 = 32;
    private static final int FORMAT_POUND = 33;
    private static final int FORMAT_DECIMAL = 34;
    private static final int FORMAT_PERCENT = 35;
    private static final int FORMAT_THOUSEP = 36;
    private static final int FORMAT_TIMESEP = 37;
    private static final int FORMAT_DATESEP = 38;
    private static final int FORMAT_E_MINUS_UPPER = 39;
    private static final int FORMAT_E_PLUS_UPPER = 40;
    private static final int FORMAT_E_MINUS_LOWER = 41;
    private static final int FORMAT_E_PLUS_LOWER = 42;
    private static final int FORMAT_LITERAL = 43;
    private static final int FORMAT_BACKSLASH = 44;
    private static final int FORMAT_QUOTE = 45;
    private static final int FORMAT_CHARACTER_OR_SPACE = 46;
    private static final int FORMAT_CHARACTER_OR_NOTHING = 47;
    private static final int FORMAT_LOWER = 48;
    private static final int FORMAT_UPPER = 49;
    private static final int FORMAT_FILL_FROM_LEFT = 50;
    private static final int FORMAT_SEMI = 51;
    private static final int FORMAT_GENERAL_NUMBER = 52;
    private static final int FORMAT_GENERAL_DATE = 53;
    private static final int FORMAT_INTL_CURRENCY = 54;
    private static final int FORMAT_MMM_LOWER = 55;
    private static final int FORMAT_MMMM_LOWER = 56;
    private static final int FORMAT_USD = 57;
    private static final int FORMAT_MM_UPPER = 58;
    private static final int FORMAT_MMMMM_LOWER = 59;
    private static final int FORMAT_MMMMM_UPPER = 60;
    private static final int FORMAT_HH_UPPER = 61;
    private static final int FORMAT_M_UPPER = 62;
    private static final Map<Integer, String> formatTokenToFormatString = new HashMap<Integer, String>();
    private static final Token[] tokens = new Token[]{Format.nfe(0, 2, null, "No formatting", "Display the number with no formatting."), Format.nfe(3, 1, "C", null, "Display the date as ddddd and display the time as t t t t t, in that order. Display only date information if there is no fractional part to the date serial number; display only time information if there is no integer portion."), Format.nfe(4, 1, "d", null, "Display the day as a number without a leading zero (1 - 31)."), Format.nfe(5, 1, "dd", null, "Display the day as a number with a leading zero (01 - 31)."), Format.nfe(6, 1, "Ddd", null, "Display the day as an abbreviation (Sun - Sat)."), Format.nfe(7, 1, "dddd", null, "Display the day as a full name (Sunday - Saturday)."), Format.nfe(8, 1, "ddddd", null, "Display the date as a complete date (including day, month, and year), formatted according to your system's short date format setting. The default short date format is m/d/yy."), Format.nfe(9, 1, "dddddd", null, "Display a date serial number as a complete date (including day, month, and year) formatted according to the long date setting recognized by your system. The default long date format is mmmm dd, yyyy."), Format.nfe(10, 1, "w", null, "Display the day of the week as a number (1 for Sunday through 7 for Saturday)."), Format.nfe(11, 1, "ww", null, "Display the week of the year as a number (1 - 53)."), Format.nfe(12, 9, "m", null, "Display the month as a number without a leading zero (1 - 12). If m immediately follows h or hh, the minute rather than the month is displayed."), Format.nfe(62, 1, "M", null, "Display the month as a number without a leading zero (1 - 12)."), Format.nfe(13, 9, "mm", null, "Display the month as a number with a leading zero (01 - 12). If m immediately follows h or hh, the minute rather than the month is displayed."), Format.nfe(58, 1, "MM", null, "Display the month as a number with a leading zero (01 - 12)."), Format.nfe(55, 1, "mmm", null, "Display the month as an abbreviation (Jan - Dec)."), Format.nfe(56, 1, "mmmm", null, "Display the month as a full month name (January - December)."), Format.nfe(14, 1, "MMM", null, "Display the month as an abbreviation (Jan - Dec)."), Format.nfe(15, 1, "MMMM", null, "Display the month as a full month name (January - December)."), Format.nfe(16, 1, "q", null, "Display the quarter of the year as a number (1 - 4)."), Format.nfe(17, 1, "y", null, "Display the day of the year as a number (1 - 366)."), Format.nfe(18, 1, "yy", null, "Display the year as a 2-digit number (00 - 99)."), Format.nfe(19, 1, "yyyy", null, "Display the year as a 4-digit number (100 - 9999)."), Format.nfe(20, 1, "h", null, "Display the hour as a number without leading zeros (0 - 23)."), Format.nfe(21, 1, "hh", null, "Display the hour as a number with leading zeros (00 - 23)."), Format.nfe(22, 1, "n", null, "Display the minute as a number without leading zeros (0 - 59)."), Format.nfe(23, 1, "nn", null, "Display the minute as a number with leading zeros (00 - 59)."), Format.nfe(24, 1, "s", null, "Display the second as a number without leading zeros (0 - 59)."), Format.nfe(25, 1, "ss", null, "Display the second as a number with leading zeros (00 - 59)."), Format.nfe(26, 1, "ttttt", null, "Display a time as a complete time (including hour, minute, and second), formatted using the time separator defined by the time format recognized by your system. A leading zero is displayed if the leading zero option is selected and the time is before 10:00 A.M. or P.M. The default time format is h:mm:ss."), Format.nfe(27, 1, "AM/PM", null, "Use the 12-hour clock and display an uppercase AM with any hour before noon; display an uppercase PM with any hour between noon and 11:59 P.M."), Format.nfe(28, 1, "am/pm", null, "Use the 12-hour clock and display a lowercase AM with any hour before noon; display a lowercase PM with any hour between noon and 11:59 P.M."), Format.nfe(29, 1, "A/P", null, "Use the 12-hour clock and display an uppercase A with any hour before noon; display an uppercase P with any hour between noon and 11:59 P.M."), Format.nfe(30, 1, "a/p", null, "Use the 12-hour clock and display a lowercase A with any hour before noon; display a lowercase P with any hour between noon and 11:59 P.M."), Format.nfe(31, 1, "AMPM", null, "Use the 12-hour clock and display the AM string literal as defined by your system with any hour before noon; display the PM string literal as defined by your system with any hour between noon and 11:59 P.M. AMPM can be either uppercase or lowercase, but the case of the string displayed matches the string as defined by your system settings. The default format is AM/PM."), Format.nfe(32, 10, "0", "Digit placeholder", "Display a digit or a zero. If the expression has a digit in the position where the 0 appears in the format string, display it; otherwise, display a zero in that position. If the number has fewer digits than there are zeros (on either side of the decimal) in the format expression, display leading or trailing zeros. If the number has more digits to the right of the decimal separator than there are zeros to the right of the decimal separator in the format expression, round the number to as many decimal places as there are zeros. If the number has more digits to the left of the decimal separator than there are zeros to the left of the decimal separator in the format expression, display the extra digits without modification."), Format.nfe(33, 10, "#", "Digit placeholder", "Display a digit or nothing. If the expression has a digit in the position where the # appears in the format string, display it; otherwise, display nothing in that position.  This symbol works like the 0 digit placeholder, except that leading and trailing zeros aren't displayed if the number has the same or fewer digits than there are # characters on either side of the decimal separator in the format expression."), Format.nfe(34, 10, ".", "Decimal placeholder", "In some locales, a comma is used as the decimal separator. The decimal placeholder determines how many digits are displayed to the left and right of the decimal separator. If the format expression contains only number signs to the left of this symbol, numbers smaller than 1 begin with a decimal separator. If you always want a leading zero displayed with fractional numbers, use 0 as the first digit placeholder to the left of the decimal separator instead. The actual character used as a decimal placeholder in the formatted output depends on the Number Format recognized by your system."), Format.nfe(35, 2, "%", "Percent placeholder", "The expression is multiplied by 100. The percent character (%) is inserted in the position where it appears in the format string."), Format.nfe(36, 10, ",", "Thousand separator", "In some locales, a period is used as a thousand separator. The thousand separator separates thousands from hundreds within a number that has four or more places to the left of the decimal separator. Standard use of the thousand separator is specified if the format contains a thousand separator surrounded by digit placeholders (0 or #). Two adjacent thousand separators or a thousand separator immediately to the left of the decimal separator (whether or not a decimal is specified) means \"scale the number by dividing it by 1000, rounding as needed.\"  You can scale large numbers using this technique. For example, you can use the format string \"##0,,\" to represent 100 million as 100. Numbers smaller than 1 million are displayed as 0. Two adjacent thousand separators in any position other than immediately to the left of the decimal separator are treated simply as specifying the use of a thousand separator. The actual character used as the thousand separator in the formatted output depends on the Number Format recognized by your system."), Format.nfe(37, 9, ":", "Time separator", "In some locales, other characters may be used to represent the time separator. The time separator separates hours, minutes, and seconds when time values are formatted. The actual character used as the time separator in formatted output is determined by your system settings."), Format.nfe(38, 9, "/", "Date separator", "In some locales, other characters may be used to represent the date separator. The date separator separates the day, month, and year when date values are formatted. The actual character used as the date separator in formatted output is determined by your system settings."), Format.nfe(39, 10, "E-", "Scientific format", "If the format expression contains at least one digit placeholder (0 or #) to the right of E-, E+, e-, or e+, the number is displayed in scientific format and E or e is inserted between the number and its exponent. The number of digit placeholders to the right determines the number of digits in the exponent. Use E- or e- to place a minus sign next to negative exponents. Use E+ or e+ to place a minus sign next to negative exponents and a plus sign next to positive exponents."), Format.nfe(40, 10, "E+", "Scientific format", "See E-."), Format.nfe(41, 10, "e-", "Scientific format", "See E-."), Format.nfe(42, 10, "e+", "Scientific format", "See E-."), Format.nfe(43, 0, "-", "Display a literal character", "To display a character other than one of those listed, precede it with a backslash (\\) or enclose it in double quotation marks (\" \")."), Format.nfe(43, 0, "+", "Display a literal character", "See -."), Format.nfe(43, 0, "$", "Display a literal character", "See -."), Format.nfe(43, 0, "(", "Display a literal character", "See -."), Format.nfe(43, 0, ")", "Display a literal character", "See -."), Format.nfe(43, 0, " ", "Display a literal character", "See -."), Format.nfe(44, 8, "\\", "Display the next character in the format string", "Many characters in the format expression have a special meaning and can't be displayed as literal characters unless they are preceded by a backslash. The backslash itself isn't displayed. Using a backslash is the same as enclosing the next character in double quotation marks. To display a backslash, use two backslashes (\\).  Examples of characters that can't be displayed as literal characters are the date- and time-formatting characters (a, c, d, h, m, n, p, q, s, t, w, y, and /:), the numeric-formatting characters (#, 0, %, E, e, comma, and period), and the string-formatting characters (@, &, <, >, and !)."), Format.nfe(45, 8, "\"", "Display the string inside the double quotation marks", "To include a string in format from within code, you must use Chr(34) to enclose the text (34 is the character code for a double quotation mark)."), Format.nfe(46, 4, "@", "Character placeholder", "Display a character or a space. If the string has a character in the position where the @ appears in the format string, display it; otherwise, display a space in that position. Placeholders are filled from right to left unless there is an ! character in the format string. See below."), Format.nfe(47, 4, "&", "Character placeholder", "Display a character or nothing. If the string has a character in the position where the & appears, display it; otherwise, display nothing. Placeholders are filled from right to left unless there is an ! character in the format string. See below."), Format.nfe(48, 12, "<", "Force lowercase", "Display all characters in lowercase format."), Format.nfe(49, 12, ">", "Force uppercase", "Display all characters in uppercase format."), Format.nfe(50, 12, "!", "Force left to right fill of placeholders", "The default is to fill from right to left."), Format.nfe(51, 8, ";", "Separates format strings for different kinds of values", "If there is one section, the format expression applies to all values. If there are two sections, the first section applies to positive values and zeros, the second to negative values. If there are three sections, the first section applies to positive values, the second to negative values, and the third to zeros. If there are four sections, the first section applies to positive values, the second to negative values, the third to zeros, and the fourth to Null values."), Format.nfe(54, 10, "\u00a4", null, "Display the locale's currency symbol."), Format.nfe(57, 0, "USD", null, "Display USD (U.S. Dollars)."), Format.nfe(52, 10, "General Number", null, "Shows numbers as entered."), Format.nfe(53, 9, "General Date", null, "Shows date and time if expression contains both. If expression is only a date or a time, the missing information is not displayed."), Format.nfe(59, 1, "mmmmm", null, "Display the month as a full month name (January - December)."), Format.nfe(60, 1, "MMMMM", null, "Display the month as a full month name (January - December)."), Format.nfe(61, 1, "HH", null, "Display the hour as a number with leading zeros (00 - 23).")};
    static final int NOT_IN_A_NUMBER = 0;
    static final int LEFT_OF_POINT = 1;
    static final int RIGHT_OF_POINT = 2;
    static final int RIGHT_OF_EXP = 3;

    private static Token nfe(int code, int flags, String token, String purpose, String description) {
        Util.discard((Object)purpose);
        Util.discard((Object)description);
        formatTokenToFormatString.put(code, token);
        return new Token(code, flags, token);
    }

    public static List<Token> getTokenList() {
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    public static String getFormatToken(int code) {
        return formatTokenToFormatString.get(code);
    }

    public Format(String formatString, Locale locale) {
        this(formatString, Format.getBestFormatLocale(locale));
    }

    public Format(String formatString, FormatLocale locale) {
        if (formatString == null) {
            formatString = "";
        }
        this.formatString = formatString;
        if (locale == null) {
            locale = locale_US;
        }
        this.locale = locale;
        ArrayList<BasicFormat> alternateFormatList = new ArrayList<BasicFormat>();
        FormatType[] formatType = new FormatType[]{null};
        while (formatString.length() > 0) {
            formatString = this.parseFormatString(formatString, alternateFormatList, formatType);
        }
        if (alternateFormatList.size() == 0 || alternateFormatList.get(0) == null) {
            this.format = new JavaFormat(locale.locale);
        } else if (alternateFormatList.size() == 1 && (formatType[0] == FormatType.DATE || formatType[0] == FormatType.STRING)) {
            this.format = (BasicFormat)alternateFormatList.get(0);
        } else {
            BasicFormat[] alternateFormats = alternateFormatList.toArray(new BasicFormat[alternateFormatList.size()]);
            this.format = new AlternateFormat(alternateFormats, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Format get(String formatString, Locale locale) {
        String key = formatString + "@@@" + locale;
        Format format = cache.get(key);
        if (format == null) {
            Map<String, Format> map = cache;
            synchronized (map) {
                format = cache.get(key);
                if (format == null) {
                    format = new Format(formatString, locale);
                    cache.put(key, format);
                }
            }
        }
        return format;
    }

    public static FormatLocale createLocale(char thousandSeparator, char decimalPlaceholder, String dateSeparator, String timeSeparator, String currencySymbol, String currencyFormat, String[] daysOfWeekShort, String[] daysOfWeekLong, String[] monthsShort, String[] monthsLong, Locale locale) {
        FormatLocale formatLocale = new FormatLocale(thousandSeparator, decimalPlaceholder, dateSeparator, timeSeparator, currencySymbol, currencyFormat, daysOfWeekShort, daysOfWeekLong, monthsShort, monthsLong, locale);
        if (locale != null) {
            Format.registerFormatLocale(formatLocale, locale);
        }
        return formatLocale;
    }

    public static FormatLocale createLocale(Locale locale) {
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(locale);
        DateFormatSymbols dateSymbols = new DateFormatSymbols(locale);
        Calendar calendar = Calendar.getInstance(locale);
        calendar.set(1969, 11, 31, 0, 0, 0);
        Date date = calendar.getTime();
        java.text.DateFormat dateFormat = java.text.DateFormat.getDateInstance(3, locale);
        String dateValue = dateFormat.format(date);
        String dateSeparator = dateValue.substring(2, 3);
        java.text.DateFormat timeFormat = java.text.DateFormat.getTimeInstance(3, locale);
        String timeValue = timeFormat.format(date);
        String timeSeparator = timeValue.substring(2, 3);
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(locale);
        String currencyValue = currencyFormat.format(123456.78);
        String currencyLeft = currencyValue.substring(0, currencyValue.indexOf("1"));
        String currencyRight = currencyValue.substring(currencyValue.indexOf("8") + 1);
        StringBuilder buf = new StringBuilder();
        buf.append(currencyLeft);
        int minimumIntegerDigits = currencyFormat.getMinimumIntegerDigits();
        for (int i = Math.max(minimumIntegerDigits, 4) - 1; i >= 0; --i) {
            buf.append(i < minimumIntegerDigits ? (char)'0' : '#');
            if (i % 3 != 0 || i <= 0) continue;
            buf.append(',');
        }
        if (currencyFormat.getMaximumFractionDigits() > 0) {
            buf.append('.');
            Format.appendTimes(buf, '0', currencyFormat.getMinimumFractionDigits());
            Format.appendTimes(buf, '#', currencyFormat.getMaximumFractionDigits() - currencyFormat.getMinimumFractionDigits());
        }
        buf.append(currencyRight);
        String currencyFormatString = buf.toString();
        String currencySymbol = decimalSymbols.getCurrencySymbol();
        if (currencySymbol.equals("\u00a4")) {
            DecimalFormatSymbols defaultDecimalSymbols = new DecimalFormatSymbols(Locale.getDefault());
            currencySymbol = defaultDecimalSymbols.getCurrencySymbol();
        }
        return Format.createLocale(decimalSymbols.getGroupingSeparator(), decimalSymbols.getDecimalSeparator(), dateSeparator, timeSeparator, currencySymbol, currencyFormatString, dateSymbols.getShortWeekdays(), dateSymbols.getWeekdays(), dateSymbols.getShortMonths(), dateSymbols.getMonths(), locale);
    }

    private static void appendTimes(StringBuilder buf, char c, int i) {
        while (i-- > 0) {
            buf.append(c);
        }
    }

    public static FormatLocale getFormatLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.US;
        }
        String key = locale.toString();
        return mapLocaleToFormatLocale.get(key);
    }

    public static synchronized FormatLocale getBestFormatLocale(Locale locale) {
        if (locale == null) {
            return locale_US;
        }
        String key = locale.toString();
        FormatLocale formatLocale = mapLocaleToFormatLocale.get(key);
        if (formatLocale == null) {
            formatLocale = Format.getFormatLocaleUsingFactory(locale);
            if (formatLocale == null) {
                formatLocale = locale_US;
            }
            mapLocaleToFormatLocale.put(key, formatLocale);
        }
        return formatLocale;
    }

    private static FormatLocale getFormatLocaleUsingFactory(Locale locale) {
        FormatLocale formatLocale;
        if (!locale.getVariant().equals("")) {
            formatLocale = Format.createLocale(locale);
            if (formatLocale != null) {
                return formatLocale;
            }
            locale = new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (!locale.getCountry().equals("")) {
            formatLocale = Format.createLocale(locale);
            if (formatLocale != null) {
                return formatLocale;
            }
            locale = new Locale(locale.getLanguage());
        }
        if ((formatLocale = Format.createLocale(locale)) != null) {
            return formatLocale;
        }
        return null;
    }

    public static FormatLocale registerFormatLocale(FormatLocale formatLocale, Locale locale) {
        String key = locale.toString();
        return mapLocaleToFormatLocale.put(key, formatLocale);
    }

    private String parseFormatString(String formatString, List<BasicFormat> alternateFormatList, FormatType[] formatTypeOut) {
        BasicFormat alternateFormat;
        int i;
        String originalFormatString = formatString;
        int numberState = 0;
        StringBuilder ignored = new StringBuilder();
        String prevIgnored = null;
        boolean haveSeenNumber = false;
        int digitsLeftOfPoint = 0;
        int digitsRightOfPoint = 0;
        int digitsRightOfExp = 0;
        int zeroesLeftOfPoint = 0;
        int zeroesRightOfPoint = 0;
        int zeroesRightOfExp = 0;
        boolean useDecimal = false;
        boolean useThouSep = false;
        boolean fillFromRight = true;
        int expFormat = 0;
        if (!(formatString = MacroToken.expand(this.locale, formatString)).endsWith(";")) {
            formatString = formatString + ";";
        }
        ArrayList<BasicFormat> formatList = new ArrayList<BasicFormat>();
        ArrayList<Integer> thousands = new ArrayList<Integer>();
        int decimalShift = 0;
        block41: while (formatString.length() > 0) {
            String newFormatString;
            BasicFormat format = null;
            Token token = this.findToken(formatString, formatTypeOut[0]);
            if (token != null) {
                String matched = token.token;
                newFormatString = formatString.substring(matched.length());
                if (token.isSpecial()) {
                    block0 : switch (token.code) {
                        case 51: {
                            break block41;
                        }
                        case 33: {
                            switch (numberState) {
                                case 0: {
                                    numberState = 1;
                                }
                                case 1: {
                                    ++digitsLeftOfPoint;
                                    break block0;
                                }
                                case 2: {
                                    ++digitsRightOfPoint;
                                    break block0;
                                }
                                case 3: {
                                    ++digitsRightOfExp;
                                    break block0;
                                }
                            }
                            throw new Error();
                        }
                        case 32: {
                            switch (numberState) {
                                case 0: {
                                    numberState = 1;
                                }
                                case 1: {
                                    ++zeroesLeftOfPoint;
                                    break block0;
                                }
                                case 2: {
                                    ++zeroesRightOfPoint;
                                    break block0;
                                }
                                case 3: {
                                    ++zeroesRightOfExp;
                                    break block0;
                                }
                            }
                            throw new Error();
                        }
                        case 12: 
                        case 13: {
                            int j;
                            boolean theyMeantMinute = false;
                            for (j = formatList.size() - 1; j >= 0; --j) {
                                BasicFormat prevFormat = (BasicFormat)formatList.get(j);
                                if (prevFormat instanceof LiteralFormat) {
                                    continue;
                                }
                                if (prevFormat.code == 20 || prevFormat.code == 21 || prevFormat.code == 61) {
                                    theyMeantMinute = true;
                                    break;
                                }
                                theyMeantMinute = false;
                                break;
                            }
                            if (theyMeantMinute) {
                                format = new DateFormat(token.code == 12 ? 22 : 23, matched, this.locale, false);
                                break;
                            }
                            format = token.makeFormat(this.locale);
                            break;
                        }
                        case 34: {
                            if (numberState == 1) {
                                decimalShift = this.fixThousands(thousands, formatString, decimalShift);
                            }
                            numberState = 2;
                            useDecimal = true;
                            break;
                        }
                        case 36: {
                            if (numberState == 1) {
                                useThouSep = true;
                                thousands.add(formatString.length());
                                break;
                            }
                            format = token.makeFormat(this.locale);
                            break;
                        }
                        case 37: {
                            format = new LiteralFormat(this.locale.timeSeparator);
                            break;
                        }
                        case 38: {
                            format = new LiteralFormat(this.locale.dateSeparator);
                            break;
                        }
                        case 44: {
                            String s;
                            if (formatString.length() == 1) {
                                s = "";
                                newFormatString = "";
                            } else {
                                s = formatString.substring(1, 2);
                                newFormatString = formatString.substring(2);
                            }
                            format = new LiteralFormat(s);
                            break;
                        }
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: {
                            if (numberState == 1) {
                                decimalShift = this.fixThousands(thousands, formatString, decimalShift);
                            }
                            numberState = 3;
                            expFormat = token.code;
                            if (zeroesLeftOfPoint != 0 || zeroesRightOfPoint != 0) break;
                            zeroesLeftOfPoint = 1;
                            break;
                        }
                        case 45: {
                            String s;
                            int j = formatString.indexOf("\"", 1);
                            if (j == -1) {
                                s = formatString.substring(1);
                                newFormatString = "";
                            } else {
                                s = formatString.substring(1, j);
                                newFormatString = formatString.substring(j + 1);
                            }
                            format = new LiteralFormat(s);
                            break;
                        }
                        case 49: {
                            format = new StringFormat(StringCase.UPPER, ">", this.locale.locale);
                            break;
                        }
                        case 48: {
                            format = new StringFormat(StringCase.LOWER, "<", this.locale.locale);
                            break;
                        }
                        case 50: {
                            fillFromRight = false;
                            break;
                        }
                        case 52: {
                            format = new JavaFormat(this.locale.locale);
                            break;
                        }
                        case 53: {
                            format = new JavaFormat(this.locale.locale);
                            break;
                        }
                        case 54: {
                            format = new LiteralFormat(this.locale.currencySymbol);
                            break;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                    if (formatTypeOut[0] == null) {
                        formatTypeOut[0] = token.getFormatType();
                    }
                    if (format == null) {
                        ignored.append(matched);
                    } else {
                        prevIgnored = ignored.toString();
                        ignored.setLength(0);
                    }
                } else {
                    format = token.makeFormat(this.locale);
                }
            } else {
                format = new LiteralFormat(formatString.substring(0, 1));
                newFormatString = formatString.substring(1);
            }
            if (format != null) {
                if (numberState != 0) {
                    if (numberState == 1) {
                        decimalShift = this.fixThousands(thousands, formatString, decimalShift);
                    }
                    NumericFormat numericFormat = new NumericFormat(prevIgnored, this.locale, expFormat, digitsLeftOfPoint, zeroesLeftOfPoint, digitsRightOfPoint, zeroesRightOfPoint, digitsRightOfExp, zeroesRightOfExp, useDecimal, useThouSep, originalFormatString);
                    formatList.add(numericFormat);
                    numberState = 0;
                    haveSeenNumber = true;
                }
                formatList.add(format);
                if (formatTypeOut[0] == null) {
                    formatTypeOut[0] = format.getFormatType();
                }
            }
            formatString = newFormatString;
        }
        if (numberState != 0) {
            if (numberState == 1) {
                decimalShift = this.fixThousands(thousands, formatString, decimalShift);
            }
            NumericFormat numericFormat = new NumericFormat(prevIgnored, this.locale, expFormat, digitsLeftOfPoint, zeroesLeftOfPoint, digitsRightOfPoint, zeroesRightOfPoint, digitsRightOfExp, zeroesRightOfExp, useDecimal, useThouSep, originalFormatString);
            formatList.add(numericFormat);
            numberState = 0;
            haveSeenNumber = true;
        }
        if (formatString.startsWith(";")) {
            formatString = formatString.substring(1);
        }
        boolean twelveHourClock = false;
        boolean isFormatHH = false;
        block43: for (i = 0; i < formatList.size(); ++i) {
            switch (((BasicFormat)formatList.get((int)i)).code) {
                case 61: {
                    isFormatHH = true;
                    continue block43;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    twelveHourClock = true & !isFormatHH;
                    continue block43;
                }
                case 35: {
                    decimalShift += 2;
                    continue block43;
                }
                case 36: {
                    if (!haveSeenNumber || i + 1 >= formatList.size()) continue block43;
                    BasicFormat nextFormat = (BasicFormat)formatList.get(i + 1);
                    if (nextFormat.code == 36 || nextFormat.code == 32 || nextFormat.code == 33) continue block43;
                    for (int j = i; j >= 0 && ((BasicFormat)formatList.get((int)j)).code == 36; --j) {
                        decimalShift -= 3;
                        formatList.remove(j);
                        --i;
                    }
                    continue block43;
                }
            }
        }
        if (twelveHourClock) {
            for (i = 0; i < formatList.size(); ++i) {
                if (!(formatList.get(i) instanceof DateFormat)) continue;
                ((DateFormat)formatList.get(i)).setTwelveHourClock(true);
            }
        }
        if (decimalShift != 0) {
            for (i = 0; i < formatList.size(); ++i) {
                if (!(formatList.get(i) instanceof NumericFormat)) continue;
                ((NumericFormat)formatList.get((int)i)).decimalShift = decimalShift;
            }
        }
        for (i = 0; i < formatList.size(); ++i) {
            if (i <= 0 || !(formatList.get(i) instanceof LiteralFormat) || !(formatList.get(i - 1) instanceof LiteralFormat)) continue;
            formatList.set(i - 1, new LiteralFormat(((LiteralFormat)formatList.get((int)(i - 1))).s + ((LiteralFormat)formatList.get((int)i)).s));
            formatList.remove(i);
            --i;
        }
        switch (formatList.size()) {
            case 0: {
                alternateFormat = null;
                break;
            }
            case 1: {
                alternateFormat = (BasicFormat)formatList.get(0);
                break;
            }
            default: {
                alternateFormat = new CompoundFormat(formatList.toArray(new BasicFormat[formatList.size()]));
            }
        }
        alternateFormatList.add(alternateFormat);
        return formatString;
    }

    private Token findToken(String formatString, FormatType formatType) {
        for (int i = tokens.length - 1; i > 0; --i) {
            Token token = tokens[i];
            if (!formatString.startsWith(token.token) || !token.compatibleWith(formatType)) continue;
            return token;
        }
        return null;
    }

    private int fixThousands(List<Integer> thousands, String formatString, int shift) {
        int offset = formatString.length() + 1;
        for (int i = thousands.size() - 1; i >= 0; --i) {
            Integer integer = thousands.get(i);
            thousands.set(i, integer - offset);
            ++offset;
        }
        while (thousands.size() > 0 && thousands.get(thousands.size() - 1) == 0) {
            shift -= 3;
            thousands.remove(thousands.size() - 1);
        }
        return shift;
    }

    public String format(Object o) {
        StringBuilder buf = new StringBuilder();
        this.format(o, buf);
        return buf.toString();
    }

    private StringBuilder format(Object o, StringBuilder buf) {
        if (o == null) {
            this.format.formatNull(buf);
        } else {
            Class<?> clazz = o.getClass();
            if (clazz == Double.class) {
                this.format.format((Double)o, buf);
            } else if (clazz == Float.class) {
                this.format.format(((Float)o).floatValue(), buf);
            } else if (clazz == Integer.class) {
                this.format.format(((Integer)o).intValue(), buf);
            } else if (clazz == Long.class) {
                this.format.format((Long)o, buf);
            } else if (clazz == Short.class) {
                this.format.format(((Short)o).shortValue(), buf);
            } else if (clazz == Byte.class) {
                this.format.format(((Byte)o).byteValue(), buf);
            } else if (o instanceof BigDecimal) {
                this.format.format(((BigDecimal)o).doubleValue(), buf);
            } else if (o instanceof BigInteger) {
                this.format.format(((BigInteger)o).longValue(), buf);
            } else if (clazz == String.class) {
                this.format.format((String)o, buf);
            } else if (o instanceof Date) {
                this.format.format((Date)o, buf);
            } else if (o instanceof Calendar) {
                this.format.format((Calendar)o, buf);
            } else {
                buf.append(o.toString());
            }
        }
        return buf;
    }

    public String getFormatString() {
        return this.formatString;
    }

    private static void shift(MondrianFloatingDecimal fd, int i) {
        if (!(fd.isExceptional || fd.nDigits == 1 && fd.digits[0] == '0')) {
            fd.decExponent += i;
        }
    }

    private static void formatFd0(MondrianFloatingDecimal fd, StringBuilder buf, int minDigitsLeftOfDecimal, char decimalChar, int minDigitsRightOfDecimal, int maxDigitsRightOfDecimal, char expChar, boolean expSign, int minExpDigits, char thousandChar, boolean useDecimal, ArrayStack<Integer> thousandSeparatorPositions) {
        int resultLen = 10 + Math.abs(fd.decExponent) * 4 / 3 + maxDigitsRightOfDecimal;
        char[] result = new char[resultLen];
        int i = Format.formatFd1(fd, result, 0, minDigitsLeftOfDecimal, decimalChar, minDigitsRightOfDecimal, maxDigitsRightOfDecimal, expChar, expSign, minExpDigits, thousandChar, useDecimal, thousandSeparatorPositions);
        buf.append(result, 0, i);
    }

    private static int formatFd1(MondrianFloatingDecimal fd, char[] result, int i, int minDigitsLeftOfDecimal, char decimalChar, int minDigitsRightOfDecimal, int maxDigitsRightOfDecimal, char expChar, boolean expSign, int minExpDigits, char thousandChar, boolean useDecimal, ArrayStack<Integer> thousandSeparatorPositions) {
        if (expChar != '\u0000') {
            int oldExp = fd.decExponent;
            fd.decExponent = Math.min(minDigitsLeftOfDecimal, fd.nDigits);
            boolean oldIsNegative = fd.isNegative;
            fd.isNegative = false;
            i = Format.formatFd2(fd, result, i, minDigitsLeftOfDecimal, decimalChar, minDigitsRightOfDecimal, maxDigitsRightOfDecimal, '\u0000', useDecimal, thousandSeparatorPositions);
            fd.decExponent = oldExp;
            fd.isNegative = oldIsNegative;
            result[i++] = expChar;
            return fd.formatExponent(result, i, expSign, minExpDigits);
        }
        return Format.formatFd2(fd, result, i, minDigitsLeftOfDecimal, decimalChar, minDigitsRightOfDecimal, maxDigitsRightOfDecimal, thousandChar, useDecimal, thousandSeparatorPositions);
    }

    static int formatFd2(MondrianFloatingDecimal fd, char[] result, int i, int minDigitsLeftOfDecimal, char decimalChar, int minDigitsRightOfDecimal, int maxDigitsRightOfDecimal, char thousandChar, boolean useDecimal, ArrayStack<Integer> thousandSeparatorPositions) {
        int lastDigitToPrint;
        char[] digits2;
        int totalDigits;
        int wholeDigits;
        block23: {
            int j;
            if (fd.isNegative) {
                result[i++] = 45;
            }
            if (fd.isExceptional) {
                System.arraycopy(fd.digits, 0, result, i, fd.nDigits);
                return i + fd.nDigits;
            }
            wholeDigits = Math.max(fd.decExponent, minDigitsLeftOfDecimal);
            int fractionDigits = Math.max(fd.nDigits - fd.decExponent, minDigitsRightOfDecimal);
            totalDigits = wholeDigits + fractionDigits;
            digits2 = new char[totalDigits];
            for (j = 0; j < totalDigits; ++j) {
                digits2[j] = 48;
            }
            for (j = 0; j < fd.nDigits; ++j) {
                digits2[wholeDigits - fd.decExponent + j] = fd.digits[j];
            }
            int lastDigit = wholeDigits + maxDigitsRightOfDecimal;
            if (lastDigit < totalDigits) {
                int m = totalDigits;
                while (true) {
                    if (--m < 0) {
                        ++wholeDigits;
                        ++lastDigit;
                        char[] old = digits2;
                        digits2 = new char[++totalDigits];
                        digits2[0] = 49;
                        System.arraycopy(old, 0, digits2, 1, old.length);
                        break block23;
                    }
                    if (m == lastDigit) {
                        char d = digits2[m];
                        digits2[m] = 48;
                        if (d >= '5') continue;
                        break block23;
                    }
                    if (m > lastDigit) {
                        digits2[m] = 48;
                        continue;
                    }
                    if (digits2[m] != '9') break;
                    digits2[m] = 48;
                }
                int n = m;
                digits2[n] = (char)(digits2[n] + '\u0001');
            }
        }
        int firstNonZero = wholeDigits;
        int firstTrailingZero = 0;
        for (int j = 0; j < totalDigits; ++j) {
            if (digits2[j] == '0') continue;
            if (j < firstNonZero) {
                firstNonZero = j;
            }
            firstTrailingZero = j + 1;
        }
        int firstDigitToPrint = firstNonZero;
        if (firstDigitToPrint > wholeDigits - minDigitsLeftOfDecimal) {
            firstDigitToPrint = wholeDigits - minDigitsLeftOfDecimal;
        }
        if ((lastDigitToPrint = firstTrailingZero) > wholeDigits + maxDigitsRightOfDecimal) {
            lastDigitToPrint = wholeDigits + maxDigitsRightOfDecimal;
        }
        if (lastDigitToPrint < wholeDigits + minDigitsRightOfDecimal) {
            lastDigitToPrint = wholeDigits + minDigitsRightOfDecimal;
        }
        if (thousandChar != '\u0000' && thousandSeparatorPositions.size() > 0) {
            ArrayStack<Character> formattedWholeDigits = new ArrayStack<Character>();
            int nbInserted = 0;
            for (int j = wholeDigits - 1; j >= firstDigitToPrint; --j) {
                if (nbInserted % thousandSeparatorPositions.peek() == 0 && nbInserted > 0) {
                    formattedWholeDigits.push(Character.valueOf(thousandChar));
                    nbInserted = 0;
                    if (thousandSeparatorPositions.size() > 1) {
                        thousandSeparatorPositions.pop();
                    }
                }
                formattedWholeDigits.push(Character.valueOf(digits2[j]));
                ++nbInserted;
            }
            while (formattedWholeDigits.size() > 0) {
                result[i++] = ((Character)formattedWholeDigits.pop()).charValue();
            }
        } else {
            for (int j = firstDigitToPrint; j < wholeDigits; ++j) {
                result[i++] = digits2[j];
            }
        }
        if (wholeDigits < lastDigitToPrint || useDecimal && wholeDigits == lastDigitToPrint) {
            result[i++] = decimalChar;
        }
        for (int j = wholeDigits; j < lastDigitToPrint; ++j) {
            result[i++] = digits2[j];
        }
        return i;
    }

    private static class MondrianFloatingDecimalSpec {
        boolean isExceptional;
        boolean isNegative;
        int decExponent;
        char[] digits;
        int nDigits;

        MondrianFloatingDecimalSpec(double n) {
        }

        int formatExponent(char[] result, int i, boolean expSign, int minExpDigits) {
            return i;
        }

        int handleExceptional(char[] result, int i) {
            return i;
        }

        int handleNegative(char[] result, int i) {
            return i;
        }
    }

    private static class DummyDecimalFormat
    extends DecimalFormat {
        private FieldPosition pos;

        private DummyDecimalFormat() {
        }

        @Override
        public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
            this.pos = fieldPosition;
            return result;
        }
    }

    private static enum FormatType {
        STRING,
        DATE,
        NUMERIC;

    }

    private static final class MacroToken
    extends Enum<MacroToken> {
        public static final /* enum */ MacroToken CURRENCY = new MacroToken("Currency", null, "Shows currency values according to the locale's CurrencyFormat.  Negative numbers are inside parentheses.");
        public static final /* enum */ MacroToken FIXED = new MacroToken("Fixed", "0", "Shows at least one digit.");
        public static final /* enum */ MacroToken STANDARD = new MacroToken("Standard", "#,##0", "Uses a thousands separator.");
        public static final /* enum */ MacroToken PERCENT = new MacroToken("Percent", "0.00%", "Multiplies the value by 100 with a percent sign at the end.");
        public static final /* enum */ MacroToken SCIENTIFIC = new MacroToken("Scientific", "0.00e+00", "Uses standard scientific notation.");
        public static final /* enum */ MacroToken LONG_DATE = new MacroToken("Long Date", "dddd, mmmm dd, yyyy", "Uses the Long Date format specified in the Regional Settings dialog box of the Microsoft Windows Control Panel.");
        public static final /* enum */ MacroToken MEDIUM_DATE = new MacroToken("Medium Date", "dd-mmm-yy", "Uses the dd-mmm-yy format (for example, 03-Apr-93)");
        public static final /* enum */ MacroToken SHORT_DATE = new MacroToken("Short Date", "m/d/yy", "Uses the Short Date format specified in the Regional Settings dialog box of the Windows Control Panel.");
        public static final /* enum */ MacroToken LONG_TIME = new MacroToken("Long Time", "h:mm:ss AM/PM", "Shows the hour, minute, second, and \"AM\" or \"PM\" using the h:mm:ss format.");
        public static final /* enum */ MacroToken MEDIUM_TIME = new MacroToken("Medium Time", "h:mm AM/PM", "Shows the hour, minute, and \"AM\" or \"PM\" using the \"hh:mm AM/PM\" format.");
        public static final /* enum */ MacroToken SHORT_TIME = new MacroToken("Short Time", "hh:mm", "Shows the hour and minute using the hh:mm format.");
        public static final /* enum */ MacroToken YES_NO = new MacroToken("Yes/No", "\\Y\\e\\s;\\Y\\e\\s;\\N\\o;\\N\\o", "Any nonzero numeric value (usually - 1) is Yes. Zero is No.");
        public static final /* enum */ MacroToken TRUE_FALSE = new MacroToken("True/False", "\\T\\r\\u\\e;\\T\\r\\u\\e;\\F\\a\\l\\s\\e;\\F\\a\\l\\s\\e", "Any nonzero numeric value (usually - 1) is True. Zero is False.");
        public static final /* enum */ MacroToken ON_OFF = new MacroToken("On/Off", "\\O\\n;\\O\\n;\\O\\f\\f;\\O\\f\\f", "Any nonzero numeric value (usually - 1) is On. Zero is Off.");
        private static final Map<String, MacroToken> MAP;
        final String token;
        final String translation;
        final String description;
        private static final /* synthetic */ MacroToken[] $VALUES;

        public static MacroToken[] values() {
            return (MacroToken[])$VALUES.clone();
        }

        public static MacroToken valueOf(String name) {
            return Enum.valueOf(MacroToken.class, name);
        }

        private MacroToken(String token, String translation, String description) {
            this.token = token;
            this.translation = translation;
            this.description = description;
            assert (this.name().equals(token.replace(',', '_').replace(' ', '_').replace('/', '_').toUpperCase()));
            assert (translation == null == this.name().equals("CURRENCY"));
        }

        static String expand(FormatLocale locale, String formatString) {
            MacroToken macroToken = MAP.get(formatString);
            if (macroToken == null) {
                return formatString;
            }
            if (macroToken == CURRENCY) {
                return locale.currencyFormat + ";(" + locale.currencyFormat + ")";
            }
            return macroToken.translation;
        }

        static {
            $VALUES = new MacroToken[]{CURRENCY, FIXED, STANDARD, PERCENT, SCIENTIFIC, LONG_DATE, MEDIUM_DATE, SHORT_DATE, LONG_TIME, MEDIUM_TIME, SHORT_TIME, YES_NO, TRUE_FALSE, ON_OFF};
            MAP = new HashMap<String, MacroToken>();
            for (MacroToken macroToken : MacroToken.values()) {
                MAP.put(macroToken.token, macroToken);
            }
        }
    }

    private static enum StringCase {
        UPPER,
        LOWER;

    }

    private static class StringFormat
    extends BasicFormat {
        final StringCase stringCase;
        final String literal;
        final JavaFormat javaFormat;

        StringFormat(StringCase stringCase, String literal, Locale locale) {
            assert (stringCase != null);
            this.stringCase = stringCase;
            this.literal = literal;
            this.javaFormat = new JavaFormat(locale);
        }

        @Override
        void format(String s, StringBuilder buf) {
            switch (this.stringCase) {
                case UPPER: {
                    s = s.toUpperCase();
                    break;
                }
                case LOWER: {
                    s = s.toLowerCase();
                }
            }
            buf.append(s);
        }

        @Override
        void format(double d, StringBuilder buf) {
            int x = buf.length();
            this.javaFormat.format(d, buf);
            String s = buf.substring(x);
            buf.setLength(x);
            this.format(s, buf);
        }

        @Override
        void format(long n, StringBuilder buf) {
            int x = buf.length();
            this.javaFormat.format(n, buf);
            String s = buf.substring(x);
            buf.setLength(x);
            this.format(s, buf);
        }

        @Override
        void format(Date date, StringBuilder buf) {
            int x = buf.length();
            this.javaFormat.format(date, buf);
            String s = buf.substring(x);
            buf.setLength(x);
            this.format(s, buf);
        }

        @Override
        void format(Calendar calendar, StringBuilder buf) {
            int x = buf.length();
            this.javaFormat.format(calendar, buf);
            String s = buf.substring(x);
            buf.setLength(x);
            this.format(s, buf);
        }
    }

    public static class FormatLocale {
        char thousandSeparator;
        char decimalPlaceholder;
        String dateSeparator;
        String timeSeparator;
        String currencySymbol;
        String currencyFormat;
        String[] daysOfWeekShort;
        String[] daysOfWeekLong;
        String[] monthsShort;
        String[] monthsLong;
        private final Locale locale;

        private FormatLocale(char thousandSeparator, char decimalPlaceholder, String dateSeparator, String timeSeparator, String currencySymbol, String currencyFormat, String[] daysOfWeekShort, String[] daysOfWeekLong, String[] monthsShort, String[] monthsLong, Locale locale) {
            this.locale = locale;
            if (thousandSeparator == '\u0000') {
                thousandSeparator = (char)44;
            }
            this.thousandSeparator = thousandSeparator;
            if (decimalPlaceholder == '\u0000') {
                decimalPlaceholder = (char)46;
            }
            this.decimalPlaceholder = decimalPlaceholder;
            if (dateSeparator == null) {
                dateSeparator = Format.dateSeparator_en;
            }
            this.dateSeparator = dateSeparator;
            if (timeSeparator == null) {
                timeSeparator = Format.timeSeparator_en;
            }
            this.timeSeparator = timeSeparator;
            if (currencySymbol == null) {
                currencySymbol = Format.currencySymbol_en;
            }
            this.currencySymbol = currencySymbol;
            if (currencyFormat == null) {
                currencyFormat = Format.currencyFormat_en;
            }
            this.currencyFormat = currencyFormat;
            if (daysOfWeekShort == null) {
                daysOfWeekShort = daysOfWeekShort_en;
            }
            this.daysOfWeekShort = daysOfWeekShort;
            if (daysOfWeekLong == null) {
                daysOfWeekLong = daysOfWeekLong_en;
            }
            this.daysOfWeekLong = daysOfWeekLong;
            if (monthsShort == null) {
                monthsShort = monthsShort_en;
            }
            this.monthsShort = monthsShort;
            if (monthsLong == null) {
                monthsLong = monthsLong_en;
            }
            this.monthsLong = monthsLong;
            if (daysOfWeekShort.length != 8 || daysOfWeekLong.length != 8 || monthsShort.length != 13 || monthsLong.length != 13) {
                throw new IllegalArgumentException("Format: day or month array has incorrect length");
            }
        }
    }

    static class DateFormat
    extends FallbackFormat {
        FormatLocale locale;
        boolean twelveHourClock;

        DateFormat(int code, String s, FormatLocale locale, boolean twelveHourClock) {
            super(code, s);
            this.locale = locale;
            this.twelveHourClock = twelveHourClock;
        }

        @Override
        FormatType getFormatType() {
            return FormatType.DATE;
        }

        void setTwelveHourClock(boolean twelveHourClock) {
            this.twelveHourClock = twelveHourClock;
        }

        @Override
        void format(Calendar calendar, StringBuilder buf) {
            this.format(this.code, calendar, buf);
        }

        private void format(int code, Calendar calendar, StringBuilder buf) {
            switch (code) {
                case 3: {
                    boolean timeSet;
                    boolean dateSet = calendar.get(6) != 0 || calendar.get(1) != 0;
                    boolean bl = timeSet = calendar.get(13) != 0 || calendar.get(12) != 0 || calendar.get(10) != 0;
                    if (dateSet) {
                        this.format(8, calendar, buf);
                    }
                    if (dateSet && timeSet) {
                        buf.append(' ');
                    }
                    if (!timeSet) break;
                    this.format(26, calendar, buf);
                    break;
                }
                case 4: {
                    int d = calendar.get(5);
                    buf.append(d);
                    break;
                }
                case 5: {
                    int d = calendar.get(5);
                    if (d < 10) {
                        buf.append('0');
                    }
                    buf.append(d);
                    break;
                }
                case 6: {
                    int dow = calendar.get(7);
                    buf.append(this.locale.daysOfWeekShort[dow]);
                    break;
                }
                case 7: {
                    int dow = calendar.get(7);
                    buf.append(this.locale.daysOfWeekLong[dow]);
                    break;
                }
                case 8: {
                    this.format(12, calendar, buf);
                    buf.append(this.locale.dateSeparator);
                    this.format(4, calendar, buf);
                    buf.append(this.locale.dateSeparator);
                    this.format(18, calendar, buf);
                    break;
                }
                case 9: {
                    this.format(15, calendar, buf);
                    buf.append(" ");
                    this.format(5, calendar, buf);
                    buf.append(", ");
                    this.format(19, calendar, buf);
                    break;
                }
                case 10: {
                    int dow = calendar.get(7);
                    buf.append(dow);
                    break;
                }
                case 11: {
                    int woy = calendar.get(3);
                    buf.append(woy);
                    break;
                }
                case 12: 
                case 62: {
                    int m = calendar.get(2) + 1;
                    buf.append(m);
                    break;
                }
                case 13: 
                case 58: {
                    int mm = calendar.get(2) + 1;
                    if (mm < 10) {
                        buf.append('0');
                    }
                    buf.append(mm);
                    break;
                }
                case 14: 
                case 55: {
                    int m = calendar.get(2);
                    buf.append(this.locale.monthsShort[m]);
                    break;
                }
                case 15: 
                case 56: 
                case 59: 
                case 60: {
                    int m = calendar.get(2);
                    buf.append(this.locale.monthsLong[m]);
                    break;
                }
                case 16: {
                    int m = calendar.get(2);
                    int q = m / 3 + 1;
                    buf.append(q);
                    break;
                }
                case 17: {
                    int doy = calendar.get(6);
                    buf.append(doy);
                    break;
                }
                case 18: {
                    int y = calendar.get(1) % 100;
                    if (y < 10) {
                        buf.append('0');
                    }
                    buf.append(y);
                    break;
                }
                case 19: {
                    int y = calendar.get(1);
                    buf.append(y);
                    break;
                }
                case 20: {
                    int h = calendar.get(this.twelveHourClock ? 10 : 11);
                    buf.append(h);
                    break;
                }
                case 21: 
                case 61: {
                    int h = calendar.get(this.twelveHourClock ? 10 : 11);
                    if (h < 10) {
                        buf.append('0');
                    }
                    buf.append(h);
                    break;
                }
                case 22: {
                    int n = calendar.get(12);
                    buf.append(n);
                    break;
                }
                case 23: {
                    int n = calendar.get(12);
                    if (n < 10) {
                        buf.append('0');
                    }
                    buf.append(n);
                    break;
                }
                case 24: {
                    int s = calendar.get(13);
                    buf.append(s);
                    break;
                }
                case 25: {
                    int s = calendar.get(13);
                    if (s < 10) {
                        buf.append('0');
                    }
                    buf.append(s);
                    break;
                }
                case 26: {
                    this.format(20, calendar, buf);
                    buf.append(this.locale.timeSeparator);
                    this.format(23, calendar, buf);
                    buf.append(this.locale.timeSeparator);
                    this.format(25, calendar, buf);
                    break;
                }
                case 27: 
                case 31: {
                    boolean isAm = calendar.get(9) == 0;
                    buf.append(isAm ? "AM" : "PM");
                    break;
                }
                case 28: {
                    boolean isAm = calendar.get(9) == 0;
                    buf.append(isAm ? "am" : "pm");
                    break;
                }
                case 29: {
                    boolean isAm = calendar.get(9) == 0;
                    buf.append(isAm ? "A" : "P");
                    break;
                }
                case 30: {
                    boolean isAm = calendar.get(9) == 0;
                    buf.append(isAm ? "a" : "p");
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }

    static class NumericFormat
    extends JavaFormat {
        final FormatLocale locale;
        final int digitsLeftOfPoint;
        final int zeroesLeftOfPoint;
        final int digitsRightOfPoint;
        final int zeroesRightOfPoint;
        final int digitsRightOfExp;
        final int zeroesRightOfExp;
        int decimalShift;
        final char expChar;
        final boolean expSign;
        final boolean useDecimal;
        final boolean useThouSep;
        final ArrayStack<Integer> cachedThousandSeparatorPositions;

        NumericFormat(String token, FormatLocale locale, int expFormat, int digitsLeftOfPoint, int zeroesLeftOfPoint, int digitsRightOfPoint, int zeroesRightOfPoint, int digitsRightOfExp, int zeroesRightOfExp, boolean useDecimal, boolean useThouSep, String formatString) {
            super(locale.locale);
            this.locale = locale;
            switch (expFormat) {
                case 39: {
                    this.expChar = (char)69;
                    this.expSign = false;
                    break;
                }
                case 40: {
                    this.expChar = (char)69;
                    this.expSign = true;
                    break;
                }
                case 41: {
                    this.expChar = (char)101;
                    this.expSign = false;
                    break;
                }
                case 42: {
                    this.expChar = (char)101;
                    this.expSign = true;
                    break;
                }
                default: {
                    this.expChar = '\u0000';
                    this.expSign = false;
                }
            }
            this.digitsLeftOfPoint = digitsLeftOfPoint;
            this.zeroesLeftOfPoint = zeroesLeftOfPoint;
            this.digitsRightOfPoint = digitsRightOfPoint;
            this.zeroesRightOfPoint = zeroesRightOfPoint;
            this.digitsRightOfExp = digitsRightOfExp;
            this.zeroesRightOfExp = zeroesRightOfExp;
            this.useDecimal = useDecimal;
            this.useThouSep = useThouSep;
            this.decimalShift = 0;
            formatString = MacroToken.expand(locale, formatString);
            if (thousandSeparatorTokenMap.containsKey(formatString)) {
                this.cachedThousandSeparatorPositions = (ArrayStack)thousandSeparatorTokenMap.get(formatString);
            } else {
                String formatStringBuffer = formatString;
                int semiPos = formatStringBuffer.indexOf(Format.getFormatToken(51));
                if (semiPos > 0) {
                    formatStringBuffer = formatStringBuffer.substring(0, semiPos);
                }
                int nbThousandSeparators = this.countOccurrences(formatStringBuffer, Format.getFormatToken(36).charAt(0));
                this.cachedThousandSeparatorPositions = new ArrayStack();
                if (nbThousandSeparators > 1) {
                    int decimalPos = formatStringBuffer.indexOf(Format.getFormatToken(34));
                    int endIndex = decimalPos == -1 ? formatStringBuffer.length() : decimalPos;
                    String wholeFormat = formatStringBuffer.substring(0, endIndex);
                    StringTokenizer st = new StringTokenizer(wholeFormat, String.valueOf(Format.getFormatToken(36)));
                    st.nextToken();
                    while (st.hasMoreTokens()) {
                        this.cachedThousandSeparatorPositions.push(st.nextToken().length());
                    }
                } else if (nbThousandSeparators == 1) {
                    this.cachedThousandSeparatorPositions.add(3);
                }
                thousandSeparatorTokenMap.put(formatString, this.cachedThousandSeparatorPositions);
            }
        }

        @Override
        FormatType getFormatType() {
            return FormatType.NUMERIC;
        }

        private ArrayStack<Integer> getThousandSeparatorPositions() {
            return new ArrayStack<Integer>(this.cachedThousandSeparatorPositions);
        }

        private int countOccurrences(String s, char c) {
            char[] chars = s.toCharArray();
            int count = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != c) continue;
                ++count;
            }
            return count;
        }

        @Override
        void format(double n, StringBuilder buf) {
            MondrianFloatingDecimal fd = new MondrianFloatingDecimal(n);
            Format.shift(fd, this.decimalShift);
            int formatDigitsRightOfPoint = this.zeroesRightOfPoint + this.digitsRightOfPoint;
            if (n == 0.0 || n < 0.0 && !NumericFormat.shows(fd, formatDigitsRightOfPoint)) {
                fd = new MondrianFloatingDecimal(0.0);
            }
            Format.formatFd0(fd, buf, this.zeroesLeftOfPoint, this.locale.decimalPlaceholder, this.zeroesRightOfPoint, formatDigitsRightOfPoint, this.expChar, this.expSign, this.zeroesRightOfExp, this.useThouSep ? this.locale.thousandSeparator : (char)'\u0000', this.useDecimal, this.getThousandSeparatorPositions());
        }

        @Override
        boolean isApplicableTo(double n) {
            if (n >= 0.0) {
                return true;
            }
            MondrianFloatingDecimal fd = new MondrianFloatingDecimal(n);
            Format.shift(fd, this.decimalShift);
            int formatDigitsRightOfPoint = this.zeroesRightOfPoint + this.digitsRightOfPoint;
            return NumericFormat.shows(fd, formatDigitsRightOfPoint);
        }

        private static boolean shows(MondrianFloatingDecimal fd, int formatDigitsRightOfPoint) {
            int i0 = -fd.decExponent - formatDigitsRightOfPoint;
            if (i0 < 0) {
                return true;
            }
            if (i0 > 0) {
                return false;
            }
            return fd.digits[0] >= '5';
        }

        @Override
        void format(long n, StringBuilder buf) {
            MondrianFloatingDecimal fd = new MondrianFloatingDecimal(n);
            Format.shift(fd, this.decimalShift);
            Format.formatFd0(fd, buf, this.zeroesLeftOfPoint, this.locale.decimalPlaceholder, this.zeroesRightOfPoint, this.zeroesRightOfPoint + this.digitsRightOfPoint, this.expChar, this.expSign, this.zeroesRightOfExp, this.useThouSep ? this.locale.thousandSeparator : (char)'\u0000', this.useDecimal, this.getThousandSeparatorPositions());
        }
    }

    static abstract class FallbackFormat
    extends BasicFormat {
        final String token;

        FallbackFormat(int code, String token) {
            super(code);
            this.token = token;
        }

        @Override
        void format(double d, StringBuilder buf) {
            buf.append(this.token);
        }

        @Override
        void format(long n, StringBuilder buf) {
            buf.append(this.token);
        }

        @Override
        void format(String s, StringBuilder buf) {
            buf.append(this.token);
        }

        @Override
        void format(Calendar calendar, StringBuilder buf) {
            buf.append(this.token);
        }
    }

    static class JavaFormat
    extends BasicFormat {
        private final NumberFormat numberFormat;
        private final java.text.DateFormat dateFormat;

        JavaFormat(Locale locale) {
            this.numberFormat = NumberFormat.getNumberInstance(locale);
            this.dateFormat = java.text.DateFormat.getDateTimeInstance(3, 2, locale);
        }

        @Override
        void format(double d, StringBuilder buf) {
            buf.append(this.numberFormat.format(d));
        }

        @Override
        void format(long n, StringBuilder buf) {
            buf.append(this.numberFormat.format(n));
        }

        @Override
        void format(String s, StringBuilder buf) {
            buf.append(s);
        }

        @Override
        void format(Calendar calendar, StringBuilder buf) {
            buf.append(this.dateFormat.format(calendar.getTime()));
        }
    }

    static class CompoundFormat
    extends BasicFormat {
        final BasicFormat[] formats;

        CompoundFormat(BasicFormat[] formats) {
            this.formats = formats;
            assert (formats.length >= 2);
        }

        @Override
        void format(double v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        @Override
        void format(long v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        @Override
        void format(String v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        @Override
        void format(Date v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        @Override
        void format(Calendar v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        @Override
        boolean isApplicableTo(double n) {
            for (int i = 0; i < this.formats.length; ++i) {
                if (this.formats[i].isApplicableTo(n)) continue;
                return false;
            }
            return true;
        }
    }

    static class LiteralFormat
    extends BasicFormat {
        String s;

        LiteralFormat(String s) {
            this(43, s);
        }

        LiteralFormat(int code, String s) {
            super(code);
            this.s = s;
        }

        @Override
        void format(double d, StringBuilder buf) {
            buf.append(this.s);
        }

        @Override
        void format(long n, StringBuilder buf) {
            buf.append(this.s);
        }

        @Override
        void format(String str, StringBuilder buf) {
            buf.append(this.s);
        }

        @Override
        void format(Date date, StringBuilder buf) {
            buf.append(this.s);
        }

        @Override
        void format(Calendar calendar, StringBuilder buf) {
            buf.append(this.s);
        }
    }

    static class AlternateFormat
    extends BasicFormat {
        final BasicFormat[] formats;
        final JavaFormat javaFormat;

        AlternateFormat(BasicFormat[] formats, FormatLocale locale) {
            this.formats = formats;
            assert (formats.length >= 1);
            this.javaFormat = new JavaFormat(locale.locale);
        }

        @Override
        void formatNull(StringBuilder buf) {
            if (this.formats.length >= 4) {
                this.formats[3].format(0L, buf);
            } else {
                super.formatNull(buf);
            }
        }

        @Override
        void format(double n, StringBuilder buf) {
            int i;
            if (n == 0.0 && this.formats.length >= 3 && this.formats[2] != null) {
                i = 2;
            } else if (n < 0.0) {
                if (this.formats.length >= 2 && this.formats[1] != null) {
                    if (this.formats[1].isApplicableTo(n)) {
                        n = -n;
                        i = 1;
                    } else {
                        i = this.formats.length >= 3 && this.formats[2] != null ? 2 : 0;
                    }
                } else {
                    i = 0;
                    if (this.formats[0].isApplicableTo(n)) {
                        int size = buf.length();
                        buf.append('-');
                        n = -n;
                        this.formats[i].format(n, buf);
                        if (buf.substring(size, size + 2).equals("-|")) {
                            buf.setCharAt(size, '|');
                            buf.setCharAt(size + 1, '-');
                        }
                        return;
                    }
                    n = 0.0;
                }
            } else {
                i = 0;
            }
            this.formats[i].format(n, buf);
        }

        @Override
        void format(long n, StringBuilder buf) {
            int i;
            if (n == 0L && this.formats.length >= 3 && this.formats[2] != null) {
                i = 2;
            } else if (n < 0L) {
                if (this.formats.length >= 2 && this.formats[1] != null) {
                    if (this.formats[1].isApplicableTo(n)) {
                        n = -n;
                        i = 1;
                    } else {
                        i = this.formats.length >= 3 && this.formats[2] != null ? 2 : 0;
                    }
                } else {
                    i = 0;
                    if (this.formats[0].isApplicableTo(n)) {
                        int size = buf.length();
                        buf.append('-');
                        n = -n;
                        this.formats[i].format(n, buf);
                        if (buf.substring(size, size + 2).equals("-|")) {
                            buf.setCharAt(size, '|');
                            buf.setCharAt(size + 1, '-');
                        }
                        return;
                    }
                    n = 0L;
                }
            } else {
                i = 0;
            }
            this.formats[i].format(n, buf);
        }

        @Override
        void format(String s, StringBuilder buf) {
            buf.append(s);
        }

        @Override
        void format(Calendar calendar, StringBuilder buf) {
            BigDecimal bigDecimal = AlternateFormat.daysSince1900(calendar);
            this.format(bigDecimal.doubleValue(), buf);
        }

        private static BigDecimal daysSince1900(Calendar calendar) {
            long year;
            long dayOfYear = calendar.get(6);
            long yearForLeap = year = (long)calendar.get(1);
            if (calendar.get(2) < 2) {
                --yearForLeap;
            }
            long leapDays = (yearForLeap - 1900L) / 4L - (yearForLeap - 1900L) / 100L + (yearForLeap - 2000L) / 400L;
            long days = (year - 1900L) * 365L + leapDays + dayOfYear + 2L;
            long millis = calendar.get(11) * 3600000 + calendar.get(12) * 60000 + calendar.get(13) * 1000 + calendar.get(14);
            return BigDecimal.valueOf(days).add(BigDecimal.valueOf(millis).divide(BigDecimal.valueOf(86400000L), 8, 3));
        }
    }

    static class BasicFormat {
        final int code;

        BasicFormat() {
            this(0);
        }

        BasicFormat(int code) {
            this.code = code;
        }

        FormatType getFormatType() {
            return null;
        }

        void formatNull(StringBuilder buf) {
        }

        void format(double d, StringBuilder buf) {
            throw new Error();
        }

        void format(long n, StringBuilder buf) {
            throw new Error();
        }

        void format(String s, StringBuilder buf) {
            throw new Error();
        }

        void format(Date date, StringBuilder buf) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.format(calendar, buf);
        }

        void format(Calendar calendar, StringBuilder buf) {
            throw new Error();
        }

        boolean isApplicableTo(double n) {
            return true;
        }

        boolean isApplicableTo(long n) {
            return true;
        }
    }

    static class Token {
        final int code;
        final int flags;
        final String token;
        final FormatType formatType;

        Token(int code, int flags, String token) {
            this.code = code;
            this.flags = flags;
            this.token = token;
            this.formatType = this.isNumeric() ? FormatType.NUMERIC : (this.isDate() ? FormatType.DATE : (this.isString() ? FormatType.STRING : null));
        }

        boolean compatibleWith(FormatType formatType) {
            return formatType == null || this.formatType == null || formatType == this.formatType;
        }

        boolean isSpecial() {
            return (this.flags & 8) == 8;
        }

        boolean isNumeric() {
            return (this.flags & 2) == 2;
        }

        boolean isDate() {
            return (this.flags & 1) == 1;
        }

        boolean isString() {
            return (this.flags & 4) == 4;
        }

        FormatType getFormatType() {
            return this.formatType;
        }

        BasicFormat makeFormat(FormatLocale locale) {
            if (this.isDate()) {
                return new DateFormat(this.code, this.token, locale, false);
            }
            if (this.isNumeric()) {
                return new LiteralFormat(this.code, this.token);
            }
            return new LiteralFormat(this.token);
        }
    }
}

