/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import mondrian.rolap.SqlStatement;
import mondrian.spi.StatisticsProvider;

public interface Dialect {
    public String toUpper(String var1);

    public String caseWhenElse(String var1, String var2, String var3);

    public String quoteIdentifier(String var1);

    public void quoteIdentifier(String var1, StringBuilder var2);

    public String quoteIdentifier(String var1, String var2);

    public void quoteIdentifier(StringBuilder var1, String ... var2);

    public String getQuoteIdentifierString();

    public void quoteStringLiteral(StringBuilder var1, String var2);

    public void quoteNumericLiteral(StringBuilder var1, String var2);

    public void quoteBooleanLiteral(StringBuilder var1, String var2);

    public void quoteDateLiteral(StringBuilder var1, String var2);

    public void quoteTimeLiteral(StringBuilder var1, String var2);

    public void quoteTimestampLiteral(StringBuilder var1, String var2);

    public boolean requiresAliasForFromQuery();

    public boolean allowsAs();

    public boolean allowsFromQuery();

    public boolean allowsCompoundCountDistinct();

    public boolean allowsCountDistinct();

    public boolean allowsMultipleCountDistinct();

    public boolean allowsMultipleDistinctSqlMeasures();

    public boolean allowsCountDistinctWithOtherAggs();

    public String generateInline(List<String> var1, List<String> var2, List<String[]> var3);

    public boolean needsExponent(Object var1, String var2);

    public void quote(StringBuilder var1, Object var2, Datatype var3);

    public boolean allowsDdl();

    public String generateOrderItem(String var1, boolean var2, boolean var3, boolean var4);

    public boolean supportsGroupByExpressions();

    public boolean supportsGroupingSets();

    public boolean supportsUnlimitedValueList();

    public boolean requiresGroupByAlias();

    public boolean requiresOrderByAlias();

    public boolean requiresHavingAlias();

    public boolean allowsOrderByAlias();

    public boolean requiresUnionOrderByOrdinal();

    public boolean requiresUnionOrderByExprToBeInSelectClause();

    public boolean supportsMultiValueInExpr();

    public boolean supportsResultSetConcurrency(int var1, int var2);

    public int getMaxColumnNameLength();

    public DatabaseProduct getDatabaseProduct();

    public void appendHintsAfterFromClause(StringBuilder var1, Map<String, String> var2);

    public boolean allowsDialectSharing();

    public boolean allowsSelectNotInGroupBy();

    public boolean allowsJoinOn();

    public boolean allowsRegularExpressionInWhereClause();

    public String generateCountExpression(String var1);

    public String generateRegularExpression(String var1, String var2);

    public List<StatisticsProvider> getStatisticsProviders();

    public SqlStatement.Type getType(ResultSetMetaData var1, int var2) throws SQLException;

    public static enum Datatype {
        String{

            @Override
            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteStringLiteral(buf, value);
            }
        }
        ,
        Numeric{

            @Override
            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteNumericLiteral(buf, value);
            }

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        Integer{

            @Override
            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteNumericLiteral(buf, value);
            }

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        Boolean{

            @Override
            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteBooleanLiteral(buf, value);
            }
        }
        ,
        Date{

            @Override
            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteDateLiteral(buf, value);
            }
        }
        ,
        Time{

            @Override
            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteTimeLiteral(buf, value);
            }
        }
        ,
        Timestamp{

            @Override
            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteTimestampLiteral(buf, value);
            }
        };


        public abstract void quoteValue(StringBuilder var1, Dialect var2, String var3);

        public boolean isNumeric() {
            return false;
        }
    }

    public static enum DatabaseProduct {
        ACCESS,
        UNKNOWN,
        DERBY,
        DB2_OLD_AS400,
        DB2_AS400,
        DB2,
        FIREBIRD,
        GREENPLUM,
        HIVE,
        HSQLDB,
        IMPALA,
        INFORMIX,
        INFOBRIGHT,
        INGRES,
        INTERBASE,
        LUCIDDB,
        MSSQL,
        MONETDB,
        NETEZZA,
        NEOVIEW,
        NUODB,
        ORACLE,
        POSTGRESQL,
        REDSHIFT,
        MYSQL,
        SQLSTREAM,
        SYBASE,
        TERADATA,
        VERTICA,
        VECTORWISE;


        public DatabaseProduct getFamily() {
            switch (this) {
                case DB2_OLD_AS400: 
                case DB2_AS400: {
                    return DB2;
                }
            }
            return this;
        }

        public static DatabaseProduct getDatabaseProduct(String name) {
            for (DatabaseProduct databaseProduct : DatabaseProduct.values()) {
                if (!databaseProduct.name().equalsIgnoreCase(name)) continue;
                return databaseProduct;
            }
            return UNKNOWN;
        }
    }
}

