/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.TupleIterable;
import mondrian.calc.impl.AbstractIterCalc;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Query;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;

class AsFunDef
extends FunDefBase {
    public static final Resolver RESOLVER = new ResolverImpl();
    private final Query.ScopedNamedSet scopedNamedSet;

    private AsFunDef(Query.ScopedNamedSet scopedNamedSet) {
        super("AS", "<Expression> AS <Name>", "Assigns an alias to an expression", "ixxn");
        this.scopedNamedSet = scopedNamedSet;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        this.scopedNamedSet.setExp(call.getArg(0));
        return new AbstractIterCalc(call, new Calc[0]){

            @Override
            public TupleIterable evaluateIterable(Evaluator evaluator) {
                Evaluator.NamedSetEvaluator namedSetEvaluator = evaluator.getNamedSetEvaluator(AsFunDef.this.scopedNamedSet, false);
                return namedSetEvaluator.evaluateTupleIterable(evaluator);
            }
        };
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("AS", null, null, Syntax.Infix);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            Exp exp = args[0];
            if (!validator.canConvert(0, args[0], 8, conversions)) {
                return null;
            }
            String name = ((NamedSetExpr)args[1]).getNamedSet().getName();
            Query.ScopedNamedSet scopedNamedSet = (Query.ScopedNamedSet)((NamedSetExpr)args[1]).getNamedSet();
            return new AsFunDef(scopedNamedSet);
        }
    }
}

